/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.cost.DifferentiableCostFunction;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.OptimStatus;
import mitiv.optim.OptimTask;
import mitiv.optim.ReverseCommunicationOptimizer;
import mitiv.utils.Timer;

public class IterativeDifferentiableSolver {
    private VectorSpace space = null;
    private DifferentiableCostFunction cost = null;
    private ReverseCommunicationOptimizer optimizer = null;
    private Vector gx = null;
    private Vector xBest = null;
    private Vector gxBest = null;
    private double fx = -1.0;
    private double fxBest;
    private boolean firstTime = true;
    private boolean stepping = false;
    private boolean saveBest = false;
    private final Timer timer = new Timer();
    private boolean updatePending = false;
    private int iterations = 0;
    private int evaluations = 0;
    private int restarts = 0;
    private int maxeval = -1;
    private int maxiter = 200;

    public IterativeDifferentiableSolver(DifferentiableCostFunction cost, ReverseCommunicationOptimizer optimizer) {
        this.setComponents(cost, optimizer);
    }

    public IterativeDifferentiableSolver() {
    }

    public OptimTask start(Vector x) {
        return this.start(x, false);
    }

    public OptimTask start(Vector x, boolean reset) {
        if (this.optimizer == null) {
            throw new RuntimeException("Optimizer not yet specified");
        }
        if (this.cost == null) {
            throw new RuntimeException("Cost function not yet specified");
        }
        if (this.gx == null || this.gx.getSpace() != this.space) {
            this.gx = this.space.create();
        }
        if (!this.saveBest || this.xBest != null && this.xBest.getSpace() != this.space) {
            this.xBest = null;
        }
        if (!this.saveBest || this.gxBest != null && this.gxBest.getSpace() != this.space) {
            this.gxBest = null;
        }
        this.updatePending = false;
        this.firstTime = true;
        if (reset) {
            this.timer.start();
            this.timer.stop();
            this.iterations = 0;
            this.evaluations = 0;
            this.restarts = 0;
        }
        OptimTask task = this.optimizer.start();
        while (task == OptimTask.COMPUTE_FG) {
            task = this.computeFG(x);
            if (!this.stepping) continue;
            break;
        }
        return task;
    }

    public OptimTask iterate(Vector x) {
        if (this.updatePending) {
            return this.start(x, false);
        }
        OptimTask task = this.optimizer.getTask();
        if (task == OptimTask.ERROR || task == OptimTask.WARNING) {
            return task;
        }
        if (this.maxiter >= 0 && this.iterations >= this.maxiter) {
            return this.optimizer.warning(OptimStatus.TOO_MANY_ITERATIONS);
        }
        if (task == OptimTask.NEW_X || task == OptimTask.FINAL_X) {
            task = this.optimizer.iterate(x, this.fx, this.gx);
        }
        while (task == OptimTask.COMPUTE_FG) {
            task = this.computeFG(x);
            if (!this.stepping) continue;
        }
        if (task == OptimTask.NEW_X || task == OptimTask.FINAL_X) {
            ++this.iterations;
        }
        return task;
    }

    private OptimTask computeFG(Vector x) {
        if (this.maxeval >= 0 && this.evaluations >= this.maxeval) {
            return this.optimizer.warning(OptimStatus.TOO_MANY_EVALUATIONS);
        }
        int restarts = this.optimizer.getRestarts();
        this.timer.resume();
        this.fx = this.cost.computeCostAndGradient(1.0, x, this.gx, true);
        this.timer.stop();
        ++this.evaluations;
        restarts = this.optimizer.getRestarts() - restarts;
        if (restarts > 0) {
            this.restarts += restarts;
        }
        if (this.firstTime || this.fx < this.fxBest) {
            if (this.saveBest) {
                if (this.xBest == null) {
                    this.xBest = this.space.create();
                }
                this.xBest.copy(x);
            }
            this.fxBest = this.fx;
            this.firstTime = false;
        }
        return this.optimizer.iterate(x, this.fx, this.gx);
    }

    public double getCost() {
        return this.fx;
    }

    public Vector getBestSolution() {
        return this.xBest;
    }

    public double getBestCost() {
        return this.fxBest;
    }

    public Vector getGradient() {
        return this.gx;
    }

    public Vector getBestGradient() {
        return this.gxBest;
    }

    public boolean getStepping() {
        return this.stepping;
    }

    public void setStepping(boolean value) {
        this.stepping = value;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void resetIteration() {
        this.iterations = 0;
        this.evaluations = 0;
    }

    public int getEvaluations() {
        return this.evaluations;
    }

    public int getRestarts() {
        return this.restarts;
    }

    public double getElapsedTime() {
        return this.timer.getElapsedTime();
    }

    public int getMaximumEvaluations() {
        return this.maxeval;
    }

    public void setMaximumEvaluations(int value) {
        if (value < 0) {
            value = -1;
        }
        this.maxeval = value;
    }

    public int getMaximumIterations() {
        return this.maxiter;
    }

    public void setMaximumIterations(int value) {
        if (value < 0) {
            value = -1;
        }
        this.maxiter = value;
    }

    public ReverseCommunicationOptimizer getOptimizer() {
        return this.optimizer;
    }

    public void setOptimizer(ReverseCommunicationOptimizer optimizer) {
        this.setComponents(this.cost, optimizer);
    }

    public DifferentiableCostFunction getCostFunction() {
        return this.cost;
    }

    public void setCostFunction(DifferentiableCostFunction cost) {
        this.setComponents(cost, this.optimizer);
    }

    public VectorSpace getSpace() {
        return this.space;
    }

    public boolean getSaveBest() {
        return this.saveBest;
    }

    public void setSaveBest(boolean value) {
        this.saveBest = value;
    }

    private void setComponents(DifferentiableCostFunction cost, ReverseCommunicationOptimizer optimizer) {
        if (optimizer != this.optimizer || cost != this.cost) {
            if (cost != null && optimizer != null && cost.getInputSpace() != optimizer.getSpace()) {
                throw new IncorrectSpaceException("Optimizer and cost function must operate on the same vector space");
            }
            this.optimizer = optimizer;
            this.cost = cost;
            this.space = cost != null ? cost.getInputSpace() : (optimizer != null ? optimizer.getSpace() : null);
            this.updatePending = true;
        }
    }

    public String getReason() {
        if (this.optimizer == null) {
            return "Iterative algorithm not yet specified";
        }
        return this.optimizer.getReason();
    }

    public OptimTask getTask() {
        if (this.optimizer == null) {
            return OptimTask.ERROR;
        }
        return this.optimizer.getTask();
    }
}

