/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.base.indexing.Range;

public class Helper {
    static int fixSliceIndex(int slice, int rank) {
        if (slice < 0) {
            slice += rank;
        }
        if (slice < 0 || slice >= rank) {
            throw new IndexOutOfBoundsException("Slice index out of bounds.");
        }
        return slice;
    }

    static int fixIndex(int index, int dim) {
        if (index < 0) {
            index += dim;
        }
        if (index < 0 || index >= dim) {
            throw new IndexOutOfBoundsException("Index out of bounds.");
        }
        return index;
    }

    private static void badStepDirection() {
        throw new IllegalArgumentException("Bad step direction.");
    }

    private static void badEndPoints() {
        throw new IndexOutOfBoundsException("Range endpoints outside bounds.");
    }

    public static int[] select(int offset, int stride, int dim, int[] sel) {
        int length = sel.length;
        int[] result = new int[length];
        for (int j = 0; j < length; ++j) {
            int index = sel[j];
            if (index < 0 || index >= dim) {
                throw new IndexOutOfBoundsException("Selection index outside bounds.");
            }
            result[j] = offset + stride * index;
        }
        return result;
    }

    public static int[] select(int[] src, Range rng) {
        if (rng == null) {
            return src;
        }
        int length = src.length;
        int first = rng.getFirst(length);
        int last = rng.getLast(length);
        int step = rng.getStep();
        if (first <= last) {
            if (step < 0) {
                Helper.badStepDirection();
            }
            if (step == 0) {
                step = 1;
            }
            if (first == 0 && last == length - 1 && step == 1) {
                return src;
            }
            if (first < 0 || last >= length) {
                Helper.badEndPoints();
            }
            length = (last - first + 1) / step;
        } else {
            if (step > 0) {
                Helper.badStepDirection();
            }
            if (step == 0) {
                step = -1;
            }
            if (last < 0 || first >= length) {
                Helper.badEndPoints();
            }
            length = (first - last + 1) / -step;
        }
        int[] idx = new int[length];
        int j = 0;
        int k = first;
        while (j < length) {
            idx[j] = src[k];
            ++j;
            k += step;
        }
        return idx;
    }

    public static int[] select(int[] src, int[] sel) {
        if (sel == null) {
            return src;
        }
        int length = sel.length;
        int[] idx = new int[length];
        for (int j = 0; j < length; ++j) {
            idx[j] = src[sel[j]];
        }
        return idx;
    }
}

