package plugins.perrine.saveastiffast;

import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarSequence;


import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

import icy.common.listener.ProgressListener;
import icy.gui.frame.progress.AnnounceFrame;
import icy.imagej.ImageJUtil;
import icy.sequence.Sequence;

import ij.IJ;
import ij.ImagePlus;


public class SaveAsTifFast extends EzPlug {
	private EzVar<Sequence> inputseq=new EzVarSequence("Sequence to Save");
	private EzVarFile outputfile=new EzVarFile("Where to save as tif",null);
	@Override
	protected void initialize() {
		
		addEzComponent(inputseq);
		addEzComponent(outputfile);
	}

	@Override
	protected void execute() {
		// Obtain a TIFF writer
		
		ImagePlus tmpimp= ImageJUtil.convertToImageJImage(inputseq.getValue(), new ProgressListener() {

		@Override
		public boolean notifyProgress(double position,
				double length) {
			// TODO Auto-generated method stub
			return false;
		}
		});
		String mynamepath = outputfile.getValue().getPath();
		if (!mynamepath.endsWith(".tif")){
			mynamepath=mynamepath+".tif";
		}
		IJ.saveAsTiff(tmpimp,mynamepath);
		
		
		inputseq.getValue().saveXMLData();
		
		String inputxml=(inputseq.getValue().getOutputFilename(false)+".xml");
		String outputxml=mynamepath.replaceAll(".tif", ".xml");
		copyfile(inputxml,outputxml);
		new AnnounceFrame(inputseq.getValue().getName()+" has been saved as "+ mynamepath, 5);
		System.out.println(inputseq.getValue().getName()+" has been saved as "+ mynamepath);
	}

	private static boolean copyfile(String inputxml, String outputxml) { 
    try { 
    	Path inputxmlPath = Paths.get(inputxml);
    	Path outputxmlPath=Paths.get(outputxml);;
    	
        Files.copy(inputxmlPath, outputxmlPath); 
        
    } catch (IOException e) { 
        e.printStackTrace(); 
        return false; 
    } 
    return true; 
}

	@Override
	public void clean() {
		// TODO Auto-generated by Icy4Eclipse
	}
}
