package plugins.perrine.PDMandPearsonColocalization;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;

import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;

import icy.image.colormap.LinearColorMap;
import icy.math.ArrayMath;
import icy.math.Scaler;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import icy.sequence.SequenceUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarSequence;

/**
 * 
 * @author paul-gilloteaux-p
 *
 */

public class PDMandPearsonColocalization extends EzPlug {

	private EzVar<Sequence> inputG=new EzVarSequence("Channel 1");
	private EzVar<Sequence> inputR=new EzVarSequence("Channel 2");
	private EzVarBoolean roistoprocess= new EzVarBoolean("Study colocalization ROI per ROI (Rois on Channel 1)", false);
	private EzLabel versioninfo = new EzLabel("Version " +this.getDescriptor().getVersion()+". Click question mark for help and tutorial");
	private double Pearson;
	@Override
	protected void initialize() {
		// TODO Auto-generated by Icy4Eclipse
		//PDM is simply (as defined in LI et al,
		//(redintensity -mean red intensity )x green intensity - mean green intensity)
		addEzComponent(versioninfo);
		addEzComponent(inputG);
		addEzComponent(inputR);
		addEzComponent(roistoprocess);
		new AnnounceFrame("Please check the webpage for information how to use", 5);
	}

	@Override
	protected void execute() {
		// TODO Auto-generated by Icy4Eclipse
		Sequence result=new Sequence("LI-PDM");
		Scaler[] scalerG= {new Scaler(inputG.getValue().getChannelMin(0), inputG.getValue().getChannelMax(0),0, 1, true)};
		Scaler[] scalerR= {new Scaler(inputR.getValue().getChannelMin(0), inputR.getValue().getChannelMax(0),0, 1, true)};
		Sequence sequenceG=SequenceUtil.convertType(inputG.getValue(),DataType.FLOAT, scalerG);
		Sequence sequenceR=SequenceUtil.convertType(inputR.getValue(),DataType.FLOAT, scalerR);
		if (roistoprocess.getValue()==true){
			IcyBufferedImage image = new IcyBufferedImage(sequenceR.getSizeX(),sequenceR.getSizeY(),2, DataType.FLOAT);
			try
			{
				
					
					result.setImage(0, 0, image);
					
				
			
			
			ArrayList<ROI> Roilist = inputG.getValue().getROIs();
			if (Roilist.isEmpty()){
				MessageDialog.showDialog("No Rois found on "+inputG.getValue().getName());
				return;
			}
			Iterator<ROI> itroi = Roilist.iterator();
			while (itroi.hasNext()){
				ROI myroi = itroi.next();
				computePDMandPearsonRoi(sequenceG, sequenceR, myroi,result);
				System.out.println("Pearson between "+sequenceG.getName()+" and " +sequenceR.getName()+ "for ROI "+myroi.getName()+" is "+Pearson);
			}
			result.updateChannelsBounds();
			}
			finally
			{
				result.endUpdate();
				
			}
			
			
			
		}
		else{
		result.beginUpdate();
		try
		{
			
			for (int t=0;t<sequenceR.getSizeT();t++){
				for (int z=0;z<sequenceR.getSizeZ();z++){
				IcyBufferedImage image= computePDMandPearson(sequenceR,sequenceG,t,z);
				result.setImage(t, z, image);
				System.out.println("Pearson between "+sequenceG.getName()+" and " +sequenceR.getName()+ "is "+Pearson);
				}
			}
		}
		finally
		{
			result.endUpdate();
		}
		}
		result.setColormap(0,new LinearColorMap("Yellow", Color.yellow));
		result.setColormap(1,new LinearColorMap("Magenta", Color.magenta));
		result.setChannelName(0, " Positive");
		result.setChannelName(1, " Negative");
		
		
		addSequence(result);
		
		
	}

	private void computePDMandPearsonRoi(Sequence sequenceG, Sequence sequenceR, ROI myroi, Sequence result) {
		SequenceDataIterator iteG = new SequenceDataIterator(sequenceG,myroi);
		SequenceDataIterator iteR = new SequenceDataIterator(sequenceR,myroi);
		
		int i=0;
		double[] imgArrayR= new double[(int) myroi.getNumberOfPoints()];
		double[] imgArrayG= new double[(int) myroi.getNumberOfPoints()];
		while (!iteG.done()){
			imgArrayG[i]=(float)iteG.get();
			imgArrayR[i]=(float)iteR.get();
			iteG.next();
			iteR.next();
			i++;
		}
		
		Pearson=ArrayMath.correlationPearson(imgArrayG, imgArrayR);
		double meanR=ArrayMath.mean(imgArrayR);
		double meanG=ArrayMath.mean(imgArrayG);	
		
		double[] tmpR=ArrayMath.subtract(imgArrayR, meanR);
		double[] tmpG=ArrayMath.subtract(imgArrayG, meanG);
		
		double[] PDMimage = ArrayMath.multiply(tmpR, tmpG);
		double[] PDMimagePos=getpospart(PDMimage);
		double[] PDMimageNeg=getnegpart(PDMimage);
		
		i=0;
		
		SequenceDataIterator itepos= new SequenceDataIterator(result,myroi,false,0,0,0);
		SequenceDataIterator iteneg= new SequenceDataIterator(result,myroi,false,0,0,1);
		
		while (!itepos.done()){
			itepos.set(PDMimagePos[i]);
			iteneg.set(PDMimageNeg[i]);
			itepos.next();
			iteneg.next();
			i++;
		}
		
		
	}

	private IcyBufferedImage computePDMandPearson(Sequence sequenceR, Sequence sequenceG, int t, int z) {
		IcyBufferedImage result = new IcyBufferedImage(sequenceR.getSizeX(),sequenceR.getSizeY(),2, DataType.FLOAT);
		
		
		
		Object dataArrayR=sequenceR.getDataXY(t, z, 0);
		Object dataArrayG=sequenceG.getDataXY(t, z, 0);
			
			
		double[] imgArrayR=Array1DUtil.arrayToDoubleArray(dataArrayR, sequenceR.isSignedDataType());
		double[] imgArrayG=Array1DUtil.arrayToDoubleArray(dataArrayG, sequenceG.isSignedDataType());
		Pearson=ArrayMath.correlationPearson(imgArrayG, imgArrayR);
		double meanR=ArrayMath.mean(imgArrayR);
		double meanG=ArrayMath.mean(imgArrayG);	
		
		double[] tmpR=ArrayMath.subtract(imgArrayR, meanR);
		double[] tmpG=ArrayMath.subtract(imgArrayG, meanG);
		
		double[] PDMimage = ArrayMath.multiply(tmpR, tmpG);
		double[] PDMimagePos=getpospart(PDMimage);
		double[] PDMimageNeg=getnegpart(PDMimage);
		
		Array1DUtil.doubleArrayToArray(PDMimagePos,result.getDataXY(0));
		Array1DUtil.doubleArrayToArray(PDMimageNeg,result.getDataXY(1));
		result.dataChanged();
		return result;
	}

	private double[] getnegpart(double[] pDMimage) {
		double[] result=pDMimage.clone();
		for (int i=0;i<result.length;i++){
			if(pDMimage[i]>0){
				result[i]=0;
			}
			else{
				result[i]=-result[i];
			}
		}
		return result;
	}

	private double[] getpospart(double[] pDMimage) {
		double[] result=pDMimage.clone();
		for (int i=0;i<result.length;i++){
			if(pDMimage[i]<0)
				result[i]=0;
		}
		return result;
	}

	@Override
	public void clean() {
		// TODO Auto-generated by Icy4Eclipse
	}
}
