package plugins.adufour.blocks.tools.sequence;

import icy.canvas.Canvas2D;
import icy.gui.viewer.Viewer;
import icy.plugin.abstract_.Plugin;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarSequence;

public class SequenceScreenshot extends Plugin implements SequenceBlock
{
    private VarSequence seq    = new VarSequence("Sequence", null);
    
    private VarSequence seqOut = new VarSequence("Screenshot", null);
    
    @Override
    public void run()
    {
        final Sequence in = seq.getValue();
        final int time = in.getSizeT();
        final int depth = in.getSizeZ();
        final Sequence out = new Sequence("Screenshot of " + in.getName());
        
        ThreadUtil.invokeNow(new Runnable()
        {
            @Override
            public void run()
            {
                Viewer viewer = new Viewer(in, false);
                //Canvas2D canvas = new Canvas2D(viewer);
                viewer.setCanvas(Canvas2D.class.getName());
                
                for (int t = 0; t < time; t++)
                    for (int z = 0; z < depth; z++)
                    {
                        out.setImage(t, z, viewer.getCanvas().getRenderedImage(t, z, -1, false));
                    }
                viewer.close();
                
            }
        });
        
        seqOut.setValue(out);
    }
    
    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("input sequence", seq);
    }
    
    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add("screenshot", seqOut);
    }
}
