/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.g723;

import com.ibm.media.codec.audio.BufferedEncoder;
import com.sun.media.JMFSecurityManager;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class NativeEncoder
extends BufferedEncoder {
    int nativeData;
    private int sample_count = 240;
    private long currentSeq = (long)((double)System.currentTimeMillis() * Math.random());
    private long timestamp = 0L;
    byte[] pendingBuffer = null;

    private native void initNative();

    private native void freeNative();

    private native void resetNative();

    protected native boolean codecProcess(byte[] var1, int var2, byte[] var3, int var4, int var5, int[] var6, int[] var7, int[] var8, int[] var9, int[] var10);

    public NativeEncoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("g723")};
        this.PLUGIN_NAME = "G723 Encoder";
        this.historySize = 480;
        this.pendingFrames = 0;
        this.packetSize = 24;
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("g723", af.getSampleRate(), -1, 1, -1, -1, 192, -1.0, Format.byteArray)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmg723");
            this.initNative();
            return;
        }
        catch (Throwable t) {
            System.err.println("can not load " + this.PLUGIN_NAME);
            System.err.println("reason : " + t);
            throw new ResourceUnavailableException("can not load " + this.PLUGIN_NAME);
        }
    }

    public void close() {
        this.freeNative();
    }

    public void codecReset() {
        this.resetNative();
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        int retVal = super.process(inputBuffer, outputBuffer);
        if (this.outputFormat.getEncoding().equals("g723/rtp")) {
            if (retVal == 1) {
                return retVal;
            }
            if (this.isEOM(inputBuffer)) {
                this.propagateEOM(outputBuffer);
                return 0;
            }
            if (this.pendingFrames == 0) {
                this.pendingBuffer = (byte[])outputBuffer.getData();
            }
            byte[] outData = new byte[this.packetSize];
            outputBuffer.setData(outData);
            this.updateOutput(outputBuffer, this.outputFormat, this.packetSize, 0);
            outputBuffer.setSequenceNumber(this.currentSeq++);
            outputBuffer.setTimeStamp(this.timestamp);
            this.timestamp += (long)this.sample_count;
            System.arraycopy(this.pendingBuffer, this.regions[this.pendingFrames], outData, 0, this.packetSize);
            if (this.pendingFrames + 1 == this.frameNumber[0]) {
                this.pendingFrames = 0;
                this.pendingBuffer = null;
                return 0;
            }
            ++this.pendingFrames;
            return 2;
        }
        return retVal;
    }

    protected int calculateOutputSize(int inputSize) {
        return this.calculateFramesNumber(inputSize) * 24;
    }

    protected int calculateFramesNumber(int inputSize) {
        return inputSize / 480;
    }
}

