/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Int1D;
import mitiv.array.IntScalar;
import mitiv.array.impl.Helper;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.random.IntGenerator;

public class SelectedInt1D
extends Int1D {
    static final int order = 0;
    final int[] data;
    final int[] idx1;

    public SelectedInt1D(int[] arr, int[] idx1) {
        super(idx1.length);
        this.data = arr;
        this.idx1 = idx1;
    }

    @Override
    public final void checkSanity() {
        int indexMax;
        int offsetMin = 0;
        int offsetMax = 0;
        int indexMin = indexMax = this.idx1[0];
        for (int i1 = 1; i1 < this.dim1; ++i1) {
            int index = this.idx1[i1];
            if (index < indexMin) {
                indexMin = index;
            }
            if (index <= indexMax) continue;
            indexMax = index;
        }
        if ((offsetMin += indexMin) < 0 || (offsetMax += indexMax) >= this.data.length) {
            throw new IndexOutOfBoundsException("Selected indices are out of bounds");
        }
    }

    final int index(int i1) {
        return this.idx1[i1];
    }

    @Override
    public final int get(int i1) {
        return this.data[this.idx1[i1]];
    }

    @Override
    public final void set(int i1, int value) {
        this.data[this.idx1[i1]] = value;
    }

    @Override
    public final int getOrder() {
        return 0;
    }

    @Override
    public void fill(int value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.idx1[i1];
            this.data[j1] = value;
        }
    }

    @Override
    public void fill(IntGenerator generator) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.idx1[i1];
            this.data[j1] = generator.nextInt();
        }
    }

    @Override
    public void increment(int value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1;
            int n = j1 = this.idx1[i1];
            this.data[n] = this.data[n] + value;
        }
    }

    @Override
    public void decrement(int value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1;
            int n = j1 = this.idx1[i1];
            this.data[n] = this.data[n] - value;
        }
    }

    @Override
    public void scale(int value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1;
            int n = j1 = this.idx1[i1];
            this.data[n] = this.data[n] * value;
        }
    }

    @Override
    public void map(IntFunction function) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.idx1[i1];
            this.data[j1] = function.apply(this.data[j1]);
        }
    }

    @Override
    public void scan(IntScanner scanner) {
        boolean initialized = false;
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.idx1[i1];
            if (initialized) {
                scanner.update(this.data[j1]);
                continue;
            }
            scanner.initialize(this.data[j1]);
            initialized = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return false;
    }

    @Override
    public int[] flatten(boolean forceCopy) {
        int[] out = new int[this.number];
        int j = -1;
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.idx1[i1];
            out[++j] = this.data[j1];
        }
        return out;
    }

    @Override
    public int[] getData() {
        return null;
    }

    @Override
    public IntScalar slice(int idx) {
        return new IntScalar(this.data, this.idx1[Helper.fixIndex(idx, this.dim1)]);
    }

    @Override
    public IntScalar slice(int idx, int dim) {
        Helper.fixSliceIndex(dim, 1);
        return new IntScalar(this.data, Helper.fixIndex(idx, this.dim1));
    }

    @Override
    public Int1D view(Range rng1) {
        int[] viewIndex1 = Helper.select(this.idx1, rng1);
        if (viewIndex1 == this.idx1) {
            return this;
        }
        return new SelectedInt1D(this.data, viewIndex1);
    }

    @Override
    public Int1D view(int[] sel1) {
        int[] viewIndex1 = Helper.select(this.idx1, sel1);
        if (viewIndex1 == this.idx1) {
            return this;
        }
        return new SelectedInt1D(this.data, viewIndex1);
    }

    @Override
    public Int1D as1D() {
        return this;
    }
}

