/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.shapes;

import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.shapes.AABox;
import net.phys2d.raw.shapes.AbstractShape;
import net.phys2d.raw.shapes.DynamicShape;

public strictfp class Line
extends AbstractShape
implements DynamicShape {
    private ROVector2f start;
    private ROVector2f end;
    private Vector2f vec;
    private float lenSquared;
    private Vector2f loc = new Vector2f(0.0f, 0.0f);
    private Vector2f v = new Vector2f(0.0f, 0.0f);
    private Vector2f v2 = new Vector2f(0.0f, 0.0f);
    private Vector2f proj = new Vector2f(0.0f, 0.0f);
    private Vector2f closest = new Vector2f(0.0f, 0.0f);
    private Vector2f other = new Vector2f(0.0f, 0.0f);
    private boolean outerEdge = true;
    private boolean innerEdge = true;

    public Line(float x, float y, boolean inner, boolean outer) {
        this(0.0f, 0.0f, x, y);
        this.setBlocksInnerEdge(inner);
        this.setBlocksOuterEdge(outer);
    }

    public Line(float x, float y) {
        this(x, y, true, true);
    }

    public Line(float x1, float y1, float x2, float y2) {
        this(new Vector2f(x1, y1), new Vector2f(x2, y2));
    }

    public Line(ROVector2f start, ROVector2f end) {
        float radius = Math.max(start.length(), end.length());
        this.bounds = new AABox(0.0f, 0.0f, radius * 2.0f, radius * 2.0f);
        this.set(start, end);
    }

    public boolean blocksInnerEdge() {
        return this.innerEdge;
    }

    public void setBlocksInnerEdge(boolean innerEdge) {
        this.innerEdge = innerEdge;
    }

    public boolean blocksOuterEdge() {
        return this.outerEdge;
    }

    public void setBlocksOuterEdge(boolean outerEdge) {
        this.outerEdge = outerEdge;
    }

    public ROVector2f getStart() {
        return this.start;
    }

    public ROVector2f getEnd() {
        return this.end;
    }

    public float length() {
        return this.vec.length();
    }

    public float lengthSquared() {
        return this.vec.lengthSquared();
    }

    public void set(ROVector2f start, ROVector2f end) {
        this.start = start;
        this.end = end;
        this.vec = new Vector2f(end);
        this.vec.sub(start);
        this.lenSquared = this.vec.length();
        this.lenSquared *= this.lenSquared;
    }

    public float getDX() {
        return this.end.getX() - this.start.getX();
    }

    public float getDY() {
        return this.end.getY() - this.start.getY();
    }

    public float getX1() {
        return this.start.getX();
    }

    public float getY1() {
        return this.start.getY();
    }

    public float getX2() {
        return this.end.getX();
    }

    public float getY2() {
        return this.end.getY();
    }

    public float distance(ROVector2f point) {
        return (float)Math.sqrt(this.distanceSquared(point));
    }

    public float distanceSquared(ROVector2f point) {
        this.getClosestPoint(point, this.closest);
        this.closest.sub(point);
        float result = this.closest.lengthSquared();
        return result;
    }

    public void getClosestPoint(ROVector2f point, Vector2f result) {
        this.loc.set(point);
        this.loc.sub(this.start);
        this.v.set(this.vec);
        this.v2.set(this.vec);
        this.v2.scale(-1.0f);
        this.v.normalise();
        this.loc.projectOntoUnit(this.v, this.proj);
        if (this.proj.lengthSquared() > this.vec.lengthSquared()) {
            result.set(this.end);
            return;
        }
        this.proj.add(this.start);
        this.other.set(this.proj);
        this.other.sub(this.end);
        if (this.other.lengthSquared() > this.vec.lengthSquared()) {
            result.set(this.start);
            return;
        }
        result.set(this.proj);
    }

    public float getSurfaceFactor() {
        return this.lengthSquared() / 2.0f;
    }

    public Line getPositionedLine(ROVector2f displacement, float rotation) {
        Vector2f[] verts = this.getVertices(displacement, rotation);
        Line line = new Line(verts[0], verts[1]);
        return line;
    }

    public Vector2f[] getVertices(ROVector2f displacement, float rotation) {
        float cos = (float)Math.cos(rotation);
        float sin = (float)Math.sin(rotation);
        Vector2f[] endPoints = new Vector2f[2];
        endPoints[0] = new Vector2f(this.getX1() * cos - this.getY1() * sin, this.getY1() * cos + this.getX1() * sin);
        endPoints[0].add(displacement);
        endPoints[1] = new Vector2f(this.getX2() * cos - this.getY2() * sin, this.getY2() * cos + this.getX2() * sin);
        endPoints[1].add(displacement);
        return endPoints;
    }

    public void move(ROVector2f v) {
        Vector2f temp = new Vector2f(this.start);
        temp.add(v);
        this.start = temp;
        temp = new Vector2f(this.end);
        temp.add(v);
        this.end = temp;
    }

    public String toString() {
        return "[Line " + this.start + "," + this.end + "]";
    }

    public Vector2f intersect(Line other) {
        float dx1 = this.end.getX() - this.start.getX();
        float dx2 = other.end.getX() - other.start.getX();
        float dy1 = this.end.getY() - this.start.getY();
        float dy2 = other.end.getY() - other.start.getY();
        float denom = dy2 * dx1 - dx2 * dy1;
        if (denom == 0.0f) {
            return null;
        }
        float ua = dx2 * (this.start.getY() - other.start.getY()) - dy2 * (this.start.getX() - other.start.getX());
        float ub = dx1 * (this.start.getY() - other.start.getY()) - dy1 * (this.start.getX() - other.start.getX());
        ub /= denom;
        float u = ua /= denom;
        float ix = this.start.getX() + u * (this.end.getX() - this.start.getX());
        float iy = this.start.getY() + u * (this.end.getY() - this.start.getY());
        return new Vector2f(ix, iy);
    }
}

