/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.map.tlong.AbstractLongLongMap;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix2D;

class SelectedSparseLongMatrix1D
extends LongMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongLongMap elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseLongMatrix1D(AbstractLongLongMap elements, int[] offsets) {
        this(offsets.length, elements, 0, 1, offsets, 0);
    }

    protected SelectedSparseLongMatrix1D(int size, AbstractLongLongMap elements, int zero, int stride, int[] offsets, int offset) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.offsets = offsets;
        this.offset = offset;
        this.isNoView = false;
    }

    @Override
    public AbstractLongLongMap elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public long getQuick(int index) {
        return this.elements.get((long)this.offset + (long)this.offsets[this.zero + index * this.stride]);
    }

    @Override
    public long index(int rank) {
        return (long)this.offset + (long)this.offsets[this.zero + rank * this.stride];
    }

    @Override
    public LongMatrix1D like(int size) {
        return new SparseLongMatrix1D(size);
    }

    @Override
    public LongMatrix2D like2D(int rows, int columns) {
        return new SparseLongMatrix2D(rows, columns);
    }

    @Override
    public LongMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public LongMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public void setQuick(int index, long value) {
        long i = (long)this.offset + (long)this.offsets[this.zero + index * this.stride];
        if (value == 0L) {
            this.elements.removeKey(i);
        } else {
            this.elements.put(i, value);
        }
    }

    @Override
    protected int _offset(int absRank) {
        return this.offsets[absRank];
    }

    @Override
    protected boolean haveSharedCellsRaw(LongMatrix1D other) {
        if (other instanceof SelectedSparseLongMatrix1D) {
            SelectedSparseLongMatrix1D otherMatrix = (SelectedSparseLongMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseLongMatrix1D) {
            SparseLongMatrix1D otherMatrix = (SparseLongMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected void setUp(int size) {
        super.setUp(size);
        this.stride = 1;
        this.offset = 0;
    }

    @Override
    protected LongMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseLongMatrix1D(this.elements, offsets);
    }
}

