/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.services.MDBService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.Timestamp;

public class ZeissLSMReader
extends FormatReader {
    public static final String[] MDB_SUFFIX = new String[]{"mdb"};
    private static final int ZEISS_ID = 34412;
    private static final int TYPE_SUBBLOCK = 0;
    private static final int TYPE_ASCII = 2;
    private static final int TYPE_LONG = 4;
    private static final int TYPE_RATIONAL = 5;
    private static final int TYPE_DATE = 6;
    private static final int TYPE_BOOLEAN = 7;
    private static final int SUBBLOCK_RECORDING = 0x10000000;
    private static final int SUBBLOCK_LASER = 0x50000000;
    private static final int SUBBLOCK_TRACK = 0x40000000;
    private static final int SUBBLOCK_DETECTION_CHANNEL = 0x70000000;
    private static final int SUBBLOCK_ILLUMINATION_CHANNEL = -1879048192;
    private static final int SUBBLOCK_BEAM_SPLITTER = -1342177280;
    private static final int SUBBLOCK_DATA_CHANNEL = -805306368;
    private static final int SUBBLOCK_TIMER = 0x12000000;
    private static final int SUBBLOCK_MARKER = 0x14000000;
    private static final int SUBBLOCK_END = -1;
    private static final int RECORDING_NAME = 0x10000001;
    private static final int RECORDING_DESCRIPTION = 0x10000002;
    private static final int RECORDING_OBJECTIVE = 0x10000004;
    private static final int RECORDING_ZOOM = 0x10000016;
    private static final int RECORDING_SAMPLE_0TIME = 268435510;
    private static final int RECORDING_CAMERA_BINNING = 268435538;
    private static final int TRACK_ACQUIRE = 0x40000006;
    private static final int TRACK_TIME_BETWEEN_STACKS = 0x4000000B;
    private static final int LASER_NAME = 0x50000001;
    private static final int LASER_ACQUIRE = 0x50000002;
    private static final int LASER_POWER = 0x50000003;
    private static final int CHANNEL_DETECTOR_GAIN = 0x70000003;
    private static final int CHANNEL_PINHOLE_DIAMETER = 0x70000009;
    private static final int CHANNEL_AMPLIFIER_GAIN = 0x70000005;
    private static final int CHANNEL_FILTER_SET = 0x7000000F;
    private static final int CHANNEL_FILTER = 0x70000010;
    private static final int CHANNEL_ACQUIRE = 0x7000000B;
    private static final int CHANNEL_NAME = 1879048212;
    private static final int ILLUM_CHANNEL_NAME = -1879048191;
    private static final int ILLUM_CHANNEL_ATTENUATION = -1879048190;
    private static final int ILLUM_CHANNEL_WAVELENGTH = -1879048189;
    private static final int ILLUM_CHANNEL_ACQUIRE = -1879048188;
    private static final int START_TIME = 268435510;
    private static final int DATA_CHANNEL_NAME = -805306367;
    private static final int DATA_CHANNEL_ACQUIRE = -805306345;
    private static final int BEAM_SPLITTER_FILTER = -1342177278;
    private static final int BEAM_SPLITTER_FILTER_SET = -1342177277;
    private static final int TEXT = 13;
    private static final int LINE = 14;
    private static final int SCALE_BAR = 15;
    private static final int OPEN_ARROW = 16;
    private static final int CLOSED_ARROW = 17;
    private static final int RECTANGLE = 18;
    private static final int ELLIPSE = 19;
    private static final int CLOSED_POLYLINE = 20;
    private static final int OPEN_POLYLINE = 21;
    private static final int CLOSED_BEZIER = 22;
    private static final int OPEN_BEZIER = 23;
    private static final int CIRCLE = 24;
    private static final int PALETTE = 25;
    private static final int POLYLINE_ARROW = 26;
    private static final int BEZIER_WITH_ARROW = 27;
    private static final int ANGLE = 28;
    private static final int CIRCLE_3POINT = 29;
    private static final ImmutableMap<Integer, String> METADATA_KEYS = ZeissLSMReader.createKeys();
    private double pixelSizeX;
    private double pixelSizeY;
    private double pixelSizeZ;
    private byte[][][] lut = null;
    private List<Double> timestamps;
    private String[] lsmFilenames;
    private List<IFDList> ifdsList;
    private transient TiffParser tiffParser;
    private int nextLaser = 0;
    private int nextDetector = 0;
    private int nextFilter = 0;
    private int nextDichroicChannel = 0;
    private int nextDichroic = 0;
    private int nextIllumChannel = 0;
    private int nextDetectChannel = 0;
    private boolean splitPlanes = false;
    private double zoom;
    private List<String> imageNames;
    private String binning;
    private List<Double> xCoordinates;
    private List<Double> yCoordinates;
    private List<Double> zCoordinates;
    private int dimensionM;
    private int dimensionP;
    private int rotations;
    private int phases;
    private int illuminations;
    private Map<String, Integer> seriesCounts;
    private String userName;
    private String[][] channelNames;
    private double originX;
    private double originY;
    private double originZ;
    private int totalROIs = 0;
    private int prevPlane = -1;
    private int prevChannel = 0;
    private byte[] prevBuf = null;
    private Region prevRegion = null;
    private Map<Integer, String> acquiredDate = new HashMap<Integer, String>();
    private Color[] channelColor;
    private transient boolean isSIM = false;

    public ZeissLSMReader() {
        super("Zeiss Laser-Scanning Microscopy", new String[]{"lsm", "mdb"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.suffixSufficient = false;
        this.datasetDescription = "One or more .lsm files; if multiple .lsm files are present, an .mdb file should also be present";
    }

    public int getOptimalWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifdsList.get(this.getSeries()).get(0)).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile width", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifdsList.get(this.getSeries()).get(0)).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile height", e);
            return super.getOptimalTileHeight();
        }
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        if (ZeissLSMReader.checkSuffix(id, MDB_SUFFIX)) {
            return false;
        }
        return this.isGroupFiles() ? this.getMDBFile(id) != null : true;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelSizeZ = 0.0;
            this.pixelSizeY = 0.0;
            this.pixelSizeX = 0.0;
            this.lut = null;
            this.timestamps = null;
            this.lsmFilenames = null;
            this.ifdsList = null;
            this.tiffParser = null;
            this.nextDetector = 0;
            this.nextLaser = 0;
            this.nextDichroic = 0;
            this.nextDichroicChannel = 0;
            this.nextFilter = 0;
            this.nextDetectChannel = 0;
            this.nextIllumChannel = 0;
            this.splitPlanes = false;
            this.zoom = 0.0;
            this.imageNames = null;
            this.binning = null;
            this.totalROIs = 0;
            this.prevPlane = -1;
            this.prevChannel = 0;
            this.prevBuf = null;
            this.prevRegion = null;
            this.xCoordinates = null;
            this.yCoordinates = null;
            this.zCoordinates = null;
            this.dimensionM = 0;
            this.dimensionP = 0;
            this.rotations = 0;
            this.phases = 0;
            this.illuminations = 0;
            this.seriesCounts = null;
            this.originZ = 0.0;
            this.originY = 0.0;
            this.originX = 0.0;
            this.userName = null;
            this.acquiredDate.clear();
            this.channelNames = null;
            this.channelColor = null;
            this.isSIM = false;
        }
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4096;
        if (!FormatTools.validStream(stream, 4096, false)) {
            return false;
        }
        TiffParser parser = new TiffParser(stream);
        if (parser.isValidHeader()) {
            return parser.getIFDOffsets().length > 1;
        }
        stream.seek(4L);
        if (stream.readShort() == 21364) {
            String check = stream.readString((int)(4096L - stream.getFilePointer()));
            return check.indexOf("ID") > 0;
        }
        return false;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return ZeissLSMReader.checkSuffix(id, MDB_SUFFIX) || !new Location(id).getName().startsWith("spim_") ? 0 : 1;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            if (ZeissLSMReader.checkSuffix(this.currentId, MDB_SUFFIX)) {
                return new String[]{this.currentId};
            }
            return null;
        }
        if (this.lsmFilenames == null) {
            return new String[]{this.currentId};
        }
        if (this.lsmFilenames.length == 1 && this.currentId.equals(this.lsmFilenames[0])) {
            return this.lsmFilenames;
        }
        return new String[]{this.currentId, this.getLSMFileFromSeries(this.getSeries())};
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.lut == null || this.lut[this.getSeries()] == null || this.getPixelType() != 1) {
            return null;
        }
        byte[][] b = new byte[][]{this.lut[this.getSeries()][this.prevChannel * 3], this.lut[this.getSeries()][this.prevChannel * 3 + 1], this.lut[this.getSeries()][this.prevChannel * 3 + 2]};
        return b;
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.lut == null || this.lut[this.getSeries()] == null || this.getPixelType() != 3 || this.channelColor == null) {
            return null;
        }
        short[][] s = new short[3][65536];
        Color color = this.channelColor[this.prevChannel];
        for (int j = 0; j < s[0].length; ++j) {
            s[0][j] = (short)((double)color.getRed() / 255.0 * (double)j);
            s[1][j] = (short)((double)color.getGreen() / 255.0 * (double)j);
            s[2][j] = (short)((double)color.getBlue() / 255.0 * (double)j);
        }
        return s;
    }

    @Override
    public void setSeries(int series) {
        if (series != this.getSeries()) {
            this.prevBuf = null;
        }
        super.setSeries(series);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.getSeriesCount() > 1) {
            this.in.close();
            this.in = new RandomAccessInputStream(this.getLSMFileFromSeries(this.getSeries()));
            this.in.order(!this.isLittleEndian());
            this.tiffParser = new TiffParser(this.in);
        } else if (this.tiffParser == null) {
            this.tiffParser = new TiffParser(this.in);
        }
        IFDList ifds = this.ifdsList.get(this.getSeries());
        if (this.splitPlanes && this.getSizeC() > 1 && ifds.size() == this.getSizeZ() * this.getSizeT()) {
            int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
            int plane = no / this.getSizeC();
            int c = no % this.getSizeC();
            Region region = new Region(x, y, w, h);
            if (this.prevPlane != plane || this.prevBuf == null || this.prevBuf.length < w * h * bpp * this.getSizeC() || !region.equals(this.prevRegion)) {
                this.prevBuf = new byte[w * h * bpp * this.getSizeC()];
                this.tiffParser.getSamples((IFD)ifds.get(plane), this.prevBuf, x, y, w, h);
                this.prevPlane = plane;
                this.prevRegion = region;
            }
            ImageTools.splitChannels(this.prevBuf, buf, c, this.getSizeC(), bpp, false, false, w * h * bpp);
            this.prevChannel = c;
        } else {
            this.tiffParser.getSamples((IFD)ifds.get(no), buf, x, y, w, h);
            this.prevChannel = this.getZCTCoords(no)[1];
        }
        if (this.getSeriesCount() > 1) {
            this.in.close();
        }
        return buf;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int series;
        super.initFile(id);
        this.lsmFilenames = ZeissLSMReader.checkSuffix(id, MDB_SUFFIX) ? this.parseMDB(id) : new String[]{id};
        if (this.lsmFilenames == null || this.lsmFilenames.length == 0) {
            throw new FormatException("LSM files were not found.");
        }
        this.totalROIs = 0;
        this.timestamps = new ArrayList<Double>();
        this.imageNames = new ArrayList<String>();
        this.xCoordinates = new ArrayList<Double>();
        this.yCoordinates = new ArrayList<Double>();
        this.zCoordinates = new ArrayList<Double>();
        this.seriesCounts = new HashMap<String, Integer>();
        int seriesCount = 0;
        ArrayList<String> validFiles = new ArrayList<String>();
        for (String filename : this.lsmFilenames) {
            try {
                int extraSeries = this.getExtraSeries(filename);
                this.seriesCounts.put(filename, extraSeries);
                seriesCount += extraSeries;
                validFiles.add(filename);
            }
            catch (IOException e) {
                LOGGER.debug("Failed to parse " + filename, e);
            }
        }
        this.lsmFilenames = validFiles.toArray(new String[validFiles.size()]);
        this.core.clear();
        for (int c = 0; c < seriesCount; ++c) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
        }
        this.channelNames = new String[seriesCount][];
        this.ifdsList = new ArrayList<IFDList>();
        for (int series2 = 0; series2 < seriesCount; ++series2) {
            this.ifdsList.add(null);
        }
        int realSeries = 0;
        for (int i = 0; i < this.lsmFilenames.length; ++i) {
            try (RandomAccessInputStream stream = null;){
                stream = new RandomAccessInputStream(this.lsmFilenames[i], 16);
                int count = this.seriesCounts.get(this.lsmFilenames[i]);
                TiffParser tp = new TiffParser(stream);
                Boolean littleEndian = tp.checkHeader();
                long[] ifdOffsets = tp.getIFDOffsets();
                int ifdsPerSeries = ifdOffsets.length / 2 / count;
                int offset = 0;
                Object zeissTag = null;
                int s = 0;
                while (s < count) {
                    CoreMetadata ms = (CoreMetadata)this.core.get(realSeries);
                    ms.littleEndian = littleEndian;
                    IFDList ifds = new IFDList();
                    while (ifds.size() < ifdsPerSeries) {
                        tp.setDoCaching(offset == 0);
                        IFD ifd = tp.getIFD(ifdOffsets[offset]);
                        if (offset == 0) {
                            zeissTag = ifd.get(34412);
                        }
                        if (offset > 0 && ifds.isEmpty()) {
                            ifd.putIFDValue(34412, zeissTag);
                        }
                        ifds.add(ifd);
                        if (zeissTag != null) {
                            offset += 2;
                            continue;
                        }
                        ++offset;
                    }
                    for (IFD ifd : ifds) {
                        tp.fillInIFD(ifd);
                    }
                    this.ifdsList.set(realSeries, ifds);
                    ++s;
                    ++realSeries;
                }
                continue;
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        this.lut = new byte[this.ifdsList.size()][][];
        long[] previousStripOffsets = null;
        for (series = 0; series < this.ifdsList.size(); ++series) {
            if (series > 0 && this.getSizeT() > 1) {
                previousStripOffsets = null;
            }
            IFDList ifds = this.ifdsList.get(series);
            for (IFD ifd : ifds) {
                if (ifd.getCompression() == TiffCompression.LZW) continue;
                ifd.putIFDValue(317, 1);
            }
            try (RandomAccessInputStream s = null;){
                s = new RandomAccessInputStream(this.getLSMFileFromSeries(series));
                for (int i = 0; i < ifds.size(); ++i) {
                    long[] stripOffsets = ((IFD)ifds.get(i)).getStripOffsets();
                    if (stripOffsets == null || i != 0 && previousStripOffsets == null) {
                        throw new FormatException("Strip offsets are missing; this is an invalid file.");
                    }
                    if (i == 0 && previousStripOffsets == null) {
                        previousStripOffsets = stripOffsets;
                        continue;
                    }
                    boolean neededAdjustment = false;
                    for (int j = 0; j < stripOffsets.length && j < previousStripOffsets.length; ++j) {
                        if (stripOffsets[j] < previousStripOffsets[j]) {
                            long newOffset;
                            stripOffsets[j] = previousStripOffsets[j] & 0xFFFFFFFF00000000L | stripOffsets[j] & 0xFFFFFFFFL;
                            if (stripOffsets[j] < previousStripOffsets[j] && (newOffset = stripOffsets[j] + 0x100000000L) < s.length()) {
                                stripOffsets[j] = newOffset;
                            }
                            neededAdjustment = true;
                        }
                        if (!neededAdjustment) continue;
                        ((IFD)ifds.get(i)).putIFDValue(273, stripOffsets);
                    }
                    previousStripOffsets = stripOffsets;
                }
                this.initMetadata(series);
                continue;
            }
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            CoreMetadata ms = (CoreMetadata)this.core.get(i);
            ms.imageCount = ms.sizeZ * ms.sizeC * ms.sizeT;
        }
        MetadataTools.populatePixels(store, this, true);
        for (series = 0; series < this.ifdsList.size(); ++series) {
            this.setSeries(series);
            if (series < this.imageNames.size()) {
                store.setImageName(this.imageNames.get(series), series);
            }
            if (!this.acquiredDate.containsKey(series)) continue;
            store.setImageAcquisitionDate(new Timestamp(this.acquiredDate.get(series)), series);
        }
        this.setSeries(0);
    }

    private String getMDBFile(String id) throws FormatException, IOException {
        Location parentFile = new Location(id).getAbsoluteFile().getParentFile();
        String[] fileList = parentFile.list();
        for (int i = 0; i < fileList.length; ++i) {
            Location file2;
            if (fileList[i].startsWith(".") || !ZeissLSMReader.checkSuffix(fileList[i], MDB_SUFFIX) || (file2 = new Location(parentFile, fileList[i]).getAbsoluteFile()).isDirectory()) continue;
            String[] lsms = this.parseMDB(file2.getAbsolutePath());
            if (lsms == null) {
                return null;
            }
            for (String lsm : lsms) {
                if (!id.endsWith(lsm) && !lsm.endsWith(id)) continue;
                return file2.getAbsolutePath();
            }
        }
        return null;
    }

    private int getEffectiveSeries(int currentSeries) {
        int seriesCount = 0;
        for (int i = 0; i < this.lsmFilenames.length; ++i) {
            Integer count = this.seriesCounts.get(this.lsmFilenames[i]);
            if (count == null) {
                count = 1;
            }
            if ((seriesCount += count.intValue()) <= currentSeries) continue;
            return i;
        }
        return -1;
    }

    private String getLSMFileFromSeries(int currentSeries) {
        int effectiveSeries = this.getEffectiveSeries(currentSeries);
        return effectiveSeries < 0 ? null : this.lsmFilenames[effectiveSeries];
    }

    private int getExtraSeries(String file2) throws FormatException, IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = new RandomAccessInputStream(file2, 16);
        boolean littleEndian = this.in.read() == 73;
        this.in.order(littleEndian);
        this.tiffParser = new TiffParser(this.in);
        IFD ifd = this.tiffParser.getFirstIFD();
        RandomAccessInputStream ras = this.getCZTag(ifd);
        if (ras == null) {
            return 1;
        }
        ras.order(littleEndian);
        ras.seek(264L);
        this.dimensionP = ras.readInt();
        this.dimensionM = ras.readInt();
        ras.close();
        int nSeries = this.dimensionM * this.dimensionP;
        return nSeries <= 0 ? 1 : nSeries;
    }

    private int getPosition(int currentSeries) {
        int effectiveSeries = this.getEffectiveSeries(currentSeries);
        int firstPosition = 0;
        for (int i = 0; i < effectiveSeries; ++i) {
            firstPosition += this.seriesCounts.get(this.lsmFilenames[i]).intValue();
        }
        return currentSeries - firstPosition;
    }

    private RandomAccessInputStream getCZTag(IFD ifd) throws FormatException, IOException {
        short[] s = ifd.getIFDShortArray(34412);
        if (s == null) {
            LOGGER.warn("Invalid Zeiss LSM file. Tag {} not found.", (Object)34412);
            TiffReader reader = new TiffReader();
            reader.setId(this.getLSMFileFromSeries(this.getSeries()));
            this.core.set(this.getSeries(), reader.getCoreMetadataList().get(0));
            reader.close();
            return null;
        }
        byte[] cz = new byte[s.length];
        for (int i = 0; i < s.length; ++i) {
            cz[i] = (byte)s[i];
        }
        RandomAccessInputStream ras = new RandomAccessInputStream(cz);
        ras.order(this.isLittleEndian());
        return ras;
    }

    protected void initMetadata(int series) throws FormatException, IOException {
        int i;
        this.setSeries(series);
        IFDList ifds = this.ifdsList.get(series);
        IFD ifd = (IFD)ifds.get(0);
        this.in.close();
        this.in = new RandomAccessInputStream(this.getLSMFileFromSeries(series), 16);
        this.in.order(this.isLittleEndian());
        this.tiffParser = new TiffParser(this.in);
        PhotoInterp photo = ifd.getPhotometricInterpretation();
        int samples = ifd.getSamplesPerPixel();
        CoreMetadata ms = (CoreMetadata)this.core.get(series);
        ms.sizeX = (int)ifd.getImageWidth();
        ms.sizeY = (int)ifd.getImageLength();
        ms.rgb = samples > 1 || photo == PhotoInterp.RGB;
        ms.interleaved = false;
        ms.sizeC = this.isRGB() ? samples : 1;
        ms.pixelType = ifd.getPixelType();
        ms.imageCount = ifds.size();
        ms.sizeZ = this.getImageCount();
        ms.sizeT = 1;
        LOGGER.info("Reading LSM metadata for series #{}", (Object)series);
        MetadataStore store = this.makeFilterMetadata();
        int instrument = this.getEffectiveSeries(series);
        String imageName = this.getLSMFileFromSeries(series);
        if (imageName.indexOf(46) != -1) {
            imageName = imageName.substring(0, imageName.lastIndexOf("."));
        }
        if (imageName.indexOf(File.separator) != -1) {
            imageName = imageName.substring(imageName.lastIndexOf(File.separator) + 1);
        }
        if (this.lsmFilenames.length != this.getSeriesCount()) {
            imageName = imageName + " #" + (this.getPosition(series) + 1);
        }
        store.setImageID(MetadataTools.createLSID("Image", series), series);
        String instrumentID = MetadataTools.createLSID("Instrument", instrument);
        store.setInstrumentID(instrumentID, instrument);
        store.setImageInstrumentRef(instrumentID, series);
        RandomAccessInputStream ras = this.getCZTag(ifd);
        if (ras == null) {
            this.imageNames.add(imageName);
            return;
        }
        ras.seek(16L);
        ms.sizeZ = ras.readInt();
        ras.skipBytes(4);
        ms.sizeT = ras.readInt();
        int dataType = ras.readInt();
        switch (dataType) {
            case 2: {
                this.addSeriesMeta("DataType", "12 bit unsigned integer");
                break;
            }
            case 5: {
                this.addSeriesMeta("DataType", "32 bit float");
                break;
            }
            case 0: {
                this.addSeriesMeta("DataType", "varying data types");
                break;
            }
            default: {
                this.addSeriesMeta("DataType", "8 bit unsigned integer");
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            ras.seek(0L);
            this.addSeriesMeta("MagicNumber ", ras.readInt());
            this.addSeriesMeta("StructureSize", ras.readInt());
            this.addSeriesMeta("DimensionX", ras.readInt());
            this.addSeriesMeta("DimensionY", ras.readInt());
            ras.seek(32L);
            this.addSeriesMeta("ThumbnailX", ras.readInt());
            this.addSeriesMeta("ThumbnailY", ras.readInt());
            this.pixelSizeX = ras.readDouble() * 1000000.0;
            this.pixelSizeY = ras.readDouble() * 1000000.0;
            this.pixelSizeZ = ras.readDouble() * 1000000.0;
            this.addSeriesMeta("VoxelSizeX", this.pixelSizeX);
            this.addSeriesMeta("VoxelSizeY", this.pixelSizeY);
            this.addSeriesMeta("VoxelSizeZ", this.pixelSizeZ);
            this.originX = ras.readDouble() * 1000000.0;
            this.originY = ras.readDouble() * 1000000.0;
            this.originZ = ras.readDouble() * 1000000.0;
            this.addSeriesMeta("OriginX", this.originX);
            this.addSeriesMeta("OriginY", this.originY);
            this.addSeriesMeta("OriginZ", this.originZ);
        } else {
            ras.seek(88L);
        }
        short scanType = ras.readShort();
        switch (scanType) {
            case 0: {
                this.addSeriesMeta("ScanType", "x-y-z scan");
                ms.dimensionOrder = "XYZCT";
                break;
            }
            case 1: {
                this.addSeriesMeta("ScanType", "z scan (x-z plane)");
                ms.dimensionOrder = "XYZCT";
                break;
            }
            case 2: {
                this.addSeriesMeta("ScanType", "line scan");
                ms.dimensionOrder = "XYZCT";
                break;
            }
            case 3: {
                this.addSeriesMeta("ScanType", "time series x-y");
                ms.dimensionOrder = "XYTCZ";
                break;
            }
            case 4: {
                this.addSeriesMeta("ScanType", "time series x-z");
                ms.dimensionOrder = "XYZTC";
                break;
            }
            case 5: {
                this.addSeriesMeta("ScanType", "time series 'Mean of ROIs'");
                ms.dimensionOrder = "XYTCZ";
                break;
            }
            case 6: {
                this.addSeriesMeta("ScanType", "time series x-y-z");
                ms.dimensionOrder = "XYZTC";
                break;
            }
            case 7: {
                this.addSeriesMeta("ScanType", "spline scan");
                ms.dimensionOrder = "XYCTZ";
                break;
            }
            case 8: {
                this.addSeriesMeta("ScanType", "spline scan x-z");
                ms.dimensionOrder = "XYCZT";
                break;
            }
            case 9: {
                this.addSeriesMeta("ScanType", "time series spline plane x-z");
                ms.dimensionOrder = "XYTCZ";
                break;
            }
            case 10: {
                this.addSeriesMeta("ScanType", "point mode");
                ms.dimensionOrder = "XYZCT";
                break;
            }
            default: {
                this.addSeriesMeta("ScanType", "x-y-z scan");
                ms.dimensionOrder = "XYZCT";
            }
        }
        boolean bl = ms.indexed = this.lut != null && this.lut[series] != null;
        if (this.isIndexed()) {
            ms.rgb = false;
        }
        if (this.getSizeC() == 0) {
            ms.sizeC = 1;
        }
        if (this.isRGB()) {
            ms.dimensionOrder = this.getDimensionOrder().replaceAll("C", "");
            ms.dimensionOrder = this.getDimensionOrder().replaceAll("XY", "XYC");
        }
        ms.imageCount = this.getEffectiveSizeC() == 0 ? this.getSizeZ() * this.getSizeT() : this.getSizeZ() * this.getSizeT() * this.getEffectiveSizeC();
        if (this.getImageCount() != ifds.size()) {
            int diff = this.getImageCount() - ifds.size();
            ms.imageCount = ifds.size();
            if (diff % this.getSizeZ() == 0) {
                ms.sizeT -= diff / this.getSizeZ();
            } else if (diff % this.getSizeT() == 0) {
                ms.sizeZ -= diff / this.getSizeT();
            } else if (this.getSizeZ() > 1) {
                ms.sizeZ = ifds.size();
                ms.sizeT = 1;
            } else if (this.getSizeT() > 1) {
                ms.sizeT = ifds.size();
                ms.sizeZ = 1;
            }
        }
        if (this.getSizeZ() == 0) {
            ms.sizeZ = this.getImageCount();
        }
        if (this.getSizeT() == 0) {
            ms.sizeT = this.getImageCount() / this.getSizeZ();
        }
        long channelColorsOffset = 0L;
        long timeStampOffset = 0L;
        long eventListOffset = 0L;
        long scanInformationOffset = 0L;
        long channelWavelengthOffset = 0L;
        long applicationTagOffset = 0L;
        this.channelColor = new Color[this.getSizeC()];
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            short spectralScan = ras.readShort();
            if (spectralScan != 1) {
                this.addSeriesMeta("SpectralScan", "no spectral scan");
            } else {
                this.addSeriesMeta("SpectralScan", "acquired with spectral scan");
            }
            int type = ras.readInt();
            switch (type) {
                case 1: {
                    this.addSeriesMeta("DataType2", "calculated data");
                    break;
                }
                case 2: {
                    this.addSeriesMeta("DataType2", "animation");
                    break;
                }
                default: {
                    this.addSeriesMeta("DataType2", "original scan data");
                }
            }
            long[] overlayOffsets = new long[9];
            String[] overlayKeys = new String[]{"VectorOverlay", "InputLut", "OutputLut", "ROI", "BleachROI", "MeanOfRoisOverlay", "TopoIsolineOverlay", "TopoProfileOverlay", "LinescanOverlay"};
            overlayOffsets[0] = ras.readInt();
            overlayOffsets[1] = ras.readInt();
            overlayOffsets[2] = ras.readInt();
            channelColorsOffset = ras.readInt();
            this.addSeriesMeta("TimeInterval", ras.readDouble());
            ras.skipBytes(4);
            scanInformationOffset = ras.readInt();
            applicationTagOffset = ras.readInt();
            timeStampOffset = ras.readInt();
            eventListOffset = ras.readInt();
            overlayOffsets[3] = ras.readInt();
            overlayOffsets[4] = ras.readInt();
            ras.skipBytes(4);
            this.addSeriesMeta("DisplayAspectX", ras.readDouble());
            this.addSeriesMeta("DisplayAspectY", ras.readDouble());
            this.addSeriesMeta("DisplayAspectZ", ras.readDouble());
            this.addSeriesMeta("DisplayAspectTime", ras.readDouble());
            overlayOffsets[5] = ras.readInt();
            overlayOffsets[6] = ras.readInt();
            overlayOffsets[7] = ras.readInt();
            overlayOffsets[8] = ras.readInt();
            if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.NO_OVERLAYS) {
                for (i = 0; i < overlayOffsets.length; ++i) {
                    this.parseOverlays(series, overlayOffsets[i], overlayKeys[i], store);
                }
            }
            this.addSeriesMeta("ToolbarFlags", ras.readInt());
            channelWavelengthOffset = ras.readInt();
            ras.skipBytes(64);
        } else {
            ras.skipBytes(182);
        }
        if (this.getSizeC() > 1) {
            if (!this.splitPlanes) {
                this.splitPlanes = this.isRGB();
            }
            ms.rgb = false;
            if (this.splitPlanes) {
                ms.imageCount *= this.getSizeC();
            }
        }
        this.rotations = ras.readInt();
        this.phases = ras.readInt();
        this.illuminations = ras.readInt();
        if (this.rotations > 1) {
            ms.moduloZ.step = ms.sizeZ;
            ms.moduloZ.end = ms.sizeZ * (this.rotations - 1);
            ms.moduloZ.type = "Rotation";
            ms.sizeZ *= this.rotations;
        }
        if (this.illuminations > 1) {
            ms.moduloC.step = ms.sizeC;
            ms.moduloC.end = ms.sizeC * (this.illuminations - 1);
            ms.moduloC.type = "Illumination";
            ms.moduloC.parentType = "Channel";
            ms.sizeC *= this.illuminations;
        }
        if (this.phases > 1) {
            ms.moduloT.step = ms.sizeT;
            ms.moduloT.end = ms.sizeT * (this.phases - 1);
            ms.moduloT.type = "Phase";
            ms.sizeT *= this.phases;
        }
        for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
            String lsid = MetadataTools.createLSID("Channel", series, c);
            store.setChannelID(lsid, series, c);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            double zPos;
            double yPos;
            ras.skipBytes(52);
            int tilePositionOffset = ras.readInt();
            ras.skipBytes(36);
            int positionOffset = ras.readInt();
            this.addSeriesMeta("DimensionZ", this.getSizeZ());
            this.addSeriesMeta("DimensionChannels", this.getSizeC());
            this.addSeriesMeta("DimensionM", this.dimensionM);
            this.addSeriesMeta("DimensionP", this.dimensionP);
            if (this.lsmFilenames.length == 1) {
                this.xCoordinates.clear();
                this.yCoordinates.clear();
                this.zCoordinates.clear();
            }
            if (positionOffset != 0) {
                this.in.seek(positionOffset);
                int nPositions = this.in.readInt();
                for (int i2 = 0; i2 < nPositions; ++i2) {
                    double xPos = this.originX + this.in.readDouble() * 1000000.0;
                    yPos = this.originY + this.in.readDouble() * 1000000.0;
                    zPos = this.originZ + this.in.readDouble() * 1000000.0;
                    this.xCoordinates.add(xPos);
                    this.yCoordinates.add(yPos);
                    this.zCoordinates.add(zPos);
                    this.addGlobalMetaList("X position for position", xPos);
                    this.addGlobalMetaList("Y position for position", yPos);
                    this.addGlobalMetaList("Z position for position", zPos);
                }
            }
            if (tilePositionOffset != 0) {
                this.in.seek(tilePositionOffset);
                int nTiles = this.in.readInt();
                for (int i3 = 0; i3 < nTiles; ++i3) {
                    double xPos = this.originX + this.in.readDouble() * 1000000.0;
                    yPos = this.originY + this.in.readDouble() * 1000000.0;
                    zPos = this.originZ + this.in.readDouble() * 1000000.0;
                    if (this.xCoordinates.size() > i3) {
                        this.xCoordinates.set(i3, xPos += this.xCoordinates.get(i3).doubleValue());
                    } else if (this.xCoordinates.size() == i3) {
                        this.xCoordinates.add(xPos);
                    }
                    if (this.yCoordinates.size() > i3) {
                        this.yCoordinates.set(i3, yPos += this.yCoordinates.get(i3).doubleValue());
                    } else if (this.yCoordinates.size() == i3) {
                        this.yCoordinates.add(yPos);
                    }
                    if (this.zCoordinates.size() > i3) {
                        this.zCoordinates.set(i3, zPos += this.zCoordinates.get(i3).doubleValue());
                    } else if (this.zCoordinates.size() == i3) {
                        this.zCoordinates.add(zPos);
                    }
                    this.addGlobalMetaList("X position for position", xPos);
                    this.addGlobalMetaList("Y position for position", yPos);
                    this.addGlobalMetaList("Z position for position", zPos);
                }
            }
            if (applicationTagOffset != 0L) {
                this.in.seek(applicationTagOffset);
                this.parseApplicationTags();
            }
            if (channelColorsOffset != 0L) {
                this.in.seek(channelColorsOffset + 12L);
                int colorsOffset = this.in.readInt();
                int namesOffset = this.in.readInt();
                if (colorsOffset > 0) {
                    this.in.seek(channelColorsOffset + (long)colorsOffset);
                    this.lut[this.getSeries()] = new byte[this.getSizeC() * 3][256];
                    ((CoreMetadata)this.core.get((int)this.getSeries())).indexed = true;
                    for (i = 0; i < this.getSizeC(); ++i) {
                        if (i >= this.channelColor.length) continue;
                        int color = this.in.readInt();
                        int red = color & 0xFF;
                        int green = (color & 0xFF00) >> 8;
                        int blue = (color & 0xFF0000) >> 16;
                        if (red == 0 && green == 0 & blue == 0) {
                            if (i > 0 && this.isSIM) {
                                red = this.channelColor[i - 1].getRed();
                                green = this.channelColor[i - 1].getGreen();
                                blue = this.channelColor[i - 1].getBlue();
                            } else {
                                red = 255;
                                green = 255;
                                blue = 255;
                            }
                        }
                        this.channelColor[i] = new Color(red, green, blue, 255);
                        for (int j = 0; j < 256; ++j) {
                            this.lut[this.getSeries()][i * 3][j] = (byte)((double)red / 255.0 * (double)j);
                            this.lut[this.getSeries()][i * 3 + 1][j] = (byte)((double)green / 255.0 * (double)j);
                            this.lut[this.getSeries()][i * 3 + 2][j] = (byte)((double)blue / 255.0 * (double)j);
                        }
                    }
                }
                if (namesOffset > 0) {
                    this.in.seek(channelColorsOffset + (long)namesOffset);
                    this.channelNames[series] = new String[this.getSizeC()];
                    for (i = 0; i < this.getSizeC() && this.in.getFilePointer() < this.in.length() - 1L; ++i) {
                        int length = this.in.readInt();
                        String name = this.in.readString(length);
                        while (name.length() > 0 && name.codePointAt(name.length() - 1) == 0) {
                            name = name.substring(0, name.length() - 1);
                        }
                        if (name.length() <= 128) {
                            this.addSeriesMetaList("ChannelName", name);
                        }
                        this.channelNames[series][i] = name;
                    }
                }
            }
            if (timeStampOffset != 0L) {
                this.in.seek(timeStampOffset + 4L);
                int nStamps = this.in.readInt();
                for (int i4 = 0; i4 < nStamps; ++i4) {
                    double stamp = this.in.readDouble();
                    this.addSeriesMetaList("TimeStamp", stamp);
                    this.timestamps.add(stamp);
                }
            }
            if (eventListOffset != 0L) {
                this.in.seek(eventListOffset + 4L);
                int numEvents = this.in.readInt();
                this.in.seek(this.in.getFilePointer() - 4L);
                this.in.order(!this.in.isLittleEndian());
                int tmpEvents = this.in.readInt();
                numEvents = numEvents < 0 ? tmpEvents : Math.min(numEvents, tmpEvents);
                this.in.order(!this.in.isLittleEndian());
                if (numEvents > 65535) {
                    numEvents = 0;
                }
                for (i = 0; i < numEvents; ++i) {
                    if (this.in.getFilePointer() + 16L > this.in.length()) continue;
                    int size = this.in.readInt();
                    double eventTime = this.in.readDouble();
                    int eventType = this.in.readInt();
                    this.addSeriesMetaList("Event Time", eventTime);
                    this.addSeriesMetaList("Event Type", eventType);
                    long fp = this.in.getFilePointer();
                    int len = size - 16;
                    if (len > 65536) {
                        len = 65536;
                    }
                    if (len < 0) {
                        len = 0;
                    }
                    this.addSeriesMetaList("Event Description", this.in.readString(len));
                    this.in.seek(fp + (long)size - 16L);
                    if (this.in.getFilePointer() < 0L) break;
                }
            }
            if (scanInformationOffset != 0L) {
                SubBlock[] metadataBlocks;
                this.in.seek(scanInformationOffset);
                this.nextDetector = 0;
                this.nextLaser = 0;
                this.nextDichroic = 0;
                this.nextDichroicChannel = 0;
                this.nextFilter = 0;
                this.nextIllumChannel = 0;
                this.nextDetectChannel = 0;
                ArrayList<Recording> blocks = new ArrayList<Recording>();
                while (this.in.getFilePointer() < this.in.length() - 12L && this.in.getFilePointer() >= 0L) {
                    int entry = this.in.readInt();
                    int blockType = this.in.readInt();
                    int dataSize = this.in.readInt();
                    if (blockType == 0) {
                        SubBlock block = null;
                        switch (entry) {
                            case 0x10000000: {
                                block = new Recording();
                                break;
                            }
                            case 0x50000000: {
                                block = new Laser();
                                break;
                            }
                            case 0x40000000: {
                                block = new Track();
                                break;
                            }
                            case 0x70000000: {
                                block = new DetectionChannel();
                                break;
                            }
                            case -1879048192: {
                                block = new IlluminationChannel();
                                break;
                            }
                            case -1342177280: {
                                block = new BeamSplitter();
                                break;
                            }
                            case -805306368: {
                                block = new DataChannel();
                                break;
                            }
                            case 0x12000000: {
                                block = new Timer();
                                break;
                            }
                            case 0x14000000: {
                                block = new Marker();
                            }
                        }
                        if (block == null) continue;
                        blocks.add((Recording)block);
                        continue;
                    }
                    if ((long)dataSize + this.in.getFilePointer() > this.in.length() || dataSize <= 0) break;
                    this.in.skipBytes(dataSize);
                }
                ArrayList<SubBlock> nonAcquiredBlocks = new ArrayList<SubBlock>();
                for (SubBlock block : metadataBlocks = blocks.toArray(new SubBlock[0])) {
                    block.addToHashtable();
                    if (block.acquire) continue;
                    nonAcquiredBlocks.add(block);
                    blocks.remove(block);
                }
                for (int i5 = 0; i5 < blocks.size(); ++i5) {
                    SubBlock prevBlock;
                    SubBlock block = (SubBlock)blocks.get(i5);
                    if (block instanceof IlluminationChannel && i5 < blocks.size() - 1) {
                        SubBlock nextBlock = (SubBlock)blocks.get(i5 + 1);
                        if (!(nextBlock instanceof DataChannel) && !(nextBlock instanceof IlluminationChannel)) {
                            ((IlluminationChannel)block).wavelength = null;
                        }
                    } else if (block instanceof DetectionChannel && i5 > 0 && !((prevBlock = (SubBlock)blocks.get(i5 - 1)) instanceof Track) && !(prevBlock instanceof DetectionChannel)) {
                        block.acquire = false;
                        nonAcquiredBlocks.add(block);
                    }
                    if (!block.acquire) continue;
                    this.populateMetadataStore(block, store, series);
                }
                for (SubBlock block : nonAcquiredBlocks) {
                    this.populateMetadataStore(block, store, series);
                }
            }
        }
        this.imageNames.add(imageName);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            if (this.userName != null) {
                String experimenterID = MetadataTools.createLSID("Experimenter", 0);
                store.setExperimenterID(experimenterID, 0);
                store.setExperimenterUserName(this.userName, 0);
            }
            Length pixX = FormatTools.getPhysicalSizeX(this.pixelSizeX);
            Length pixY = FormatTools.getPhysicalSizeY(this.pixelSizeY);
            Length pixZ = FormatTools.getPhysicalSizeZ(this.pixelSizeZ);
            if (pixX != null) {
                store.setPixelsPhysicalSizeX(pixX, series);
            }
            if (pixY != null) {
                store.setPixelsPhysicalSizeY(pixY, series);
            }
            if (pixZ != null) {
                store.setPixelsPhysicalSizeZ(pixZ, series);
            }
            for (int i6 = 0; i6 < this.getSizeC(); ++i6) {
                store.setChannelColor(this.channelColor[i6], series, i6);
                if (this.channelNames[series] == null) continue;
                store.setChannelName(this.channelNames[series][i6], series, i6);
            }
            int stampIndex = 0;
            for (int i7 = 0; i7 < series; ++i7) {
                stampIndex += ((CoreMetadata)this.core.get((int)i7)).sizeT;
            }
            double firstStamp = 0.0;
            if (this.timestamps.size() > 0 && stampIndex < this.timestamps.size()) {
                firstStamp = this.timestamps.get(stampIndex);
            }
            for (int i8 = 0; i8 < this.getImageCount(); ++i8) {
                int[] zct = FormatTools.getZCTCoords(this, i8);
                if (this.getSizeT() > 1 && zct[2] < this.timestamps.size() - stampIndex) {
                    double thisStamp = this.timestamps.get(stampIndex + zct[2]);
                    store.setPlaneDeltaT(new Time(thisStamp - firstStamp, UNITS.SECOND), series, i8);
                }
                if (this.xCoordinates.size() <= series) continue;
                Double xCoord = this.xCoordinates.get(series);
                Double yCoord = this.yCoordinates.get(series);
                Double zCoord = this.zCoordinates.get(series);
                if (xCoord == null) {
                    store.setPlanePositionX(null, series, i8);
                } else {
                    Length x = new Length(xCoord, UNITS.REFERENCEFRAME);
                    store.setPlanePositionX(x, series, i8);
                }
                if (yCoord == null) {
                    store.setPlanePositionY(null, series, i8);
                } else {
                    Length y = new Length(yCoord, UNITS.REFERENCEFRAME);
                    store.setPlanePositionY(y, series, i8);
                }
                if (zCoord == null) {
                    store.setPlanePositionZ(null, series, i8);
                    continue;
                }
                Length z = new Length(zCoord, UNITS.REFERENCEFRAME);
                store.setPlanePositionZ(z, series, i8);
            }
        }
        ras.close();
    }

    protected void populateMetadataStore(SubBlock block, MetadataStore store, int series) throws FormatException {
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        int instrument = this.getEffectiveSeries(series);
        if (block instanceof Recording) {
            Recording recording = (Recording)block;
            String objectiveID = MetadataTools.createLSID("Objective", instrument, 0);
            if (recording.acquire) {
                store.setImageDescription(recording.description, series);
                if (recording.startTime != null) {
                    this.acquiredDate.put(series, recording.startTime);
                }
                store.setObjectiveSettingsID(objectiveID, series);
                this.binning = recording.binning;
            }
            store.setObjectiveCorrection(this.getCorrection(recording.correction), instrument, 0);
            store.setObjectiveImmersion(this.getImmersion(recording.immersion), instrument, 0);
            if (recording.magnification != null) {
                store.setObjectiveNominalMagnification(recording.magnification, instrument, 0);
            }
            store.setObjectiveLensNA(recording.lensNA, instrument, 0);
            store.setObjectiveIris(recording.iris, instrument, 0);
            store.setObjectiveID(objectiveID, instrument, 0);
        } else if (block instanceof Laser) {
            Laser laser = (Laser)block;
            if (laser.medium != null) {
                store.setLaserLaserMedium(this.getLaserMedium(laser.medium), instrument, this.nextLaser);
            }
            if (laser.type != null) {
                store.setLaserType(this.getLaserType(laser.type), instrument, this.nextLaser);
            }
            if (laser.model != null) {
                store.setLaserModel(laser.model, instrument, this.nextLaser);
            }
            String lightSourceID = MetadataTools.createLSID("LightSource", instrument, this.nextLaser);
            store.setLaserID(lightSourceID, instrument, this.nextLaser);
            ++this.nextLaser;
        } else if (block instanceof Track) {
            Track track = (Track)block;
            if (track.acquire && track.timeIncrement != null) {
                store.setPixelsTimeIncrement(new Time(track.timeIncrement, UNITS.SECOND), series);
            }
        } else if (block instanceof DetectionChannel) {
            DetectionChannel channel = (DetectionChannel)block;
            if (channel.pinhole != null && channel.pinhole != 0.0 && this.nextDetectChannel < this.getSizeC() && channel.acquire) {
                store.setChannelPinholeSize(new Length(channel.pinhole, UNITS.MICROMETER), series, this.nextDetectChannel);
            }
            if (channel.filter != null) {
                String id = MetadataTools.createLSID("Filter", instrument, this.nextFilter);
                if (channel.acquire && this.nextDetectChannel < this.getSizeC()) {
                    store.setLightPathEmissionFilterRef(id, instrument, this.nextDetectChannel, 0);
                }
                store.setFilterID(id, instrument, this.nextFilter);
                store.setFilterModel(channel.filter, instrument, this.nextFilter);
                int space = channel.filter.indexOf(32);
                if (space != -1) {
                    String type = channel.filter.substring(0, space).trim();
                    if (type.equals("BP")) {
                        type = "BandPass";
                    } else if (type.equals("LP")) {
                        type = "LongPass";
                    }
                    store.setFilterType(this.getFilterType(type), instrument, this.nextFilter);
                    String transmittance = channel.filter.substring(space + 1).trim();
                    String[] v = transmittance.split("-");
                    try {
                        Double cutIn = new Double(v[0].trim());
                        Length in = FormatTools.getCutIn(cutIn);
                        if (in != null) {
                            store.setTransmittanceRangeCutIn(in, instrument, this.nextFilter);
                        }
                    }
                    catch (NumberFormatException cutIn) {
                        // empty catch block
                    }
                    if (v.length > 1) {
                        try {
                            Double cutOut = new Double(v[1].trim());
                            Length out = FormatTools.getCutOut(cutOut);
                            if (out != null) {
                                store.setTransmittanceRangeCutOut(out, instrument, this.nextFilter);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                ++this.nextFilter;
            }
            if (channel.channelName != null) {
                String detectorID = MetadataTools.createLSID("Detector", instrument, this.nextDetector);
                store.setDetectorID(detectorID, instrument, this.nextDetector);
                if (channel.acquire && this.nextDetector < this.getSizeC()) {
                    store.setDetectorSettingsID(detectorID, series, this.nextDetector);
                }
            }
            if (channel.amplificationGain != null) {
                store.setDetectorAmplificationGain(channel.amplificationGain, instrument, this.nextDetector);
            }
            if (channel.gain != null) {
                store.setDetectorGain(channel.gain, instrument, this.nextDetector);
            }
            store.setDetectorType(this.getDetectorType("PMT"), instrument, this.nextDetector);
            store.setDetectorZoom(this.zoom, instrument, this.nextDetector);
            ++this.nextDetectChannel;
            ++this.nextDetector;
        } else if (block instanceof BeamSplitter) {
            BeamSplitter beamSplitter = (BeamSplitter)block;
            if (beamSplitter.filterSet != null) {
                if (beamSplitter.filter != null) {
                    String id = MetadataTools.createLSID("Dichroic", instrument, this.nextDichroic);
                    store.setDichroicID(id, instrument, this.nextDichroic);
                    store.setDichroicModel(beamSplitter.filter, instrument, this.nextDichroic);
                    if (this.nextDichroicChannel < this.getEffectiveSizeC()) {
                        // empty if block
                    }
                    ++this.nextDichroic;
                }
                ++this.nextDichroicChannel;
            }
        } else if (block instanceof IlluminationChannel) {
            IlluminationChannel channel = (IlluminationChannel)block;
            if (channel.acquire && channel.wavelength != null && channel.wavelength > 0.0) {
                Length wave = FormatTools.getWavelength(channel.wavelength);
                if (wave != null) {
                    store.setLaserWavelength(wave, instrument, this.nextIllumChannel);
                }
                if (this.nextIllumChannel >= this.nextLaser) {
                    String lightSourceID = MetadataTools.createLSID("LightSource", instrument, this.nextIllumChannel);
                    store.setLaserID(lightSourceID, instrument, this.nextIllumChannel);
                }
                ++this.nextIllumChannel;
            }
        }
    }

    protected void parseOverlays(int series, long data, String suffix, MetadataStore store) throws IOException {
        if (data == 0L) {
            return;
        }
        String prefix = "Series " + series + " ";
        this.in.seek(data);
        int numberOfShapes = this.in.readInt();
        int size = this.in.readInt();
        if (size <= 194) {
            return;
        }
        this.in.skipBytes(20);
        boolean valid = this.in.readInt() == 1;
        this.in.skipBytes(164);
        block12: for (int i = this.totalROIs; i < this.totalROIs + numberOfShapes; ++i) {
            long offset = this.in.getFilePointer();
            int type = this.in.readInt();
            int blockLength = this.in.readInt();
            double lineWidth = this.in.readInt();
            int measurements = this.in.readInt();
            double textOffsetX = this.in.readDouble();
            double textOffsetY = this.in.readDouble();
            int color = this.in.readInt();
            boolean validShape = this.in.readInt() != 0;
            int knotWidth = this.in.readInt();
            int catchArea = this.in.readInt();
            int fontHeight = this.in.readInt();
            int fontWidth = this.in.readInt();
            int fontEscapement = this.in.readInt();
            int fontOrientation = this.in.readInt();
            int fontWeight = this.in.readInt();
            boolean fontItalic = this.in.readInt() != 0;
            boolean fontUnderlined = this.in.readInt() != 0;
            boolean fontStrikeout = this.in.readInt() != 0;
            int fontCharSet = this.in.readInt();
            int fontOutputPrecision = this.in.readInt();
            int fontClipPrecision = this.in.readInt();
            int fontQuality = this.in.readInt();
            int fontPitchAndFamily = this.in.readInt();
            String fontName = DataTools.stripString(this.in.readString(64));
            boolean enabled = this.in.readShort() == 0;
            boolean moveable = this.in.readInt() == 0;
            this.in.skipBytes(34);
            String roiID = MetadataTools.createLSID("ROI", i);
            String shapeID = MetadataTools.createLSID("Shape", i--, 0);
            Length fontSize = FormatTools.getFontSize(fontHeight);
            Length line = new Length(lineWidth, UNITS.PIXEL);
            switch (type) {
                case 13: {
                    double x = this.in.readDouble();
                    double y = this.in.readDouble();
                    String text = DataTools.stripString(this.in.readCString());
                    store.setROIID(roiID, i);
                    store.setLabelID(shapeID, i, 0);
                    store.setLabelX(x, i, 0);
                    store.setLabelY(y, i, 0);
                    store.setLabelText(text, i, 0);
                    if (fontSize != null) {
                        store.setLabelFontSize(fontSize, i, 0);
                    }
                    store.setLabelStrokeWidth(line, i, 0);
                    store.setImageROIRef(roiID, series, i);
                    break;
                }
                case 14: {
                    this.in.skipBytes(4);
                    double startX = this.in.readDouble();
                    double startY = this.in.readDouble();
                    double endX = this.in.readDouble();
                    double endY = this.in.readDouble();
                    store.setROIID(roiID, i);
                    store.setLineID(shapeID, i, 0);
                    store.setLineX1(startX, i, 0);
                    store.setLineY1(startY, i, 0);
                    store.setLineX2(endX, i, 0);
                    store.setLineY2(endY, i, 0);
                    if (fontSize != null) {
                        store.setLineFontSize(fontSize, i, 0);
                    }
                    store.setLineStrokeWidth(line, i, 0);
                    store.setImageROIRef(roiID, series, i);
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 25: {
                    this.in.skipBytes(36);
                    --numberOfShapes;
                    break;
                }
                case 18: {
                    this.in.skipBytes(4);
                    double topX = this.in.readDouble();
                    double topY = this.in.readDouble();
                    double bottomX = this.in.readDouble();
                    double bottomY = this.in.readDouble();
                    double width = Math.abs(bottomX - topX);
                    double height = Math.abs(bottomY - topY);
                    topX = Math.min(topX, bottomX);
                    topY = Math.min(topY, bottomY);
                    store.setROIID(roiID, i);
                    store.setRectangleID(shapeID, i, 0);
                    store.setRectangleX(topX, i, 0);
                    store.setRectangleY(topY, i, 0);
                    store.setRectangleWidth(width, i, 0);
                    store.setRectangleHeight(height, i, 0);
                    if (fontSize != null) {
                        store.setRectangleFontSize(fontSize, i, 0);
                    }
                    store.setRectangleStrokeWidth(line, i, 0);
                    store.setImageROIRef(roiID, series, i);
                    break;
                }
                case 19: {
                    int knots = this.in.readInt();
                    double[] xs = new double[knots];
                    double[] ys = new double[knots];
                    for (int j = 0; j < xs.length; ++j) {
                        xs[j] = this.in.readDouble();
                        ys[j] = this.in.readDouble();
                    }
                    double rx = 0.0;
                    double ry = 0.0;
                    double centerX = 0.0;
                    double centerY = 0.0;
                    store.setROIID(roiID, i);
                    store.setEllipseID(shapeID, i, 0);
                    if (knots == 4) {
                        double r1x = Math.abs(xs[2] - xs[0]) / 2.0;
                        double r1y = Math.abs(ys[2] - ys[0]) / 2.0;
                        double r2x = Math.abs(xs[3] - xs[1]) / 2.0;
                        double r2y = Math.abs(ys[3] - ys[1]) / 2.0;
                        if (r1x > r2x) {
                            ry = r1y;
                            rx = r2x;
                            centerX = Math.min(xs[3], xs[1]) + rx;
                            centerY = Math.min(ys[2], ys[0]) + ry;
                        } else {
                            ry = r2y;
                            rx = r1x;
                            centerX = Math.min(xs[2], xs[0]) + rx;
                            centerY = Math.min(ys[3], ys[1]) + ry;
                        }
                    } else if (knots == 3) {
                        centerX = xs[0];
                        centerY = ys[0];
                        rx = Math.sqrt(Math.pow(xs[1] - xs[0], 2.0) + Math.pow(ys[1] - ys[0], 2.0));
                        ry = Math.sqrt(Math.pow(xs[2] - xs[0], 2.0) + Math.pow(ys[2] - ys[0], 2.0));
                        double slope = (ys[2] - centerY) / (xs[2] - centerX);
                        double theta = Math.toDegrees(Math.atan(slope));
                        store.setEllipseTransform(this.getRotationTransform(theta), i, 0);
                    }
                    store.setEllipseX(centerX, i, 0);
                    store.setEllipseY(centerY, i, 0);
                    store.setEllipseRadiusX(rx, i, 0);
                    store.setEllipseRadiusY(ry, i, 0);
                    if (fontSize != null) {
                        store.setEllipseFontSize(fontSize, i, 0);
                    }
                    store.setEllipseStrokeWidth(line, i, 0);
                    store.setImageROIRef(roiID, series, i);
                    break;
                }
                case 24: {
                    this.in.skipBytes(4);
                    double centerX = this.in.readDouble();
                    double centerY = this.in.readDouble();
                    double curveX = this.in.readDouble();
                    double curveY = this.in.readDouble();
                    double radius = Math.sqrt(Math.pow(curveX - centerX, 2.0) + Math.pow(curveY - centerY, 2.0));
                    store.setROIID(roiID, i);
                    store.setEllipseID(shapeID, i, 0);
                    store.setEllipseX(centerX, i, 0);
                    store.setEllipseY(centerY, i, 0);
                    store.setEllipseRadiusX(radius, i, 0);
                    store.setEllipseRadiusY(radius, i, 0);
                    if (fontSize != null) {
                        store.setEllipseFontSize(fontSize, i, 0);
                    }
                    store.setEllipseStrokeWidth(line, i, 0);
                    store.setImageROIRef(roiID, series, i);
                    break;
                }
                case 29: {
                    this.in.skipBytes(4);
                    double[][] points = new double[3][2];
                    for (int j = 0; j < points.length; ++j) {
                        for (int k = 0; k < points[j].length; ++k) {
                            points[j][k] = this.in.readDouble();
                        }
                    }
                    double s = 0.5 * ((points[1][0] - points[2][0]) * (points[0][0] - points[2][0]) - (points[1][1] - points[2][1]) * (points[2][1] - points[0][1]));
                    double div = (points[0][0] - points[1][0]) * (points[2][1] - points[0][1]) - (points[1][1] - points[0][1]) * (points[0][0] - points[2][0]);
                    double cx = 0.5 * (points[0][0] + points[1][0]) + (s /= div) * (points[1][1] - points[0][1]);
                    double cy = 0.5 * (points[0][1] + points[1][1]) + s * (points[0][0] - points[1][0]);
                    double r = Math.sqrt(Math.pow(points[0][0] - cx, 2.0) + Math.pow(points[0][1] - cy, 2.0));
                    store.setROIID(roiID, i);
                    store.setEllipseID(shapeID, i, 0);
                    store.setEllipseX(cx, i, 0);
                    store.setEllipseY(cy, i, 0);
                    store.setEllipseRadiusX(r, i, 0);
                    store.setEllipseRadiusY(r, i, 0);
                    if (fontSize != null) {
                        store.setEllipseFontSize(fontSize, i, 0);
                    }
                    store.setEllipseStrokeWidth(line, i, 0);
                    store.setImageROIRef(roiID, series, i);
                    break;
                }
                case 28: {
                    this.in.skipBytes(4);
                    double[][] points = new double[3][2];
                    for (int j = 0; j < points.length; ++j) {
                        for (int k = 0; k < points[j].length; ++k) {
                            points[j][k] = this.in.readDouble();
                        }
                    }
                    StringBuilder p = new StringBuilder();
                    for (int j = 0; j < points.length; ++j) {
                        p.append(points[j][0]);
                        p.append(",");
                        p.append(points[j][1]);
                        if (j >= points.length - 1) continue;
                        p.append(" ");
                    }
                    store.setROIID(roiID, i);
                    store.setPolylineID(shapeID, i, 0);
                    store.setPolylinePoints(p.toString(), i, 0);
                    if (fontSize != null) {
                        store.setPolylineFontSize(fontSize, i, 0);
                    }
                    store.setPolylineStrokeWidth(line, i, 0);
                    store.setImageROIRef(roiID, series, i);
                    break;
                }
                case 20: 
                case 21: 
                case 26: {
                    int k;
                    int j;
                    int nKnots = this.in.readInt();
                    double[][] points = new double[nKnots][2];
                    for (j = 0; j < points.length; ++j) {
                        for (k = 0; k < points[j].length; ++k) {
                            points[j][k] = this.in.readDouble();
                        }
                    }
                    StringBuilder p = new StringBuilder();
                    for (j = 0; j < points.length; ++j) {
                        p.append(points[j][0]);
                        p.append(",");
                        p.append(points[j][1]);
                        if (j >= points.length - 1) continue;
                        p.append(" ");
                    }
                    store.setROIID(roiID, i);
                    if (type != 20) {
                        store.setPolylinePoints(p.toString(), i, 0);
                        if (fontSize != null) {
                            store.setPolylineFontSize(fontSize, i, 0);
                        }
                        store.setPolylineStrokeWidth(line, i, 0);
                        store.setPolylineID(shapeID, i, 0);
                    } else {
                        store.setPolygonPoints(p.toString(), i, 0);
                        if (fontSize != null) {
                            store.setPolygonFontSize(fontSize, i, 0);
                        }
                        store.setPolygonStrokeWidth(line, i, 0);
                        store.setPolygonID(shapeID, i, 0);
                    }
                    store.setImageROIRef(roiID, series, i);
                    break;
                }
                case 22: 
                case 23: 
                case 27: {
                    int k;
                    int j;
                    int nKnots = this.in.readInt();
                    double[][] points = new double[nKnots][2];
                    for (j = 0; j < points.length; ++j) {
                        for (k = 0; k < points[j].length; ++k) {
                            points[j][k] = this.in.readDouble();
                        }
                    }
                    StringBuilder p = new StringBuilder();
                    for (j = 0; j < points.length; ++j) {
                        p.append(points[j][0]);
                        p.append(",");
                        p.append(points[j][1]);
                        if (j >= points.length - 1) continue;
                        p.append(" ");
                    }
                    store.setROIID(roiID, i);
                    if (type == 23) {
                        store.setPolylineID(shapeID, i, 0);
                        store.setPolylinePoints(p.toString(), i, 0);
                        if (fontSize != null) {
                            store.setPolylineFontSize(fontSize, i, 0);
                        }
                        store.setPolylineStrokeWidth(line, i, 0);
                    } else {
                        store.setPolygonID(shapeID, i, 0);
                        store.setPolygonPoints(p.toString(), i, 0);
                        if (fontSize != null) {
                            store.setPolygonFontSize(fontSize, i, 0);
                        }
                        store.setPolygonStrokeWidth(line, i, 0);
                    }
                    store.setImageROIRef(roiID, series, i);
                    break;
                }
                default: {
                    --i;
                    --numberOfShapes;
                    continue block12;
                }
            }
            this.in.seek(offset + (long)blockLength);
        }
        this.totalROIs += numberOfShapes;
    }

    private String[] parseMDB(String mdbFile) throws FormatException, IOException {
        int i;
        String absolutePath;
        Location mdb = new Location(mdbFile).getAbsoluteFile();
        Location parent = mdb.getParentFile();
        MDBService mdbService = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            mdbService = factory.getInstance(MDBService.class);
        }
        catch (DependencyException de) {
            throw new FormatException("MDB Tools Java library not found", de);
        }
        try {
            mdbService.initialize(mdbFile);
        }
        catch (Exception e) {
            return null;
        }
        Vector<Vector<String[]>> tables = mdbService.parseDatabase();
        mdbService.close();
        ArrayList<String> referencedLSMs = new ArrayList<String>();
        int referenceCount = 0;
        for (Vector<String[]> table : tables) {
            String[] columnNames = table.get(0);
            String tableName = columnNames[0];
            for (int row = 1; row < table.size(); ++row) {
                String[] tableRow = table.get(row);
                for (int col = 0; col < tableRow.length; ++col) {
                    Location file2;
                    String key = tableName + " " + columnNames[col + 1];
                    if (this.currentId != null) {
                        this.addGlobalMetaList(key, tableRow[col]);
                    }
                    if (!tableName.equals("Recordings") || columnNames[col + 1] == null || !columnNames[col + 1].equals("SampleData")) continue;
                    String filename = tableRow[col].trim();
                    filename = filename.replace('\\', File.separatorChar);
                    filename = filename.replace('/', File.separatorChar);
                    if ((filename = filename.substring(filename.lastIndexOf(File.separator) + 1)).length() > 0 && (file2 = new Location(parent, filename)).exists()) {
                        referencedLSMs.add(file2.getAbsolutePath());
                    }
                    ++referenceCount;
                }
            }
        }
        if (referencedLSMs.size() == referenceCount) {
            return referencedLSMs.toArray(new String[0]);
        }
        Object[] fileList = parent.list(true);
        Arrays.sort(fileList);
        for (int i2 = 0; i2 < fileList.length; ++i2) {
            Location f = new Location((String)fileList[i2]);
            if (!f.exists()) {
                f = new Location(parent, (String)fileList[i2]);
            }
            absolutePath = f.getAbsolutePath();
            if (!ZeissLSMReader.checkSuffix((String)fileList[i2], "mdb") || absolutePath.equals(mdbFile) || ((String)fileList[i2]).equals(mdbFile) || absolutePath.equals(new Location(mdbFile).getAbsolutePath())) continue;
            if (referencedLSMs.size() <= 0) break;
            return referencedLSMs.toArray(new String[0]);
        }
        referencedLSMs.clear();
        int mdbCount = 0;
        for (i = 0; i < fileList.length; ++i) {
            absolutePath = new Location(parent, (String)fileList[i]).getAbsolutePath();
            if (ZeissLSMReader.checkSuffix((String)fileList[i], "lsm")) {
                referencedLSMs.add(absolutePath);
                continue;
            }
            if (!ZeissLSMReader.checkSuffix((String)fileList[i], "mdb")) continue;
            ++mdbCount;
        }
        if (mdbCount > 1 || referencedLSMs.size() > referenceCount && mdbCount > 1) {
            for (i = 0; i < fileList.length; ++i) {
                String[] files;
                absolutePath = new Location(parent, (String)fileList[i]).getAbsolutePath();
                if (!ZeissLSMReader.checkSuffix((String)fileList[i], "mdb") || absolutePath.endsWith(mdbFile)) continue;
                for (String f : files = this.parseMDB(absolutePath)) {
                    referencedLSMs.remove(f);
                }
            }
        }
        return referencedLSMs.toArray(new String[0]);
    }

    private static ImmutableMap<Integer, String> createKeys() {
        ImmutableMap.Builder<Integer, String> h = ImmutableMap.builder();
        h.put(0x10000001, "Name");
        h.put(0x4000000C, "Name");
        h.put(0x50000001, "Name");
        h.put(-1879048191, "Name");
        h.put(-1879048187, "Detection Channel Name");
        h.put(-1342177277, "Name");
        h.put(-805306367, "Name");
        h.put(0x12000001, "Name");
        h.put(0x14000001, "Name");
        h.put(0x10000002, "Description");
        h.put(335544322, "Description");
        h.put(0x10000003, "Notes");
        h.put(0x10000004, "Objective");
        h.put(0x10000005, "Processing Summary");
        h.put(0x10000006, "Special Scan Mode");
        h.put(0x10000007, "Scan Type");
        h.put(0x10000008, "Scan Mode");
        h.put(0x10000009, "Number of Stacks");
        h.put(0x1000000A, "Lines Per Plane");
        h.put(0x1000000B, "Samples Per Line");
        h.put(0x1000000C, "Planes Per Volume");
        h.put(0x1000000D, "Images Width");
        h.put(0x1000000E, "Images Height");
        h.put(0x1000000F, "Number of Planes");
        h.put(0x10000010, "Number of Stacks");
        h.put(0x10000011, "Number of Channels");
        h.put(0x10000012, "Linescan XY Size");
        h.put(0x10000013, "Scan Direction");
        h.put(0x10000014, "Time Series");
        h.put(0x10000015, "Original Scan Data");
        h.put(0x10000016, "Zoom X");
        h.put(0x10000017, "Zoom Y");
        h.put(0x10000018, "Zoom Z");
        h.put(0x10000019, "Sample 0X");
        h.put(0x1000001A, "Sample 0Y");
        h.put(0x1000001B, "Sample 0Z");
        h.put(0x1000001C, "Sample Spacing");
        h.put(0x1000001D, "Line Spacing");
        h.put(0x1000001E, "Plane Spacing");
        h.put(0x1000001F, "Plane Width");
        h.put(0x10000020, "Plane Height");
        h.put(0x10000021, "Volume Depth");
        h.put(268435508, "Rotation");
        h.put(268435509, "Precession");
        h.put(268435510, "Sample 0Time");
        h.put(268435511, "Start Scan Trigger In");
        h.put(268435512, "Start Scan Trigger Out");
        h.put(268435513, "Start Scan Event");
        h.put(0x10000040, "Start Scan Time");
        h.put(0x10000041, "Stop Scan Trigger In");
        h.put(268435522, "Stop Scan Trigger Out");
        h.put(268435523, "Stop Scan Event");
        h.put(0x10000044, "Stop Scan Time");
        h.put(268435525, "Use ROIs");
        h.put(268435526, "Use Reduced Memory ROIs");
        h.put(268435527, "User");
        h.put(268435528, "Use B/C Correction");
        h.put(268435529, "Position B/C Contrast 1");
        h.put(0x10000050, "Position B/C Contrast 2");
        h.put(0x10000051, "Interpolation Y");
        h.put(268435538, "Camera Binning");
        h.put(268435539, "Camera Supersampling");
        h.put(268435540, "Camera Frame Width");
        h.put(0x10000055, "Camera Frame Height");
        h.put(268435542, "Camera Offset X");
        h.put(268435543, "Camera Offset Y");
        h.put(0x40000001, "Multiplex Type");
        h.put(0x40000002, "Multiplex Order");
        h.put(0x40000003, "Sampling Mode");
        h.put(0x40000004, "Sampling Method");
        h.put(0x40000005, "Sampling Number");
        h.put(0x40000006, "Acquire");
        h.put(0x50000002, "Acquire");
        h.put(0x7000000B, "Acquire");
        h.put(-1879048188, "Acquire");
        h.put(-805306345, "Acquire");
        h.put(0x40000007, "Sample Observation Time");
        h.put(0x40000008, "Time Between Stacks");
        h.put(0x4000000D, "Collimator 1 Name");
        h.put(0x4000000E, "Collimator 1 Position");
        h.put(0x4000000F, "Collimator 2 Name");
        h.put(0x40000010, "Collimator 2 Position");
        h.put(0x40000011, "Is Bleach Track");
        h.put(1073741842, "Bleach After Scan Number");
        h.put(1073741843, "Bleach Scan Number");
        h.put(0x40000014, "Trigger In");
        h.put(301989892, "Trigger In");
        h.put(335544323, "Trigger In");
        h.put(1073741845, "Trigger Out");
        h.put(301989893, "Trigger Out");
        h.put(0x14000004, "Trigger Out");
        h.put(1073741846, "Is Ratio Track");
        h.put(1073741847, "Bleach Count");
        h.put(1073741848, "SPI Center Wavelength");
        h.put(1073741849, "Pixel Time");
        h.put(0x40000020, "ID Condensor Frontlens");
        h.put(1073741857, "Condensor Frontlens");
        h.put(0x40000022, "ID Field Stop");
        h.put(1073741859, "Field Stop Value");
        h.put(0x40000024, "ID Condensor Aperture");
        h.put(1073741861, "Condensor Aperture");
        h.put(1073741862, "ID Condensor Revolver");
        h.put(1073741863, "Condensor Revolver");
        h.put(1073741864, "ID Transmission Filter 1");
        h.put(1073741865, "ID Transmission 1");
        h.put(0x40000030, "ID Transmission Filter 2");
        h.put(1073741873, "ID Transmission 2");
        h.put(1073741874, "Repeat Bleach");
        h.put(0x40000033, "Enable Spot Bleach Pos");
        h.put(0x40000034, "Spot Bleach Position X");
        h.put(1073741877, "Spot Bleach Position Y");
        h.put(1073741878, "Bleach Position Z");
        h.put(0x50000003, "Power");
        h.put(-1879048190, "Power");
        h.put(0x70000003, "Detector Gain");
        h.put(0x70000005, "Amplifier Gain");
        h.put(0x70000007, "Amplifier Offset");
        h.put(0x70000009, "Pinhole Diameter");
        h.put(0x7000000C, "Detector Name");
        h.put(0x7000000D, "Amplifier Name");
        h.put(0x7000000E, "Pinhole Name");
        h.put(0x7000000F, "Filter Set Name");
        h.put(0x70000010, "Filter Name");
        h.put(1879048211, "Integrator Name");
        h.put(1879048212, "Detection Channel Name");
        h.put(1879048213, "Detector Gain B/C 1");
        h.put(1879048214, "Detector Gain B/C 2");
        h.put(0x70000017, "Amplifier Gain B/C 1");
        h.put(1879048216, "Amplifier Gain B/C 2");
        h.put(1879048217, "Amplifier Offset B/C 1");
        h.put(0x70000020, "Amplifier Offset B/C 2");
        h.put(1879048225, "Spectral Scan Channels");
        h.put(0x70000022, "SPI Wavelength Start");
        h.put(1879048227, "SPI Wavelength End");
        h.put(1879048230, "Dye Name");
        h.put(-805306348, "Dye Name");
        h.put(0x70000027, "Dye Folder");
        h.put(-805306347, "Dye Folder");
        h.put(-1879048189, "Wavelength");
        h.put(-1879048186, "Power B/C 1");
        h.put(-1879048185, "Power B/C 2");
        h.put(-1342177279, "Filter Set");
        h.put(-1342177278, "Filter");
        h.put(-805306364, "Color");
        h.put(-805306363, "Sample Type");
        h.put(-805306362, "Bits Per Sample");
        h.put(-805306361, "Ratio Type");
        h.put(-805306360, "Ratio Track 1");
        h.put(-805306359, "Ratio Track 2");
        h.put(-805306358, "Ratio Channel 1");
        h.put(-805306357, "Ratio Channel 2");
        h.put(-805306356, "Ratio Const. 1");
        h.put(-805306355, "Ratio Const. 2");
        h.put(-805306354, "Ratio Const. 3");
        h.put(-805306353, "Ratio Const. 4");
        h.put(-805306352, "Ratio Const. 5");
        h.put(-805306351, "Ratio Const. 6");
        h.put(-805306350, "Ratio First Images 1");
        h.put(-805306349, "Ratio First Images 2");
        h.put(-805306346, "Spectrum");
        h.put(301989891, "Interval");
        return h.build();
    }

    private Integer readEntry() throws IOException {
        return this.in.readInt();
    }

    private Object readValue() throws IOException {
        int blockType = this.in.readInt();
        int dataSize = this.in.readInt();
        switch (blockType) {
            case 4: {
                return this.in.readInt();
            }
            case 5: {
                return this.in.readDouble();
            }
            case 2: {
                String s = this.in.readByteToString(dataSize).trim();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < s.length() && s.charAt(i) >= '\n'; ++i) {
                    sb.append(s.charAt(i));
                }
                return sb.toString();
            }
            case 0: {
                return null;
            }
        }
        this.in.skipBytes(dataSize);
        return "";
    }

    private void parseApplicationTags() throws IOException {
        int blockSize = this.in.readInt();
        int numEntries = this.in.readInt();
        for (int i = 0; i < numEntries; ++i) {
            long fp = this.in.getFilePointer();
            int entrySize = this.in.readInt();
            int entryNameLength = this.in.readInt();
            String entryName = this.in.readString(entryNameLength);
            int dataType = this.in.readInt();
            int dataSize = this.in.readInt();
            Object data = null;
            switch (dataType) {
                case 2: {
                    data = this.in.readString(dataSize);
                    break;
                }
                case 4: {
                    data = this.in.readInt();
                    break;
                }
                case 5: {
                    data = this.in.readDouble();
                    break;
                }
                case 6: {
                    data = this.in.readLong();
                    break;
                }
                case 7: {
                    data = this.in.readInt() == 0;
                }
            }
            this.addGlobalMeta(entryName, data);
            if (entryName.startsWith("SimOut") || entryName.startsWith("SimPar")) {
                this.isSIM = true;
            }
            if (this.in.getFilePointer() == fp + (long)entrySize) continue;
            int nDimensions = this.in.readInt();
            int[] coordinate = new int[nDimensions];
            for (int n = 0; n < nDimensions; ++n) {
                coordinate[n] = this.in.readInt();
            }
        }
    }

    class Marker
    extends SubBlock {
        Marker() {
        }
    }

    class Timer
    extends SubBlock {
        Timer() {
        }
    }

    class BeamSplitter
    extends SubBlock {
        public String filter;
        public String filterSet;

        BeamSplitter() {
        }

        @Override
        protected void read() throws IOException {
            super.read();
            this.filter = this.getStringValue(-1342177278);
            if (this.filter != null) {
                this.filter = this.filter.trim();
                if (this.filter.length() == 0 || this.filter.equals("None")) {
                    this.filter = null;
                }
            }
            this.filterSet = this.getStringValue(-1342177277);
        }
    }

    class DataChannel
    extends SubBlock {
        public String name;

        DataChannel() {
        }

        @Override
        protected void read() throws IOException {
            super.read();
            this.name = this.getStringValue(-805306367);
            for (int i = 0; i < this.name.length(); ++i) {
                if (this.name.charAt(i) >= '\n') continue;
                this.name = this.name.substring(0, i);
                break;
            }
            this.acquire = this.getIntValue(-805306345) != 0;
        }
    }

    class IlluminationChannel
    extends SubBlock {
        public Double wavelength;
        public Double attenuation;
        public String name;

        IlluminationChannel() {
        }

        @Override
        protected void read() throws IOException {
            super.read();
            this.wavelength = this.getDoubleValue(-1879048189);
            this.attenuation = this.getDoubleValue(-1879048190);
            this.acquire = this.getIntValue(-1879048188) != 0;
            this.name = this.getStringValue(-1879048191);
            try {
                this.wavelength = new Double(this.name);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    class DetectionChannel
    extends SubBlock {
        public Double pinhole;
        public Double gain;
        public Double amplificationGain;
        public String filter;
        public String filterSet;
        public String channelName;

        DetectionChannel() {
        }

        @Override
        protected void read() throws IOException {
            super.read();
            this.pinhole = this.getDoubleValue(0x70000009);
            this.gain = this.getDoubleValue(0x70000003);
            this.amplificationGain = this.getDoubleValue(0x70000005);
            this.filter = this.getStringValue(0x70000010);
            if (this.filter != null) {
                this.filter = this.filter.trim();
                if (this.filter.length() == 0 || this.filter.equals("None")) {
                    this.filter = null;
                }
            }
            this.filterSet = this.getStringValue(0x7000000F);
            this.channelName = this.getStringValue(1879048212);
            this.acquire = this.getIntValue(0x7000000B) != 0;
        }
    }

    class Track
    extends SubBlock {
        public Double timeIncrement;

        Track() {
        }

        @Override
        protected void read() throws IOException {
            super.read();
            this.timeIncrement = this.getDoubleValue(0x4000000B);
            this.acquire = this.getIntValue(0x40000006) != 0;
        }
    }

    class Laser
    extends SubBlock {
        public String medium;
        public String type;
        public String model;
        public Double power;

        Laser() {
        }

        @Override
        protected void read() throws IOException {
            super.read();
            this.model = this.getStringValue(0x50000001);
            this.type = this.getStringValue(0x50000001);
            if (this.type == null) {
                this.type = "";
            }
            this.medium = "";
            if (this.type.startsWith("HeNe")) {
                this.medium = "HeNe";
                this.type = "Gas";
            } else if (this.type.startsWith("Argon")) {
                this.medium = "Ar";
                this.type = "Gas";
            } else if (this.type.equals("Titanium:Sapphire") || this.type.equals("Mai Tai")) {
                this.medium = "TiSapphire";
                this.type = "SolidState";
            } else if (this.type.equals("YAG")) {
                this.medium = "";
                this.type = "SolidState";
            } else if (this.type.equals("Ar/Kr")) {
                this.medium = "";
                this.type = "Gas";
            }
            this.acquire = this.getIntValue(0x50000002) != 0;
            this.power = this.getDoubleValue(0x50000003);
        }
    }

    class Recording
    extends SubBlock {
        public String description;
        public String name;
        public String binning;
        public String startTime;
        public String correction;
        public String immersion;
        public Double magnification;
        public Double lensNA;
        public Boolean iris;

        Recording() {
        }

        @Override
        protected void read() throws IOException {
            int next;
            long stamp;
            super.read();
            this.description = this.getStringValue(0x10000002);
            this.name = this.getStringValue(0x10000001);
            this.binning = this.getStringValue(268435538);
            if (this.binning != null && this.binning.indexOf(120) == -1) {
                this.binning = this.binning.equals("0") ? null : this.binning + "x" + this.binning;
            }
            if ((stamp = (long)(this.getDoubleValue(268435510) * 8.64E7)) > 0L) {
                this.startTime = DateTools.convertDate(stamp, 2);
            }
            ZeissLSMReader.this.zoom = this.getDoubleValue(0x10000016);
            String objective = this.getStringValue(0x10000004);
            this.correction = "";
            if (objective == null) {
                objective = "";
            }
            String[] tokens = objective.split(" ");
            for (next = 0; next < tokens.length && tokens[next].indexOf(47) == -1; ++next) {
                this.correction = this.correction + tokens[next];
            }
            if (next < tokens.length) {
                String p;
                int slash;
                if ((slash = (p = tokens[next++]).indexOf(47)) > 0) {
                    try {
                        this.magnification = new Double(p.substring(0, slash - 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (slash >= 0 && slash < p.length() - 1) {
                    try {
                        this.lensNA = new Double(p.substring(slash + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            this.immersion = next < tokens.length ? tokens[next++] : "Unknown";
            this.iris = Boolean.FALSE;
            if (next < tokens.length) {
                this.iris = tokens[next++].trim().equalsIgnoreCase("iris");
            }
        }
    }

    class SubBlock {
        public Map<Integer, Object> blockData;
        public boolean acquire = true;

        public SubBlock() {
            try {
                this.read();
            }
            catch (IOException e) {
                LOGGER.debug("Failed to read sub-block data", e);
            }
        }

        protected int getIntValue(int key) {
            Object o = this.blockData.get(key);
            if (o == null) {
                return -1;
            }
            return !(o instanceof Number) ? -1 : ((Number)o).intValue();
        }

        protected float getFloatValue(int key) {
            Object o = this.blockData.get(key);
            if (o == null) {
                return -1.0f;
            }
            return !(o instanceof Number) ? -1.0f : ((Number)o).floatValue();
        }

        protected double getDoubleValue(int key) {
            Object o = this.blockData.get(key);
            if (o == null) {
                return -1.0;
            }
            return !(o instanceof Number) ? -1.0 : ((Number)o).doubleValue();
        }

        protected String getStringValue(int key) {
            Object o = this.blockData.get(key);
            return o == null ? null : o.toString();
        }

        protected void read() throws IOException {
            this.blockData = new HashMap<Integer, Object>();
            Integer entry = ZeissLSMReader.this.readEntry();
            Object value = ZeissLSMReader.this.readValue();
            while (value != null && ZeissLSMReader.this.in.getFilePointer() < ZeissLSMReader.this.in.length()) {
                if (!this.blockData.containsKey(entry)) {
                    this.blockData.put(entry, value);
                }
                entry = ZeissLSMReader.this.readEntry();
                value = ZeissLSMReader.this.readValue();
            }
        }

        public void addToHashtable() {
            Integer[] keys;
            String prefix = this.getClass().getSimpleName();
            for (Integer key : keys = this.blockData.keySet().toArray(new Integer[this.blockData.size()])) {
                if (METADATA_KEYS.get(key) == null) continue;
                ZeissLSMReader.this.addSeriesMetaList(prefix + " " + (String)METADATA_KEYS.get(key), this.blockData.get(key));
                if (((String)METADATA_KEYS.get(key)).equals("Bits Per Sample")) {
                    ((CoreMetadata)((ZeissLSMReader)ZeissLSMReader.this).core.get((int)ZeissLSMReader.this.getSeries())).bitsPerPixel = Integer.parseInt(this.blockData.get(key).toString());
                    continue;
                }
                if (!((String)METADATA_KEYS.get(key)).equals("User")) continue;
                ZeissLSMReader.this.userName = this.blockData.get(key).toString();
            }
            ZeissLSMReader.this.addGlobalMetaList(prefix + " Acquire", this.acquire);
        }
    }
}

