/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.utils;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.flamingo.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;

public class CommandButtonBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> imageCache = new LazyResettableHashMap("Substance.Flamingo.CommandButtonBackgroundDelegate");

    public static BufferedImage getFullAlphaBackground(AbstractCommandButton commandButton, ButtonModel buttonModel, SubstanceFillPainter fillPainter, SubstanceBorderPainter borderPainter, int width, int height, StateTransitionTracker stateTransitionTracker, boolean ignoreSelections) {
        HashMapKey baseKey;
        BufferedImage baseLayer;
        Map activeStates;
        StateTransitionTracker.ModelStateInfo modelStateInfo;
        StateTransitionTracker.ModelStateInfo modelStateInfo2 = modelStateInfo = stateTransitionTracker == null ? null : stateTransitionTracker.getModelStateInfo();
        Map map = modelStateInfo == null ? null : (activeStates = ignoreSelections ? modelStateInfo.getStateNoSelectionContributionMap() : modelStateInfo.getStateContributionMap());
        ComponentState currState = modelStateInfo == null ? ComponentState.getState((ButtonModel)buttonModel, (JComponent)commandButton) : (ignoreSelections ? modelStateInfo.getCurrModelStateNoSelection() : modelStateInfo.getCurrModelState());
        SubstanceColorScheme baseFillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)commandButton, (ComponentState)currState);
        SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)commandButton, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)currState);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius((int)SubstanceSizeUtils.getComponentFontSize((Component)commandButton));
        Set straightSides = SubstanceCoreUtilities.getSides((JComponent)commandButton, (String)"substancelaf.buttonside");
        AbstractCommandButton.CommandButtonLocationOrderKind locationOrderKind = commandButton.getLocationOrderKind();
        int dx = 0;
        int dy = 0;
        int dw = 0;
        int dh = 0;
        boolean isVertical = false;
        if (locationOrderKind != null && locationOrderKind != AbstractCommandButton.CommandButtonLocationOrderKind.ONLY) {
            Container parent = commandButton.getParent();
            if (parent instanceof JCommandButtonStrip && ((JCommandButtonStrip)parent).getOrientation() == JCommandButtonStrip.StripOrientation.VERTICAL) {
                isVertical = true;
                switch (locationOrderKind) {
                    case FIRST: {
                        dh = commandButton.getHeight() / 2;
                        break;
                    }
                    case MIDDLE: {
                        dy = -commandButton.getHeight() / 2;
                        dh = commandButton.getHeight();
                        break;
                    }
                    case LAST: {
                        dy = -commandButton.getHeight() / 2;
                        dh = commandButton.getHeight() / 2;
                    }
                }
            } else {
                boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
                if (locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.MIDDLE) {
                    dx = -commandButton.getWidth() / 2;
                    dw = commandButton.getWidth();
                } else {
                    boolean curveOnLeft;
                    boolean bl = curveOnLeft = ltr && locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.FIRST || !ltr && locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.LAST;
                    if (curveOnLeft) {
                        dw = commandButton.getWidth() / 2;
                    } else {
                        dx = -commandButton.getWidth() / 2;
                        dw = commandButton.getWidth() / 2;
                    }
                }
            }
        }
        if ((baseLayer = (BufferedImage)imageCache.get(baseKey = SubstanceCoreUtilities.getHashKey((Object[])new Object[]{currState, width, height, baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), commandButton.getClass().getName(), Float.valueOf(radius), straightSides, SubstanceSizeUtils.getComponentFontSize((Component)commandButton), locationOrderKind, dx, dy, dw, dh, isVertical}))) == null) {
            baseLayer = CommandButtonBackgroundDelegate.getSingleLayer(commandButton, fillPainter, borderPainter, width, height, baseFillScheme, baseBorderScheme, radius, straightSides, locationOrderKind, dx, dy, dw, dh, isVertical);
            imageCache.put(baseKey, (Object)baseLayer);
        }
        if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
            return baseLayer;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage((Image)baseLayer, 0, 0, null);
        for (Map.Entry activeEntry : activeStates.entrySet()) {
            float contribution;
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            if (activeState == currState || (contribution = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution()) == 0.0f) continue;
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)commandButton, (ComponentState)activeState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)commandButton, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)activeState);
            HashMapKey key = SubstanceCoreUtilities.getHashKey((Object[])new Object[]{activeState, width, height, fillScheme.getDisplayName(), borderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), commandButton.getClass().getName(), Float.valueOf(radius), straightSides, SubstanceSizeUtils.getComponentFontSize((Component)commandButton), locationOrderKind, dx, dy, dw, dh, isVertical});
            BufferedImage layer = (BufferedImage)imageCache.get(key);
            if (layer == null) {
                layer = CommandButtonBackgroundDelegate.getSingleLayer(commandButton, fillPainter, borderPainter, width, height, fillScheme, borderScheme, radius, straightSides, locationOrderKind, dx, dy, dw, dh, isVertical);
                imageCache.put(key, (Object)layer);
            }
            g2d.setComposite(AlphaComposite.SrcOver.derive(contribution));
            g2d.drawImage((Image)layer, 0, 0, null);
        }
        g2d.dispose();
        return result;
    }

    private static BufferedImage getSingleLayer(AbstractCommandButton commandButton, SubstanceFillPainter fillPainter, SubstanceBorderPainter borderPainter, int width, int height, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme, float radius, Set<SubstanceConstants.Side> straightSides, AbstractCommandButton.CommandButtonLocationOrderKind locationOrderKind, int dx, int dy, int dw, int dh, boolean isVertical) {
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth((int)SubstanceSizeUtils.getComponentFontSize((Component)commandButton)) / 2.0);
        GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline((int)(width + dw), (int)(height + dh), (float)radius, straightSides, (int)borderDelta);
        BufferedImage newBackground = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
        Graphics2D finalGraphics = (Graphics2D)newBackground.getGraphics();
        finalGraphics.translate(dx, dy);
        fillPainter.paintContourBackground((Graphics)finalGraphics, (Component)commandButton, width + dw, height + dh, (Shape)contour, false, fillScheme, true);
        int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth((int)SubstanceSizeUtils.getComponentFontSize((Component)commandButton));
        GeneralPath contourInner = SubstanceOutlineUtilities.getBaseOutline((int)(width + dw), (int)(height + dh), (float)radius, straightSides, (int)(borderDelta + borderThickness));
        borderPainter.paintBorder((Graphics)finalGraphics, (Component)commandButton, width + dw, height + dh, (Shape)contour, (Shape)contourInner, borderScheme);
        if (isVertical) {
            Line2D.Double upper;
            int xe;
            int xs;
            int y;
            if (locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.FIRST || locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.MIDDLE) {
                y = -dy + commandButton.getHeight() - borderDelta - 2 * borderThickness;
                xs = borderDelta;
                xe = commandButton.getWidth() - 2 * borderDelta;
                upper = new Line2D.Double(xs + borderThickness, y, xe - 2 * borderThickness, y);
                Line2D.Double lower = new Line2D.Double(xs, y += borderThickness, xe, y);
                borderPainter.paintBorder((Graphics)finalGraphics, (Component)commandButton, width + dw, height + dh, (Shape)lower, (Shape)upper, borderScheme);
            }
            if (locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.MIDDLE || locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.LAST) {
                y = -dy + borderDelta;
                xs = borderDelta;
                xe = commandButton.getWidth() - 2 * borderDelta;
                upper = new Line2D.Double(xs + borderThickness, y, xe - 2 * borderThickness, y);
                borderPainter.paintBorder((Graphics)finalGraphics, (Component)commandButton, width + dw, height + dh, null, (Shape)upper, borderScheme);
            }
        } else {
            boolean rightmost;
            boolean leftmost;
            boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
            boolean bl = leftmost = ltr && locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.FIRST || !ltr && locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.LAST;
            if (leftmost || locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.MIDDLE) {
                int x = -dx + commandButton.getWidth() - borderDelta - 2 * borderThickness;
                int ys = borderDelta;
                int ye = commandButton.getHeight() - 2 * borderDelta;
                Line2D.Double upper = new Line2D.Double(x, ys + borderThickness, x, ye - 2 * borderThickness);
                Line2D.Double lower = new Line2D.Double(x += borderThickness, ys, x, ye);
                borderPainter.paintBorder((Graphics)finalGraphics, (Component)commandButton, width + dw, height + dh, (Shape)lower, (Shape)upper, borderScheme);
            }
            boolean bl2 = rightmost = ltr && locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.LAST || !ltr && locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.FIRST;
            if (locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.MIDDLE || rightmost) {
                int x = -dx + borderDelta;
                int ys = borderDelta;
                int ye = commandButton.getHeight() - 2 * borderDelta;
                Line2D.Double upper = new Line2D.Double(x, ys + borderThickness, x, ye - 2 * borderThickness);
                borderPainter.paintBorder((Graphics)finalGraphics, (Component)commandButton, width + dw, height + dh, null, (Shape)upper, borderScheme);
            }
        }
        return newBackground;
    }

    public static BufferedImage getCombinedCommandButtonBackground(AbstractCommandButton commandButton, ButtonModel actionModel, Rectangle actionArea, PopupButtonModel popupModel, Rectangle popupArea) {
        DefaultButtonModel backgroundModel = new DefaultButtonModel();
        backgroundModel.setEnabled(actionModel.isEnabled() && popupModel.isEnabled());
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter((Component)commandButton);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter((Component)commandButton);
        BufferedImage fullAlphaBackground = CommandButtonBackgroundDelegate.getFullAlphaBackground(commandButton, backgroundModel, fillPainter, borderPainter, commandButton.getWidth(), commandButton.getHeight(), null, false);
        BufferedImage layers = SubstanceCoreUtilities.getBlankImage((int)fullAlphaBackground.getWidth(), (int)fullAlphaBackground.getHeight());
        Graphics2D combinedGraphics = layers.createGraphics();
        combinedGraphics.drawImage((Image)fullAlphaBackground, 0, 0, null);
        ActionPopupTransitionAwareUI ui = (ActionPopupTransitionAwareUI)commandButton.getUI();
        if (actionModel.isEnabled() && popupModel.isEnabled()) {
            backgroundModel.setRollover(actionModel.isRollover() || popupModel.isRollover() || popupModel.isPopupShowing());
            combinedGraphics.setComposite(AlphaComposite.SrcOver.derive(0.6f));
            BufferedImage rolloverBackground = CommandButtonBackgroundDelegate.getFullAlphaBackground(commandButton, backgroundModel, fillPainter, borderPainter, commandButton.getWidth(), commandButton.getHeight(), ui.getTransitionTracker(), false);
            combinedGraphics.drawImage((Image)rolloverBackground, 0, 0, null);
        }
        if (actionArea != null && !actionArea.isEmpty()) {
            Graphics2D graphicsAction = (Graphics2D)combinedGraphics.create();
            graphicsAction.clip(actionArea);
            float actionAlpha = 0.4f;
            if (popupModel != null && !popupModel.isEnabled()) {
                actionAlpha = 1.0f;
            }
            if (!actionModel.isEnabled()) {
                actionAlpha = 0.0f;
            }
            graphicsAction.setComposite(AlphaComposite.SrcOver.derive(actionAlpha));
            BufferedImage actionAreaBackground = CommandButtonBackgroundDelegate.getFullAlphaBackground(commandButton, null, fillPainter, borderPainter, commandButton.getWidth(), commandButton.getHeight(), ui.getActionTransitionTracker(), false);
            graphicsAction.drawImage((Image)actionAreaBackground, 0, 0, null);
            graphicsAction.dispose();
        }
        if (popupArea != null && !popupArea.isEmpty()) {
            Graphics2D graphicsPopup = (Graphics2D)combinedGraphics.create();
            graphicsPopup.clip(popupArea);
            float popupAlpha = 0.4f;
            if (!actionModel.isEnabled()) {
                popupAlpha = 1.0f;
            }
            if (popupModel != null && !popupModel.isEnabled()) {
                popupAlpha = 0.0f;
            }
            graphicsPopup.setComposite(AlphaComposite.SrcOver.derive(popupAlpha));
            BufferedImage popupAreaBackground = CommandButtonBackgroundDelegate.getFullAlphaBackground(commandButton, null, fillPainter, borderPainter, commandButton.getWidth(), commandButton.getHeight(), ui.getPopupTransitionTracker(), false);
            graphicsPopup.drawImage((Image)popupAreaBackground, 0, 0, null);
            graphicsPopup.dispose();
        }
        combinedGraphics.dispose();
        return layers;
    }

    static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceBackgroundDelegate: \n");
        sb.append("\t" + imageCache.size() + " regular");
        return sb.toString();
    }

    public static void paintThemedCommandButtonIcon(Graphics2D g, Rectangle iconRect, AbstractCommandButton commandButton, Icon regular, ButtonModel model, StateTransitionTracker stateTransitionTracker) {
        Icon themed = SubstanceCoreUtilities.getThemedIcon((Component)commandButton, (Icon)regular);
        boolean useRegularVersion = model.isArmed() || model.isPressed() || model.isSelected() || regular.getClass().isAnnotationPresent(TransitionAware.class);
        Graphics2D g2d = (Graphics2D)g.create();
        if (useRegularVersion) {
            regular.paintIcon((Component)commandButton, g2d, iconRect.x, iconRect.y);
        } else if (stateTransitionTracker != null) {
            float alpha = stateTransitionTracker.getActiveStrength();
            if (alpha < 1.0f) {
                BufferedImage themedImage = FlamingoUtilities.getBlankImage((int)themed.getIconWidth(), (int)themed.getIconHeight());
                themed.paintIcon((Component)commandButton, themedImage.createGraphics(), 0, 0);
                g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)commandButton, (float)(1.0f - alpha), (Graphics)g));
                g2d.drawImage((Image)themedImage, iconRect.x, iconRect.y, null);
            }
            if (alpha > 0.0f) {
                BufferedImage regularImage = FlamingoUtilities.getBlankImage((int)regular.getIconWidth(), (int)regular.getIconHeight());
                regular.paintIcon((Component)commandButton, regularImage.createGraphics(), 0, 0);
                g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)commandButton, (float)alpha, (Graphics)g));
                g2d.drawImage((Image)regularImage, iconRect.x, iconRect.y, null);
            }
        } else if (model.isRollover()) {
            regular.paintIcon((Component)commandButton, g2d, iconRect.x, iconRect.y);
        } else {
            themed.paintIcon((Component)commandButton, g2d, iconRect.x, iconRect.y);
        }
        g2d.dispose();
    }
}

