package plugins.vannary.morphomaths;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Edge {
	private Point3DEdge vertex1;
	private Point3DEdge vertex2;
	private List<Point3DEdge> edge;
	
	public Edge (Point3DEdge v1, Point3DEdge v2, List<Point3DEdge> edge) {
		this.vertex1= v1;
		this.vertex2 = v2;
		this.edge = edge;
	}
	public Point3DEdge getVertex1() {
		return vertex1;
	}
	public Point3DEdge getVertex2() {
		return vertex2;
	}
	public List<Point3DEdge> getEdge() {
		return edge;
	}
	
	// slab volxel: has exactly 2 neighbors
	public void addSlab (Point3DEdge slab) {
		this.edge.add(slab);
	}

	public void setVertex1(Point3DEdge vertex1) {
		this.vertex1 = vertex1;
	}

	public void setVertex2(Point3DEdge vertex2) {
		this.vertex2 = vertex2;
	}
	
	public void removePoint3DFromList (Point3DEdge p){
		edge.remove(p);
	}
	
	public void invertEdge(){
		Point3DEdge v1 = this.vertex2;
		Point3DEdge v2 = this.vertex1;
		vertex1=v1;
		vertex2=v2;
		
		ArrayList<Point3DEdge> newedge=new ArrayList<Point3DEdge>();
		
		
		for(int i=this.edge.size()-1; i>=0;i--) {
				Point3DEdge element = this.edge.get(i);
				newedge.add( element);
			}
		
		edge =newedge;
		
	
	}
	
	public void fuseEdges(Edge e, boolean inv){
		int index=this.edge.size()-1;
		if (inv==false){
			for (Point3DEdge element:e.edge)
				this.edge.add(index++, element);
		}
		else {
			for(int i2=e.edge.size()-1; i2>=0;i2--) {
				Point3DEdge element = e.edge.get(i2);
				this.edge.add(index++, element);
			}
		}
	}
	
	public void AddAllPoint3D (Edge e) {
		
		
		/* this.edge.addAll(e.getEdge());
		Collections.sort(this.edge);
		this.vertex1 = this.edge.get(0);
		this.vertex2 = this.edge.get(this.edge.size()-1); */
		
	}
}