package plugins.danyfel80.image.generator;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Random;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginLibrary;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import vars.geom.VarDimension;
import vars.geom.VarRectangle;

public class TileRandomGenerator extends Plugin implements Block, PluginLibrary {

	private static Random randomGenerator = new Random();

	private VarRectangle baseRectangleVar;
	private VarDimension randomizingIntervalVar;

	@Override
	public void declareInput(VarList inputMap) {
		baseRectangleVar = new VarRectangle("Base rectangle");
		randomizingIntervalVar = new VarDimension("Randomizing interval dimension");

		inputMap.add(baseRectangleVar.getName(), baseRectangleVar);
		inputMap.add(randomizingIntervalVar.getName(), randomizingIntervalVar);
	}

	private VarRectangle transformedRectangleVar;

	@Override
	public void declareOutput(VarList outputMap) {
		transformedRectangleVar = new VarRectangle("Transformed rectangle");
		outputMap.add(transformedRectangleVar.getName(), transformedRectangleVar);
	}

	private Rectangle baseRectangle;
	private Dimension randomizingInterval;

	@Override
	public void run() {
		baseRectangle = baseRectangleVar.getValue(true);
		randomizingInterval = randomizingIntervalVar.getValue(true);

		int randomXTranslation = randomGenerator.nextInt(randomizingInterval.width * 2) - randomizingInterval.width;
		int randomYTranslation = randomGenerator.nextInt(randomizingInterval.height * 2) - randomizingInterval.height;

		Rectangle transformedRectangle = new Rectangle(baseRectangle);
		transformedRectangle.x += randomXTranslation;
		transformedRectangle.y += randomYTranslation;
		transformedRectangleVar.setValue(transformedRectangle);
	}

}
