package plugins.rouviere.zexplorer;

import icy.canvas.Canvas2D;
import icy.canvas.IcyCanvas;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ToolTipFrame;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.type.point.Point5D.Double;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;

import plugins.adufour.projection.Projection;
import plugins.adufour.projection.Projection.ProjectionType;

public class ZExplorerPainter extends Overlay implements SequenceListener
{
    int resizeDimension;
    Point cursor = new Point(0, 0);
    Stroke thinStroke = new BasicStroke(4);
    Stroke largeStroke = new BasicStroke(8);
    Sequence bigFormatSequence;
    List<Integer> resultZ[];
    ToolTipFrame tooltip;
    Sequence mosaicSequence;

    public ZExplorerPainter(int resizeDimension, Sequence bigOriginalSequence, Sequence mosaicSequence)
    {
        super("Z Explorer");
        this.mosaicSequence = mosaicSequence;
        mosaicSequence.addListener(this);
        this.bigFormatSequence = bigOriginalSequence;
        this.resizeDimension = resizeDimension;

        tooltip = new ToolTipFrame("<html><li>Use arrow keys to move in T and Z dimension"
                + "<li>Space: select / unselect Z slice for current T position"
                + "<li>Enter: render sequence selected</html>");

        resultZ = new List[bigOriginalSequence.getSizeT()];
        for (int t = 0; t < bigOriginalSequence.getSizeT(); t++)
            resultZ[t] = new ArrayList<Integer>();
    }

    @Override
    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas)
    {
        final Graphics2D g2 = (Graphics2D) g.create();

        try
        {
            g2.setColor(Color.red);
            g2.setStroke(largeStroke);
            g2.drawRect(cursor.x * resizeDimension, cursor.y * resizeDimension, resizeDimension, resizeDimension);

            for (int t = 0; t < bigFormatSequence.getSizeT(); t++)
            {
                for (Integer zPos : resultZ[t])
                {
                    final int z = zPos.intValue();
                    final Rectangle rect = new Rectangle((t * resizeDimension) + 2, (z * resizeDimension) + 2,
                            resizeDimension - 4, resizeDimension - 4);

                    g2.setColor(Color.darkGray);
                    g2.drawLine((int) rect.getMinX() + 2, (int) rect.getMinY() + 2, (int) rect.getMaxX() + 2,
                            (int) rect.getMaxY() + 2);
                    g2.drawLine((int) rect.getMinX() + 2, (int) rect.getMaxY() + 2, (int) rect.getMaxX() + 2,
                            (int) rect.getMinY() + 2);
                    g2.setColor(Color.white);
                    g2.drawLine((int) rect.getMinX(), (int) rect.getMinY(), (int) rect.getMaxX(), (int) rect.getMaxY());
                    g2.drawLine((int) rect.getMinX(), (int) rect.getMaxY(), (int) rect.getMaxX(), (int) rect.getMinY());
                }
            }
        }
        finally
        {
            g2.dispose();
        }
    }

    @Override
    public void keyPressed(KeyEvent e, Double imagePoint, IcyCanvas canvas)
    {
        switch (e.getKeyCode())
        {
            case KeyEvent.VK_RIGHT:
                cursor.x++;
                if (cursor.x >= bigFormatSequence.getSizeT())
                    cursor.x = bigFormatSequence.getSizeT() - 1;
                break;

            case KeyEvent.VK_LEFT:
                cursor.x--;
                if (cursor.x < 0)
                    cursor.x = 0;
                break;

            case KeyEvent.VK_UP:
                cursor.y--;
                if (cursor.y < 0)
                    cursor.y = 0;
                break;

            case KeyEvent.VK_DOWN:
                cursor.y++;
                if (cursor.y >= bigFormatSequence.getSizeZ())
                    cursor.y = bigFormatSequence.getSizeZ() - 1;
                break;

            case KeyEvent.VK_SPACE:
                final Integer pos = Integer.valueOf(cursor.y);
                if (!resultZ[cursor.x].contains(pos))
                    resultZ[cursor.x].add(pos);
                else
                    resultZ[cursor.x].remove(pos);
                painterChanged();
                break;

            case KeyEvent.VK_ENTER:
                ProjectionType projectionType = null;
                final Sequence outSequence = new Sequence();

                for (int t = 0; t < bigFormatSequence.getSizeT(); t++)
                {
                    if (resultZ[t].size() > 1)
                    {
                        if (projectionType == null)
                        {
                            projectionType = (ProjectionType) JOptionPane.showInputDialog(Icy.getMainInterface()
                                    .getMainFrame(), "Select the projection type:", "Projection type",
                                    JOptionPane.QUESTION_MESSAGE, null, ProjectionType.values(), ProjectionType.MAX);
                        }

                        Sequence tmp = new Sequence();

                        int z = 0;
                        for (Integer zPos : resultZ[t])
                            tmp.setImage(0, z++, bigFormatSequence.getImage(t, zPos.intValue()));

                        Sequence result = Projection.zProjection(tmp, projectionType, true);

                        outSequence.setImage(t, 0, result.getFirstImage());
                    }
                    else if (resultZ[t].size() == 1)
                    {
                        outSequence.setImage(t, 0, IcyBufferedImage.createFrom(bigFormatSequence.getImage(t, resultZ[t]
                                .get(0).intValue())));
                    }
                    else
                    {
                        new AnnounceFrame("Error: no image selected at t=" + t);
                        return;
                    }
                }

                outSequence.setName("Z-explored sequence");
                Icy.getMainInterface().addSequence(outSequence);
                break;
        }

        for (Viewer viewer : bigFormatSequence.getViewers())
        {
            viewer.setPositionT(cursor.x);
            viewer.setPositionZ(cursor.y);
        }

        if (canvas instanceof Canvas2D)
        {
            Canvas2D c2D = (Canvas2D) canvas;
            c2D.centerOnImage(cursor.x * resizeDimension, cursor.y * resizeDimension);
        }
    }

    @Override
    public void sequenceChanged(SequenceEvent sequenceEvent)
    {
        // TODO Auto-generated method stub

    }

    @Override
    public void sequenceClosed(Sequence sequence)
    {
        if (sequence == mosaicSequence)
            tooltip.close();
    }
}
