/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import java.util.concurrent.Future;

public class DenseLargeDComplexMatrix2D
extends WrapperDComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    private double[][] elements;
    private DoubleFFT_2D fft2;
    private DoubleFFT_1D fftRows;
    private DoubleFFT_1D fftColumns;

    public DenseLargeDComplexMatrix2D(int rows, int columns) {
        block2: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new double[rows][2 * columns];
        this.content = this;
    }

    @Override
    public void fft2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexForward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public void fftColumns() {
        int nthreads;
        if (this.fftColumns == null) {
            this.fftColumns = new DoubleFFT_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            double[] column = (double[])DenseLargeDComplexMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeDComplexMatrix2D.this.fftColumns.complexForward(column);
                            DenseLargeDComplexMatrix2D.this.viewColumn(c).assign(column);
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                double[] column = (double[])this.viewColumn(c).copy().elements();
                this.fftColumns.complexForward(column);
                this.viewColumn(c).assign(column);
                ++c;
            }
        }
    }

    @Override
    public void fftRows() {
        int nthreads;
        if (this.fftRows == null) {
            this.fftRows = new DoubleFFT_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            DenseLargeDComplexMatrix2D.this.fftRows.complexForward(DenseLargeDComplexMatrix2D.this.elements[r]);
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                this.fftRows.complexForward(this.elements[r]);
                ++r;
            }
        }
    }

    @Override
    public void ifft2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexInverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public void ifftColumns(final boolean scale) {
        int nthreads;
        if (this.fftColumns == null) {
            this.fftColumns = new DoubleFFT_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            double[] column = (double[])DenseLargeDComplexMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeDComplexMatrix2D.this.fftColumns.complexInverse(column, scale);
                            DenseLargeDComplexMatrix2D.this.viewColumn(c).assign(column);
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                double[] column = (double[])this.viewColumn(c).copy().elements();
                this.fftColumns.complexInverse(column, scale);
                this.viewColumn(c).assign(column);
                ++c;
            }
        }
    }

    @Override
    public void ifftRows(final boolean scale) {
        int nthreads;
        if (this.fftRows == null) {
            this.fftRows = new DoubleFFT_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            DenseLargeDComplexMatrix2D.this.fftRows.complexInverse(DenseLargeDComplexMatrix2D.this.elements[r], scale);
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                this.fftRows.complexInverse(this.elements[r], scale);
                ++r;
            }
        }
    }

    @Override
    public double[] getQuick(int row, int column) {
        return new double[]{this.elements[row][2 * column], this.elements[row][2 * column + 1]};
    }

    @Override
    public void setQuick(int row, int column, double[] value) {
        this.elements[row][2 * column] = value[0];
        this.elements[row][2 * column + 1] = value[1];
    }

    @Override
    public void setQuick(int row, int column, double re, double im) {
        this.elements[row][2 * column] = re;
        this.elements[row][2 * column + 1] = im;
    }

    public double[][] elements() {
        return this.elements;
    }

    @Override
    protected DComplexMatrix2D getContent() {
        return this;
    }

    @Override
    public DComplexMatrix2D like(int rows, int columns) {
        return new DenseLargeDComplexMatrix2D(rows, columns);
    }

    @Override
    public DComplexMatrix1D like1D(int size) {
        return new DenseDComplexMatrix1D(size);
    }
}

