/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLProgram;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.CLSampler;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.util.JNAUtils;
import com.nativelibs4java.util.NIOUtils;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.ptr.ShortByReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;

public class CLKernel
extends CLAbstractEntity<OpenCLLibrary.cl_kernel> {
    protected final CLProgram program;
    protected String name;
    private static CLInfoGetter<OpenCLLibrary.cl_kernel> infos = new CLInfoGetter<OpenCLLibrary.cl_kernel>(){

        @Override
        protected int getInfo(OpenCLLibrary.cl_kernel entity, int infoTypeEnum, NativeSize size, Pointer out, NativeSizeByReference sizeOut) {
            return JavaCL.CL.clGetKernelInfo(entity, infoTypeEnum, size, out, sizeOut);
        }
    };
    private volatile CLInfoGetter<OpenCLLibrary.cl_device_id> kernelInfos;
    private static final NativeSize zeroNS = JNAUtils.toNS(0);
    public static final Object NULL_POINTER_KERNEL_ARGUMENT = new Object(){};
    private static final NativeSize[] oneNL = new NativeSize[]{new NativeSize(1L)};

    protected synchronized CLInfoGetter<OpenCLLibrary.cl_device_id> getKernelInfos() {
        if (this.kernelInfos == null) {
            this.kernelInfos = new CLInfoGetter<OpenCLLibrary.cl_device_id>(){

                @Override
                protected int getInfo(OpenCLLibrary.cl_device_id entity, int infoTypeEnum, NativeSize size, Pointer out, NativeSizeByReference sizeOut) {
                    return JavaCL.CL.clGetKernelWorkGroupInfo((OpenCLLibrary.cl_kernel)CLKernel.this.getEntity(), entity, infoTypeEnum, size, out, sizeOut);
                }
            };
        }
        return this.kernelInfos;
    }

    CLKernel(CLProgram program, String name, OpenCLLibrary.cl_kernel entity) {
        super(entity);
        this.program = program;
        this.name = name;
    }

    public CLProgram getProgram() {
        return this.program;
    }

    public String toString() {
        return this.getFunctionName() + " {args: " + this.getNumArgs() + "}";
    }

    public Map<CLDevice, Long> getPreferredWorkGroupSizeMultiple() {
        try {
            CLDevice[] devices = this.program.getDevices();
            HashMap<CLDevice, Long> ret = new HashMap<CLDevice, Long>(devices.length);
            for (CLDevice device : devices) {
                ret.put(device, this.getKernelInfos().getIntOrLong((OpenCLLibrary.cl_device_id)device.getEntity(), 4531));
            }
            return ret;
        }
        catch (Throwable th) {
            throw new UnsupportedOperationException("Cannot get CL_KERNEL_PREFERRED_WORK_GROUP_SIZE_MULTIPLE (OpenCL 1.1 feature).", th);
        }
    }

    public Map<CLDevice, Long> getWorkGroupSize() {
        CLDevice[] devices = this.program.getDevices();
        HashMap<CLDevice, Long> ret = new HashMap<CLDevice, Long>(devices.length);
        for (CLDevice device : devices) {
            ret.put(device, this.getKernelInfos().getIntOrLong((OpenCLLibrary.cl_device_id)device.getEntity(), 4528));
        }
        return ret;
    }

    public Map<CLDevice, long[]> getCompileWorkGroupSize() {
        CLDevice[] devices = this.program.getDevices();
        HashMap<CLDevice, long[]> ret = new HashMap<CLDevice, long[]>(devices.length);
        for (CLDevice device : devices) {
            ret.put(device, this.getKernelInfos().getNativeSizes((OpenCLLibrary.cl_device_id)device.getEntity(), 4529, 3));
        }
        return ret;
    }

    public Map<CLDevice, Long> getLocalMemSize() {
        CLDevice[] devices = this.program.getDevices();
        HashMap<CLDevice, Long> ret = new HashMap<CLDevice, Long>(devices.length);
        for (CLDevice device : devices) {
            ret.put(device, this.getKernelInfos().getIntOrLong((OpenCLLibrary.cl_device_id)device.getEntity(), 4530));
        }
        return ret;
    }

    public void setArgs(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            this.setObjectArg(i, args[i]);
        }
    }

    public void setObjectArg(int iArg, Object arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Null arguments are not accepted. Please use CLKernel.NULL_POINTER_KERNEL_ARGUMENT instead.");
        }
        if (arg == NULL_POINTER_KERNEL_ARGUMENT) {
            this.setArg(iArg, zeroNS);
        } else if (arg instanceof NativeSize) {
            this.setArg(iArg, (NativeSize)arg);
        } else if (arg instanceof CLMem) {
            this.setArg(iArg, (CLMem)arg);
        } else if (arg instanceof CLEvent) {
            this.setArg(iArg, (CLEvent)arg);
        } else if (arg instanceof CLSampler) {
            this.setArg(iArg, (CLSampler)arg);
        } else if (arg instanceof Integer) {
            this.setArg(iArg, (Integer)arg);
        } else if (arg instanceof LocalSize) {
            this.setArg(iArg, (LocalSize)arg);
        } else if (arg instanceof Long) {
            this.setArg(iArg, (Long)arg);
        } else if (arg instanceof Short) {
            this.setArg(iArg, (Short)arg);
        } else if (arg instanceof Byte) {
            this.setArg(iArg, (Byte)arg);
        } else if (arg instanceof Float) {
            this.setArg(iArg, ((Float)arg).floatValue());
        } else if (arg instanceof Double) {
            this.setArg(iArg, (Double)arg);
        } else if (arg instanceof Boolean) {
            this.setArg(iArg, (byte)(Boolean.TRUE.equals(arg) ? 1 : 0));
        } else if (arg instanceof Buffer) {
            this.setArg(iArg, (Buffer)arg);
        } else if (arg instanceof int[]) {
            this.setArg(iArg, IntBuffer.wrap((int[])arg));
        } else if (arg instanceof long[]) {
            this.setArg(iArg, LongBuffer.wrap((long[])arg));
        } else if (arg instanceof short[]) {
            this.setArg(iArg, ShortBuffer.wrap((short[])arg));
        } else if (arg instanceof double[]) {
            this.setArg(iArg, DoubleBuffer.wrap((double[])arg));
        } else if (arg instanceof float[]) {
            this.setArg(iArg, FloatBuffer.wrap((float[])arg));
        } else if (arg instanceof byte[]) {
            this.setArg(iArg, ByteBuffer.wrap((byte[])arg));
        } else if (arg instanceof boolean[]) {
            boolean[] bools = (boolean[])arg;
            byte[] bytes = new byte[bools.length];
            int n = bools.length;
            for (int iValue = 0; iValue < n; ++iValue) {
                bytes[iValue] = (byte)(bools[iValue] ? 1 : 0);
            }
            this.setArg(iArg, ByteBuffer.wrap(bytes));
        } else {
            throw new IllegalArgumentException("Cannot handle kernel arguments of type " + arg.getClass().getName() + ". Use CLKernel.get() and OpenCL4Java directly.");
        }
    }

    public void setArg(int i, LocalSize arg) {
        this.setLocalArg(i, arg.size);
    }

    public void setLocalArg(int argIndex, long localArgByteLength) {
        this.setKernelArg(argIndex, JNAUtils.toNS(localArgByteLength), null);
    }

    public void setArg(int i, float[] arg) {
        this.setArg(i, FloatBuffer.wrap(arg));
    }

    public void setArg(int i, int[] arg) {
        this.setArg(i, IntBuffer.wrap(arg));
    }

    public void setArg(int i, double[] arg) {
        this.setArg(i, DoubleBuffer.wrap(arg));
    }

    public void setArg(int i, long[] arg) {
        this.setArg(i, LongBuffer.wrap(arg));
    }

    public void setArg(int i, short[] arg) {
        this.setArg(i, ShortBuffer.wrap(arg));
    }

    public void setArg(int i, byte[] arg) {
        this.setArg(i, ByteBuffer.wrap(arg));
    }

    public void setArg(int i, char[] arg) {
        this.setArg(i, CharBuffer.wrap(arg));
    }

    public void setArg(int i, Buffer arg) {
        if (!arg.isDirect()) {
            arg = NIOUtils.directCopy(arg, this.getProgram().getContext().getByteOrder());
        }
        long size = NIOUtils.getSizeInBytes(arg);
        this.setKernelArg(i, JNAUtils.toNS(size), Native.getDirectBufferPointer(arg));
    }

    protected void setKernelArg(int i, NativeSize size, Pointer ptr) {
        try {
            CLException.error(JavaCL.CL.clSetKernelArg((OpenCLLibrary.cl_kernel)this.getEntity(), i, size, ptr));
        }
        catch (CLException.CLTypedException ex) {
            ex.setKernelArg(this, i);
            throw ex;
        }
    }

    public void setArg(int i, NativeSize arg) {
        switch (this.getProgram().getContext().getAddressBits()) {
            case 32: {
                this.setKernelArg(i, JNAUtils.toNS(4), new IntByReference(arg.intValue()).getPointer());
                break;
            }
            case 64: {
                this.setKernelArg(i, JNAUtils.toNS(8), new LongByReference(arg.longValue()).getPointer());
                break;
            }
            default: {
                this.setKernelArg(i, JNAUtils.toNS(NativeSize.SIZE), new NativeSizeByReference(arg).getPointer());
            }
        }
    }

    public void setArg(int i, int arg) {
        this.setKernelArg(i, JNAUtils.toNS(4), new IntByReference(arg).getPointer());
    }

    public void setArg(int i, long arg) {
        this.setKernelArg(i, JNAUtils.toNS(8), new LongByReference(arg).getPointer());
    }

    public void setArg(int i, short arg) {
        this.setKernelArg(i, JNAUtils.toNS(2), new ShortByReference(arg).getPointer());
    }

    public void setArg(int i, byte arg) {
        this.setKernelArg(i, JNAUtils.toNS(1), new ByteByReference(arg).getPointer());
    }

    public void setArg(int i, float arg) {
        this.setKernelArg(i, JNAUtils.toNS(4), new FloatByReference(arg).getPointer());
    }

    public void setArg(int i, double arg) {
        this.setKernelArg(i, JNAUtils.toNS(8), new DoubleByReference(arg).getPointer());
    }

    public void setArg(int index, CLMem mem) {
        this.setKernelArg(index, JNAUtils.toNS(Pointer.SIZE), new PointerByReference(((OpenCLLibrary.cl_mem)mem.getEntity()).getPointer()).getPointer());
    }

    public void setArg(int index, CLEvent event) {
        this.setKernelArg(index, JNAUtils.toNS(Pointer.SIZE), new PointerByReference(((OpenCLLibrary.cl_event)event.getEntity()).getPointer()).getPointer());
    }

    public void setArg(int index, CLSampler sampler) {
        this.setKernelArg(index, JNAUtils.toNS(Pointer.SIZE), new PointerByReference(((OpenCLLibrary.cl_sampler)sampler.getEntity()).getPointer()).getPointer());
    }

    @Override
    protected void clear() {
        CLException.error(JavaCL.CL.clReleaseKernel((OpenCLLibrary.cl_kernel)this.getEntity()));
    }

    public CLEvent enqueueTask(CLQueue queue, CLEvent ... eventsToWaitFor) {
        OpenCLLibrary.cl_event[] eventOut = CLEvent.new_event_out(eventsToWaitFor);
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(JavaCL.CL.clEnqueueNDRangeKernel((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_kernel)this.getEntity(), 1, null, oneNL, oneNL, evts == null ? 0 : evts.length, evts, eventOut));
        return CLEvent.createEvent(queue, eventOut);
    }

    public CLEvent enqueueNDRange(CLQueue queue, int[] globalWorkSizes, int[] localWorkSizes, CLEvent ... eventsToWaitFor) {
        return this.enqueueNDRange(queue, null, globalWorkSizes, localWorkSizes, eventsToWaitFor);
    }

    public CLEvent enqueueNDRange(CLQueue queue, int[] globalWorkSizes, CLEvent ... eventsToWaitFor) {
        return this.enqueueNDRange(queue, (int[])null, globalWorkSizes, (int[])null, eventsToWaitFor);
    }

    public CLEvent enqueueNDRange(CLQueue queue, int[] globalOffsets, int[] globalWorkSizes, int[] localWorkSizes, CLEvent ... eventsToWaitFor) {
        int nDims = globalWorkSizes.length;
        if (localWorkSizes != null && localWorkSizes.length != nDims) {
            throw new IllegalArgumentException("Global and local sizes must have same dimensions, given " + globalWorkSizes.length + " vs. " + localWorkSizes.length);
        }
        OpenCLLibrary.cl_event[] eventOut = CLEvent.new_event_out(eventsToWaitFor);
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(JavaCL.CL.clEnqueueNDRangeKernel((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_kernel)this.getEntity(), nDims, JNAUtils.toNS(globalOffsets), JNAUtils.toNS(globalWorkSizes), JNAUtils.toNS(localWorkSizes), evts == null ? 0 : evts.length, evts, eventOut));
        return CLEvent.createEvent(queue, eventOut);
    }

    @InfoName(value="CL_KERNEL_NUM_ARGS")
    public int getNumArgs() {
        return infos.getInt((OpenCLLibrary.cl_kernel)this.getEntity(), 4497);
    }

    @InfoName(value="CL_KERNEL_FUNCTION_NAME")
    public String getFunctionName() {
        if (this.name == null) {
            this.name = infos.getString((OpenCLLibrary.cl_kernel)this.getEntity(), 4496);
        }
        return this.name;
    }

    public static class LocalSize {
        long size;

        public LocalSize(long size) {
            this.size = size;
        }
    }
}

