/*
 * Decompiled with CFR 0.152.
 */
package plugins.ferreol.demics;

import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.util.OMEUtil;
import loci.formats.ome.OMEXMLMetadataImpl;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.cost.WeightedData;
import mitiv.utils.FFTUtils;
import mitiv.utils.WeightFactory;
import ome.xml.meta.OMEXMLMetadata;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarChannel;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarDoubleArrayNative;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.mitiv.io.Icy2TiPi;

public abstract class DEMICSPlug
extends EzPlug
implements Block {
    protected EzVarSequence data;
    protected EzVarChannel channel;
    protected EzVarDouble logmu;
    protected EzVarDouble mu;
    protected EzVarSequence restart;
    protected EzVarChannel channelRestart;
    protected EzVarBoolean positivity;
    protected EzButton startDec;
    protected EzButton showFullObject;
    protected EzVarText dataSize;
    protected EzVarText outputSize;
    protected EzVarDouble dxy_nm;
    protected EzVarDouble dz_nm;
    protected EzVarDouble na;
    protected EzVarDouble lambda;
    protected EzVarDouble ni;
    protected EzVarInteger nbIterDeconv;
    protected EzVarBoolean singlePrecision;
    protected EzVarDoubleArrayNative scale;
    protected EzVarInteger paddingSizeXY;
    protected EzVarInteger paddingSizeZ;
    protected int sizeX = 128;
    protected int sizeY = 128;
    protected int sizeZ = 64;
    protected int Nx = 128;
    protected int Ny = 128;
    protected int Nz = 64;
    protected Shape psfShape = new Shape(this.Nx, this.Ny, this.Nz);
    protected Shape outputShape;
    protected Sequence dataSeq;
    protected Sequence cursequence;
    protected Shape dataShape;
    protected ShapedArray wgtArray;
    protected ShapedArray dataArray;
    protected ShapedArray psfArray;
    protected ShapedArray objArray;
    protected EzVarText weightsMethod;
    protected final String[] weightOptions = new String[]{"None", "Inverse covariance map", "Variance map", "Computed variance"};
    protected EzVarDouble gain;
    protected EzVarDouble noise;
    protected EzVarSequence weights;
    protected EzVarSequence deadPixel;
    protected EzButton showWeight;
    protected EzVarFile saveFile;
    protected EzVarFile loadFile;
    protected EzVarBoolean showIteration;
    protected EzVarSequence outputHeadlessImage = null;
    protected EzVarSequence outputHeadlessWght = null;
    protected String outputPath = null;
    private boolean debug = false;
    private boolean verbose = false;

    protected ShapedArray createWeights(ShapedArray datArray, ShapedArray badArray) {
        ShapedArray wgtArray = null;
        WeightedData wd = new WeightedData(datArray);
        if (this.weightsMethod.getValue() == this.weightOptions[1]) {
            Sequence seq = (Sequence)this.weights.getValue();
            if (seq != null) {
                wgtArray = Icy2TiPi.sequenceToArray(seq);
                wd.setWeights(wgtArray);
            }
        } else if (this.weightsMethod.getValue() == this.weightOptions[2]) {
            Sequence seq = (Sequence)this.weights.getValue();
            if (seq != null) {
                ShapedArray varArray = Icy2TiPi.sequenceToArray(seq);
                wgtArray = WeightFactory.computeWeightsFromVariance((ShapedArray)varArray);
                wd.setWeights(wgtArray);
            }
        } else if (this.weightsMethod.getValue() == this.weightOptions[3]) {
            double gamma = (Double)this.gain.getValue();
            double sigma = (Double)this.noise.getValue();
            double alpha = 1.0 / gamma;
            double beta = sigma / gamma * (sigma / gamma);
            wd.computeWeightsFromData(alpha, beta);
        }
        if (badArray != null) {
            wd.markBadData(badArray);
        }
        return wd.getWeights().asShapedArray();
    }

    protected void dataChanged() {
        this.dataSeq = (Sequence)this.data.getValue();
        if (this.dataSeq != null) {
            this.sizeX = this.dataSeq.getSizeX();
            this.sizeY = this.dataSeq.getSizeY();
            this.sizeZ = this.dataSeq.getSizeZ();
            if (this.sizeZ == 1) {
                this.throwError("Input data must be 3D");
                return;
            }
            this.restart.setValue(this.dataSeq);
            this.updatePaddedSize();
            this.updateOutputSize();
            this.updateImageSize();
            this.dataShape = new Shape(this.sizeX, this.sizeY, this.sizeZ);
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("image", (Var)this.data.getVariable());
        inputMap.add("image channel", this.channel.getVariable());
        inputMap.add("starting point", (Var)this.restart.getVariable());
        this.channelRestart = new EzVarChannel("Initialization channel :", (Var)this.restart.getVariable(), false);
        inputMap.add("starting point channel", this.channelRestart.getVariable());
        inputMap.add("weights Method", this.weightsMethod.getVariable());
        inputMap.add("deadPixel", (Var)this.deadPixel.getVariable());
        inputMap.add("gain", this.gain.getVariable());
        inputMap.add("noise", this.noise.getVariable());
        inputMap.add("mu", this.mu.getVariable());
        inputMap.add("scale", this.scale.getVariable());
        inputMap.add("nbIteration", this.nbIterDeconv.getVariable());
        inputMap.add("positivity", this.positivity.getVariable());
        inputMap.add("single precision", this.singlePrecision.getVariable());
        this.saveFile = new EzVarFile("Save parameters in", "");
        inputMap.add("saveFile", this.saveFile.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("outputSize", this.outputSize.getVariable());
        outputMap.add("output", (Var)this.outputHeadlessImage.getVariable());
        outputMap.add("weightmap", (Var)this.outputHeadlessWght.getVariable());
    }

    protected void setDefaultValue() {
        this.weightsMethod.setValue((Object)this.weightOptions[3]);
        this.data.setNoSequenceSelection();
        this.deadPixel.setNoSequenceSelection();
        this.paddingSizeZ.setValue((Object)30);
        this.deadPixel.setNoSequenceSelection();
        if (!this.isHeadLess()) {
            this.outputSize.setEnabled(false);
            this.dataSize.setEnabled(false);
            this.mu.setEnabled(false);
        }
    }

    protected void updateImageSize() {
        String text = this.Nz == 1 ? this.sizeX + "x" + this.sizeY : this.sizeX + "x" + this.sizeY + "x" + this.sizeZ;
        this.dataSize.setValue((Object)text);
    }

    protected void updateMetaData() {
        Sequence seq = (Sequence)this.data.getValue();
        if (seq != null) {
            OMEXMLMetadata newMetdat = MetaDataUtil.generateMetaData((Sequence)seq, (boolean)false);
            newMetdat.setPixelsPhysicalSizeX(OMEUtil.getLength((double)((Double)this.dxy_nm.getValue() * 0.001)), 0);
            newMetdat.setPixelsPhysicalSizeY(OMEUtil.getLength((double)((Double)this.dxy_nm.getValue() * 0.001)), 0);
            newMetdat.setPixelsPhysicalSizeZ(OMEUtil.getLength((double)((Double)this.dz_nm.getValue() * 0.001)), 0);
            seq.setMetaData((OMEXMLMetadataImpl)newMetdat);
        } else {
            new AnnounceFrame("Nothing to save");
        }
    }

    protected void updateOutputSize() {
        String text = this.Nx + "x" + this.Ny + "x" + this.Nz;
        this.outputSize.setValue((Object)text);
        if (1.0 * (double)this.Nx * (double)this.Ny * (double)this.Nz > Math.pow(2.0, 30.0)) {
            this.throwError("Padded image is too large (>2^30)");
        }
    }

    protected void updatePaddedSize() {
        if ((double)((Integer)this.paddingSizeXY.getValue()).intValue() < 0.0) {
            this.throwError("Padding value cannot be negative");
            return;
        }
        if ((double)((Integer)this.paddingSizeZ.getValue()).intValue() < 0.0) {
            this.throwError("Padding value cannot be negative");
            return;
        }
        this.Nx = FFTUtils.bestDimension((int)(this.sizeX + (Integer)this.paddingSizeXY.getValue()));
        this.Ny = FFTUtils.bestDimension((int)(this.sizeY + (Integer)this.paddingSizeXY.getValue()));
        this.Nz = FFTUtils.bestDimension((int)(this.sizeZ + (Integer)this.paddingSizeZ.getValue()));
        this.outputShape = new Shape(this.Nx, this.Ny, this.Nz);
        if (this.debug) {
            System.out.println(" UpdatePaddedSize" + this.paddingSizeXY.getValue() + this.outputShape.toString());
        }
    }

    protected void throwError(String s) {
        if (this.isHeadLess()) {
            throw new IllegalArgumentException(s);
        }
        new FailedAnnounceFrame(s);
    }
}

