/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import org.ejml.data.Matrix64F;

public class MatrixIO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveXML(Matrix64F matrix64F, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        try {
            objectOutputStream.writeObject(matrix64F);
            objectOutputStream.flush();
        }
        finally {
            try {
                objectOutputStream.close();
            }
            finally {
                fileOutputStream.close();
            }
        }
    }

    public static <T extends Matrix64F> T loadXML(String string) throws IOException {
        Matrix64F matrix64F;
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        try {
            matrix64F = (Matrix64F)objectInputStream.readObject();
            if (objectInputStream.available() != 0) {
                throw new RuntimeException("File not completely read?");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        objectInputStream.close();
        return (T)matrix64F;
    }

    public static void print(PrintStream printStream, Matrix64F matrix64F) {
        MatrixIO.print(printStream, matrix64F, 6, 3);
    }

    public static void print(PrintStream printStream, Matrix64F matrix64F, int n, int n2) {
        String string = "%" + n + "." + n2 + "f ";
        MatrixIO.print(printStream, matrix64F, string);
    }

    public static void print(PrintStream printStream, Matrix64F matrix64F, String string) {
        printStream.println("Type = dense , numRows = " + matrix64F.numRows + " , numCols = " + matrix64F.numCols);
        string = string + " ";
        for (int i = 0; i < matrix64F.numRows; ++i) {
            for (int j = 0; j < matrix64F.numCols; ++j) {
                printStream.printf(string, matrix64F.get(i, j));
            }
            printStream.println();
        }
    }

    public static void print(PrintStream printStream, Matrix64F matrix64F, String string, int n, int n2, int n3, int n4) {
        printStream.println("Type = submatrix , rows " + n + " to " + n2 + "  columns " + n3 + " to " + n4);
        string = string + " ";
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                printStream.printf(string, matrix64F.get(i, j));
            }
            printStream.println();
        }
    }
}

