/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.plugin.frame.Recorder;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;

public class PlotDialog {
    public static final int SET_RANGE = 0;
    public static final int AXIS_OPTIONS = 1;
    public static final int LEGEND = 2;
    public static final int HI_RESOLUTION = 3;
    private static final String[] HEADINGS = new String[]{"Plot Range...", "Axis Options...", "Add Legend...", "High-Resolution Plot..."};
    private static final String[] LEGEND_POSITIONS = new String[]{"Auto", "Top-Left", "Top-Right", "Bottom-Left", "Bottom-Right", "No Legend"};
    private static final int[] LEGEND_POSITION_N = new int[]{128, 144, 160, 176, 192, 0};
    private Plot plot;
    private int dialogType;
    private static int legendPosNumber = 0;
    private static boolean bottomUp;
    private static boolean transparentBackground;
    private static String xLabel;
    private static String yLabel;
    private static float plotFontSize;
    private static boolean axisLabelBold;
    private static float hiResFactor;
    private static boolean hiResAntiAliased;

    public PlotDialog(Plot plot, int dialogType) {
        this.plot = plot;
        this.dialogType = dialogType;
    }

    public void showDialog(Frame parent) {
        GenericDialog gd;
        GenericDialog genericDialog = gd = parent == null ? new GenericDialog(HEADINGS[this.dialogType]) : new GenericDialog(HEADINGS[this.dialogType]);
        if (this.dialogType == 0) {
            double[] currentMinMax = this.plot.currentMinMax;
            boolean livePlot = this.plot.plotMaker != null;
            int xDigits = this.plot.logXAxis ? -2 : Plot.getDigits(currentMinMax[0], currentMinMax[1], 0.005 * Math.abs(currentMinMax[1] - currentMinMax[0]), 6);
            int yDigits = this.plot.logYAxis ? -2 : Plot.getDigits(currentMinMax[2], currentMinMax[3], 0.005 * Math.abs(currentMinMax[3] - currentMinMax[2]), 6);
            gd.addNumericField("X_From*", currentMinMax[0], xDigits);
            gd.addNumericField("X_To*", currentMinMax[1], xDigits);
            gd.setInsets(0, 20, 0);
            if (livePlot) {
                gd.addCheckbox("Fix_X Range While Live", (this.plot.templateFlags & 1) != 0);
            }
            gd.addCheckbox("Log_X Axis", this.plot.hasFlag(1024));
            gd.setInsets(20, 0, 3);
            gd.addNumericField("Y_From*", currentMinMax[2], yDigits);
            gd.addNumericField("Y_To*", currentMinMax[3], yDigits);
            if (livePlot) {
                gd.addCheckbox("Fix_Y Range While Live", (this.plot.templateFlags & 2) != 0);
            }
            gd.addCheckbox("Log_Y Axis", this.plot.hasFlag(2048));
            gd.addMessage("*Leave empty for automatic range", new Font("SansSerif", 0, 12));
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            this.plot.saveMinMax();
            double linXMin = gd.getNextNumber();
            if (gd.invalidNumber()) {
                linXMin = Double.NaN;
            }
            double linXMax = gd.getNextNumber();
            if (gd.invalidNumber()) {
                linXMax = Double.NaN;
            }
            double linYMin = gd.getNextNumber();
            if (gd.invalidNumber()) {
                linYMin = Double.NaN;
            }
            double linYMax = gd.getNextNumber();
            if (gd.invalidNumber()) {
                linYMax = Double.NaN;
            }
            currentMinMax[0] = linXMin;
            currentMinMax[1] = linXMax;
            currentMinMax[2] = linYMin;
            currentMinMax[3] = linYMax;
            if (livePlot) {
                this.plot.templateFlags = this.setFlag(this.plot.templateFlags, 1, gd.getNextBoolean());
            }
            boolean xLog = gd.getNextBoolean();
            if (livePlot) {
                this.plot.templateFlags = this.setFlag(this.plot.templateFlags, 2, gd.getNextBoolean());
            }
            boolean yLog = gd.getNextBoolean();
            this.plot.setAxisXLog(xLog);
            this.plot.setAxisYLog(yLog);
            this.plot.setLimits(linXMin, linXMax, linYMin, linYMax);
            this.plot.updateImage();
            if (Recorder.record) {
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("//plot = IJ.getImage().getProperty(Plot.PROPERTY_KEY)");
                    Recorder.recordCall("plot.setAxisXLog(" + xLog + ");");
                    Recorder.recordCall("plot.setAxisYLog(" + yLog + ");");
                    Recorder.recordCall("plot.setLimits(" + IJ.d2s(linXMin, xDigits) + "," + IJ.d2s(linXMax, xDigits) + "," + IJ.d2s(linYMin, yDigits) + "," + IJ.d2s(linYMax, yDigits) + ");");
                } else {
                    Recorder.recordString("Plot.setLogScaleX(" + xLog + ");\n");
                    Recorder.recordString("Plot.setLogScaleY(" + yLog + ");\n");
                    Recorder.recordString("Plot.setLimits(" + IJ.d2s(linXMin, xDigits) + "," + IJ.d2s(linXMax, xDigits) + "," + IJ.d2s(linYMin, yDigits) + "," + IJ.d2s(linYMax, yDigits) + ");\n");
                }
            }
        } else if (this.dialogType == 1) {
            Font numberFont;
            int flags = this.plot.getFlags();
            int columns = 2;
            String[] labels = new String[]{"Draw Grid", "Major Ticks", "Minor Ticks", "Ticks if Logarithmic", "Numbers"};
            int[] xFlags = new int[]{16, 4, 256, 4096, 1};
            Panel panel = new Panel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 10;
            c.gridy = 0;
            c.gridx = 1;
            panel.add((Component)new Label("X Axis"), c);
            c.gridx = 2;
            panel.add((Component)new Label("Y Axis"), c);
            Checkbox[] checkboxes = new Checkbox[labels.length * columns];
            for (int l = 0; l < labels.length; ++l) {
                ++c.gridy;
                c.gridx = 0;
                c.anchor = 13;
                panel.add((Component)new Label(labels[l]), c);
                c.anchor = 10;
                c.gridx = -1;
                checkboxes[l * columns] = new Checkbox(null, this.getFlag(flags, xFlags[l]));
                panel.add((Component)checkboxes[l * columns], c);
                checkboxes[l * columns + 1] = new Checkbox(null, this.getFlag(flags, xFlags[l] << 1));
                panel.add((Component)checkboxes[l * columns + 1], c);
            }
            gd.addPanel(panel);
            gd.setInsets(15, 0, 3);
            Font plotFont = this.plot.currentFont != null ? this.plot.currentFont : this.plot.defaultFont;
            Font labelFont = this.plot.getFont('x');
            if (labelFont == null) {
                labelFont = plotFont;
            }
            if ((numberFont = this.plot.getFont('f')) == null) {
                numberFont = plotFont;
            }
            String plotXLabel = this.plot.getLabel('x');
            String plotYLabel = this.plot.getLabel('y');
            if (plotXLabel == null) {
                plotXLabel = "";
            }
            if (plotYLabel == null) {
                plotYLabel = "";
            }
            if (xLabel == null || !plotXLabel.equals("Distance (pixels)") && !plotXLabel.equals("Distance ( )")) {
                xLabel = plotXLabel;
            }
            if (yLabel == null || !plotYLabel.equals("Gray Value")) {
                yLabel = plotYLabel;
            }
            gd.addNumericField("Number Font Size", numberFont.getSize2D(), 1);
            gd.addNumericField("Label Font Size", labelFont.getSize2D(), 1);
            gd.addStringField("X Axis Label", xLabel, 15);
            gd.addStringField("Y Axis Label", yLabel, 15);
            gd.setInsets(0, 20, 0);
            gd.addCheckbox("Bold Labels", plotFontSize > 0.0f ? axisLabelBold : labelFont.isBold());
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            flags = 0;
            for (int l = 0; l < labels.length; ++l) {
                flags = this.setFlag(flags, xFlags[l], checkboxes[l * columns].getState());
                flags = this.setFlag(flags, xFlags[l] << 1, checkboxes[l * columns + 1].getState());
            }
            this.plot.setFormatFlags(flags);
            float numberFontSize = (float)gd.getNextNumber();
            if (gd.invalidNumber()) {
                numberFontSize = numberFont.getSize2D();
            }
            if (numberFontSize < 9.0f) {
                numberFontSize = 9.0f;
            }
            if (numberFontSize > 24.0f) {
                numberFontSize = 24.0f;
            }
            float labelFontSize = (float)gd.getNextNumber();
            if (gd.invalidNumber()) {
                labelFontSize = labelFont.getSize2D();
            }
            xLabel = gd.getNextString();
            yLabel = gd.getNextString();
            axisLabelBold = gd.getNextBoolean();
            this.plot.setFont('f', numberFont.deriveFont(numberFont.getStyle(), numberFontSize));
            this.plot.setAxisLabelFont(axisLabelBold ? 1 : 0, labelFontSize);
            this.plot.setXYLabels(xLabel, yLabel);
            this.plot.updateImage();
            if (Recorder.record) {
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("//plot = IJ.getImage().getProperty(Plot.PROPERTY_KEY)");
                    Recorder.recordCall("plot.setFont(-1," + IJ.d2s(plotFontSize, 1) + ");");
                    Recorder.recordCall("plot.setAxisLabelFont(Plot." + (axisLabelBold ? "BOLD" : "PLAIN") + "," + IJ.d2s(labelFontSize, 1) + ");");
                    Recorder.recordCall("plot.setXYLabels(\"" + xLabel + "\", \"" + yLabel + "\");");
                    Recorder.recordCall("plot.setFormatFlags(0x" + Integer.toHexString(flags) + ");");
                } else {
                    Recorder.recordString("Plot.setFontSize(" + IJ.d2s(plotFontSize, 1) + ");\n");
                    Recorder.recordString("Plot.setAxisLabelSize(" + IJ.d2s(labelFontSize, 1) + ", \"" + (axisLabelBold ? "bold" : "plain") + "\");\n");
                    Recorder.recordString("Plot.setXYLabels(\"" + xLabel + "\", \"" + yLabel + "\");\n");
                    Recorder.recordString("Plot.setFormatFlags(\"" + Integer.toString(flags, 2) + "\");\n");
                }
            }
        } else if (this.dialogType == 2) {
            gd.addMessage("Enter Labels for the datasets, one per line.\n");
            String labels = this.plot.getDataLabels();
            int nLines = labels.split("\n", -1).length;
            gd.addTextAreas(labels, null, Math.min(nLines + 1, 20), 40);
            gd.addChoice("Legend position", LEGEND_POSITIONS, LEGEND_POSITIONS[legendPosNumber]);
            gd.addCheckbox("Transparent background", transparentBackground);
            gd.addCheckbox("Bottom-to-top", bottomUp);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            labels = gd.getNextText();
            legendPosNumber = gd.getNextChoiceIndex();
            int flags = LEGEND_POSITION_N[legendPosNumber];
            transparentBackground = gd.getNextBoolean();
            bottomUp = gd.getNextBoolean();
            if (bottomUp) {
                flags |= 0x100;
            }
            if (transparentBackground) {
                flags |= 0x200;
            }
            this.plot.setColor(Color.black);
            this.plot.setLineWidth(1);
            this.plot.setLegend(labels, flags);
            this.plot.updateImage();
            if (Recorder.record) {
                String options = LEGEND_POSITIONS[legendPosNumber];
                if (bottomUp) {
                    options = options + " Bottom-To-Top";
                }
                if (transparentBackground) {
                    options = options + " Transparent";
                }
                labels = labels.replaceAll("\n", "\\\\n");
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("//plot = IJ.getImage().getProperty(Plot.PROPERTY_KEY);");
                    Recorder.recordCall("plot.setColor(Color.black);");
                    Recorder.recordCall("plot.setLineWidth(1);");
                    Recorder.recordCall("plot.addLegend(\"" + labels + "\", \"" + options + "\");");
                } else {
                    Recorder.recordString("Plot.addLegend(\"" + labels + "\", \"" + options + "\");\n");
                }
            }
        } else if (this.dialogType == 3) {
            String title = this.plot.getTitle() + "_HiRes";
            title = WindowManager.makeUniqueName(title);
            gd.addStringField("Title: ", title, 20);
            gd.addNumericField("Scale factor", hiResFactor, 1);
            gd.addCheckbox("Disable anti-aliased text", !hiResAntiAliased);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            title = gd.getNextString();
            double scale = gd.getNextNumber();
            if (!gd.invalidNumber() && scale > 0.0) {
                hiResFactor = (float)scale;
            }
            hiResAntiAliased = !gd.getNextBoolean();
            final ImagePlus hiresImp = this.plot.makeHighResolution(title, hiResFactor, hiResAntiAliased, true);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IJ.selectWindow(hiresImp.getID());
                }
            });
            if (Recorder.record) {
                String options;
                String string = options = !hiResAntiAliased ? "disable" : "";
                if (options.length() > 0) {
                    options = ",\"" + options + "\"";
                }
                Recorder.recordString("Plot.makeHighResolution(\"" + title + "\"," + hiResFactor + options + ");\n");
            }
        }
    }

    boolean getFlag(int flags, int bitMask) {
        return (flags & bitMask) != 0;
    }

    int setFlag(int flags, int bitMask, boolean state) {
        flags &= ~bitMask;
        if (state) {
            flags |= bitMask;
        }
        return flags;
    }

    static {
        hiResFactor = 4.0f;
        hiResAntiAliased = true;
    }
}

