/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dst;

import edu.emory.mathcs.jtransforms.dst.DoubleDST_1D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_2D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_3D;
import edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckDoubleDST {
    private static int[] sizes1D = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 512, 1024, 1056, 2048, 8192, 10158, 16384, 32768, 65536, 131072};
    private static int[] sizes2D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 511, 512, 1024};
    private static int[] sizes3D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 128};
    private static double eps = Math.pow(2.0, -52.0);

    private AccuracyCheckDoubleDST() {
    }

    public static void checkAccuracyDST_1D() {
        System.out.println("Checking accuracy of 1D DST...");
        int i = 0;
        while (i < sizes1D.length) {
            DoubleDST_1D dst = new DoubleDST_1D(sizes1D[i]);
            double err = 0.0;
            double[] a = new double[sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], a);
            double[] b = new double[sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], b);
            dst.forward(a, true);
            dst.inverse(a, true);
            err = AccuracyCheckDoubleDST.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            dst = null;
            System.gc();
            ++i;
        }
    }

    public static void checkAccuracyDST_2D() {
        Object b;
        Object a;
        double err;
        DoubleDST_2D dst2;
        System.out.println("Checking accuracy of 2D DST (double[] input)...");
        int i = 0;
        while (i < sizes2D.length) {
            dst2 = new DoubleDST_2D(sizes2D[i], sizes2D[i]);
            err = 0.0;
            a = new double[sizes2D[i] * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], a);
            b = new double[sizes2D[i] * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], b);
            dst2.forward((double[])a, true);
            dst2.inverse((double[])a, true);
            err = AccuracyCheckDoubleDST.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            dst2 = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of 2D DST (double[][] input)...");
        i = 0;
        while (i < sizes2D.length) {
            dst2 = new DoubleDST_2D(sizes2D[i], sizes2D[i]);
            err = 0.0;
            a = new double[sizes2D[i]][sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], (double[][])a);
            b = new double[sizes2D[i]][sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], (double[][])b);
            dst2.forward((double[][])a, true);
            dst2.inverse((double[][])a, true);
            err = AccuracyCheckDoubleDST.computeRMSE((double[][])a, (double[][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            dst2 = null;
            System.gc();
            ++i;
        }
    }

    public static void checkAccuracyDST_3D() {
        Object b;
        Object a;
        double err;
        DoubleDST_3D dst3;
        System.out.println("Checking accuracy of 3D DST (double[] input)...");
        int i = 0;
        while (i < sizes3D.length) {
            dst3 = new DoubleDST_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            err = 0.0;
            a = new double[sizes3D[i] * sizes3D[i] * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], a);
            b = new double[sizes3D[i] * sizes3D[i] * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], b);
            dst3.forward((double[])a, true);
            dst3.inverse((double[])a, true);
            err = AccuracyCheckDoubleDST.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            dst3 = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of 3D DST (double[][][] input)...");
        i = 0;
        while (i < sizes3D.length) {
            dst3 = new DoubleDST_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            err = 0.0;
            a = new double[sizes3D[i]][sizes3D[i]][sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], (double[][][])a);
            b = new double[sizes3D[i]][sizes3D[i]][sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], (double[][][])b);
            dst3.forward((double[][][])a, true);
            dst3.inverse((double[][][])a, true);
            err = AccuracyCheckDoubleDST.computeRMSE((double[][][])a, (double[][][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            dst3 = null;
            System.gc();
            ++i;
        }
    }

    private static double computeRMSE(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double rms = 0.0;
        int i = 0;
        while (i < a.length) {
            double tmp = a[i] - b[i];
            rms += tmp * tmp;
            ++i;
        }
        return Math.sqrt(rms / (double)a.length);
    }

    private static double computeRMSE(double[][] a, double[][] b) {
        if (a.length != b.length || a[0].length != b[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double rms = 0.0;
        int r = 0;
        while (r < a.length) {
            int c = 0;
            while (c < a[0].length) {
                double tmp = a[r][c] - b[r][c];
                rms += tmp * tmp;
                ++c;
            }
            ++r;
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length));
    }

    private static double computeRMSE(double[][][] a, double[][][] b) {
        if (a.length != b.length || a[0].length != b[0].length || a[0][0].length != b[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double rms = 0.0;
        int s = 0;
        while (s < a.length) {
            int r = 0;
            while (r < a[0].length) {
                int c = 0;
                while (c < a[0][0].length) {
                    double tmp = a[s][r][c] - b[s][r][c];
                    rms += tmp * tmp;
                    ++c;
                }
                ++r;
            }
            ++s;
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length * a[0][0].length));
    }

    public static void main(String[] args) {
        AccuracyCheckDoubleDST.checkAccuracyDST_1D();
        AccuracyCheckDoubleDST.checkAccuracyDST_2D();
        AccuracyCheckDoubleDST.checkAccuracyDST_3D();
        System.exit(0);
    }
}

