/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event;

import com.jogamp.newt.event.InputEvent;

public class MouseEvent
extends InputEvent {
    public static final short BUTTON1 = 1;
    public static final short BUTTON2 = 2;
    public static final short BUTTON3 = 3;
    public static final short BUTTON4 = 4;
    public static final short BUTTON5 = 5;
    public static final short BUTTON6 = 6;
    public static final short BUTTON7 = 7;
    public static final short BUTTON8 = 8;
    public static final short BUTTON9 = 9;
    public static final short BUTTON_COUNT = 16;
    public static final short BUTTON_NUMBER = 16;
    private final PointerType[] pointerType;
    private final short[] pointerID;
    private final int[] x;
    private final int[] y;
    private final float[] pressure;
    private final short clickCount;
    private final short button;
    private final float[] rotationXYZ;
    private final float rotationScale;
    private final float maxPressure;
    private static final float[] constMousePressure0 = new float[]{0.0f};
    private static final float[] constMousePressure1 = new float[]{1.0f};
    private static final PointerType[] constMousePointerTypes = new PointerType[]{PointerType.Mouse};
    public static final short EVENT_MOUSE_CLICKED = 200;
    public static final short EVENT_MOUSE_ENTERED = 201;
    public static final short EVENT_MOUSE_EXITED = 202;
    public static final short EVENT_MOUSE_PRESSED = 203;
    public static final short EVENT_MOUSE_RELEASED = 204;
    public static final short EVENT_MOUSE_MOVED = 205;
    public static final short EVENT_MOUSE_DRAGGED = 206;
    public static final short EVENT_MOUSE_WHEEL_MOVED = 207;

    public static final float[] getRotationXYZ(float f, int n) {
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
        if (0 != (n & 1)) {
            fArray[0] = f;
        } else {
            fArray[1] = f;
        }
        return fArray;
    }

    public static final short getClickTimeout() {
        return 300;
    }

    public MouseEvent(short s, Object object, long l, int n, int n2, int n3, short s2, short s3, float[] fArray, float f) {
        super(s, object, l, n);
        this.x = new int[]{n2};
        this.y = new int[]{n3};
        switch (s) {
            case 200: 
            case 203: 
            case 206: {
                this.pressure = constMousePressure1;
                break;
            }
            default: {
                this.pressure = constMousePressure0;
            }
        }
        this.maxPressure = 1.0f;
        this.pointerID = new short[]{(short)(s3 - 1)};
        this.clickCount = s2;
        this.button = s3;
        this.rotationXYZ = fArray;
        this.rotationScale = f;
        this.pointerType = constMousePointerTypes;
    }

    public MouseEvent(short s, Object object, long l, int n, PointerType[] pointerTypeArray, short[] sArray, int[] nArray, int[] nArray2, float[] fArray, float f, short s2, short s3, float[] fArray2, float f2) {
        super(s, object, l, n);
        this.x = nArray;
        this.y = nArray2;
        int n2 = pointerTypeArray.length;
        if (n2 != sArray.length || n2 != nArray.length || n2 != nArray2.length || n2 != fArray.length) {
            throw new IllegalArgumentException("All multiple pointer arrays must be of same size");
        }
        if (0.0f >= f) {
            throw new IllegalArgumentException("maxPressure must be > 0.0f");
        }
        this.pressure = fArray;
        this.maxPressure = f;
        this.pointerID = sArray;
        this.clickCount = s3;
        this.button = s2;
        this.rotationXYZ = fArray2;
        this.rotationScale = f2;
        this.pointerType = pointerTypeArray;
    }

    public MouseEvent createVariant(short s) {
        return new MouseEvent(s, this.source, this.getWhen(), this.getModifiers(), this.pointerType, this.pointerID, this.x, this.y, this.pressure, this.maxPressure, this.button, this.clickCount, this.rotationXYZ, this.rotationScale);
    }

    public final int getPointerCount() {
        return this.pointerType.length;
    }

    public final PointerType getPointerType(int n) {
        if (0 > n || n >= this.pointerType.length) {
            return null;
        }
        return this.pointerType[n];
    }

    public final PointerType[] getAllPointerTypes() {
        return this.pointerType;
    }

    public final short getPointerId(int n) {
        if (0 > n || n >= this.pointerID.length) {
            return -1;
        }
        return this.pointerID[n];
    }

    public final int getPointerIdx(short s) {
        if (s >= 0) {
            for (int i = this.pointerID.length - 1; i >= 0; --i) {
                if (this.pointerID[i] != s) continue;
                return i;
            }
        }
        return -1;
    }

    public final short[] getAllPointerIDs() {
        return this.pointerID;
    }

    public final short getButton() {
        return this.button;
    }

    public final short getClickCount() {
        return this.clickCount;
    }

    public final int getX() {
        return this.x[0];
    }

    public final int getY() {
        return this.y[0];
    }

    public final int getX(int n) {
        return this.x[n];
    }

    public final int getY(int n) {
        return this.y[n];
    }

    public final int[] getAllX() {
        return this.x;
    }

    public final int[] getAllY() {
        return this.y;
    }

    public final float getPressure(boolean bl) {
        return bl ? this.pressure[0] / this.maxPressure : this.pressure[0];
    }

    public final float getPressure(int n, boolean bl) {
        return bl ? this.pressure[n] / this.maxPressure : this.pressure[n];
    }

    public final float[] getAllPressures() {
        return this.pressure;
    }

    public final float getMaxPressure() {
        return this.maxPressure;
    }

    public final float[] getRotation() {
        return this.rotationXYZ;
    }

    public final float getRotationScale() {
        return this.rotationScale;
    }

    @Override
    public final String toString() {
        return this.toString(null).toString();
    }

    @Override
    public final StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("MouseEvent[").append(MouseEvent.getEventTypeString(this.getEventType())).append(", ").append(this.x).append("/").append(this.y).append(", button ").append(this.button).append(", count ").append(this.clickCount).append(", rotation [").append(this.rotationXYZ[0]).append(", ").append(this.rotationXYZ[1]).append(", ").append(this.rotationXYZ[2]).append("] * ").append(this.rotationScale);
        if (this.pointerID.length > 0) {
            stringBuilder.append(", pointer<").append(this.pointerID.length).append(">[");
            for (int i = 0; i < this.pointerID.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.pointerID[i]).append("/").append(this.pointerType[i]).append(": ").append(this.x[i]).append("/").append(this.y[i]).append(", ").append("p[").append(this.pressure[i]).append("/").append(this.maxPressure).append("=").append(this.pressure[i] / this.maxPressure).append("]");
            }
            stringBuilder.append("]");
        }
        stringBuilder.append(", ");
        return super.toString(stringBuilder).append("]");
    }

    public static String getEventTypeString(short s) {
        switch (s) {
            case 200: {
                return "EVENT_MOUSE_CLICKED";
            }
            case 201: {
                return "EVENT_MOUSE_ENTERED";
            }
            case 202: {
                return "EVENT_MOUSE_EXITED";
            }
            case 203: {
                return "EVENT_MOUSE_PRESSED";
            }
            case 204: {
                return "EVENT_MOUSE_RELEASED";
            }
            case 205: {
                return "EVENT_MOUSE_MOVED";
            }
            case 206: {
                return "EVENT_MOUSE_DRAGGED";
            }
            case 207: {
                return "EVENT_MOUSE_WHEEL_MOVED";
            }
        }
        return "unknown (" + s + ")";
    }

    public static enum PointerType implements InputEvent.InputType
    {
        Mouse(PointerClass.Offscreen),
        TouchPad(PointerClass.Offscreen),
        TouchScreen(PointerClass.Onscreen),
        Pen(PointerClass.Onscreen),
        Undefined(PointerClass.Undefined);

        PointerClass pc;

        public PointerClass getPointerClass() {
            return this.pc;
        }

        public static PointerType valueOf(int n) throws IllegalArgumentException {
            PointerType[] pointerTypeArray = PointerType.values();
            if (0 <= n && n < pointerTypeArray.length) {
                return pointerTypeArray[n];
            }
            throw new IllegalArgumentException("Ordinal " + n + " out of range of PointerType.values()[0.." + (pointerTypeArray.length - 1) + "]");
        }

        public static PointerType[] valuesOf(int[] nArray) throws IllegalArgumentException {
            int n = nArray.length;
            PointerType[] pointerTypeArray = new PointerType[n];
            for (int i = n - 1; i >= 0; --i) {
                pointerTypeArray[i] = PointerType.valueOf(nArray[i]);
            }
            return pointerTypeArray;
        }

        private PointerType(PointerClass pointerClass) {
            this.pc = pointerClass;
        }
    }

    public static enum PointerClass implements InputEvent.InputClass
    {
        Offscreen,
        Onscreen,
        Undefined;

    }
}

