/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base;

public class Shape {
    private static final long LONG_MAX = Long.MAX_VALUE;
    private static final long INT_MAX = Integer.MAX_VALUE;
    private final long number;
    private final int rank;
    private final int[] dims;
    public static final Shape scalarShape = new Shape(new int[0], true);

    @Deprecated
    public static Shape make() {
        return scalarShape;
    }

    @Deprecated
    public static Shape make(int[] dims) {
        if (dims == null || dims.length == 0) {
            return scalarShape;
        }
        return new Shape(dims, false);
    }

    @Deprecated
    public static Shape make(long[] dims) {
        if (dims == null || dims.length == 0) {
            return scalarShape;
        }
        return new Shape(dims);
    }

    @Deprecated
    public static Shape make(int dim1) {
        return new Shape(new int[]{dim1}, true);
    }

    @Deprecated
    public static Shape make(int dim1, int dim2) {
        return new Shape(new int[]{dim1, dim2}, true);
    }

    @Deprecated
    public static Shape make(int dim1, int dim2, int dim3) {
        return new Shape(new int[]{dim1, dim2, dim3}, true);
    }

    @Deprecated
    public static Shape make(int dim1, int dim2, int dim3, int dim4) {
        return new Shape(new int[]{dim1, dim2, dim3, dim4}, true);
    }

    @Deprecated
    public static Shape make(int dim1, int dim2, int dim3, int dim4, int dim5) {
        return new Shape(new int[]{dim1, dim2, dim3, dim4, dim5}, true);
    }

    @Deprecated
    public static Shape make(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        return new Shape(new int[]{dim1, dim2, dim3, dim4, dim5, dim6}, true);
    }

    @Deprecated
    public static Shape make(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        return new Shape(new int[]{dim1, dim2, dim3, dim4, dim5, dim6, dim7}, true);
    }

    @Deprecated
    public static Shape make(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        return new Shape(new int[]{dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8}, true);
    }

    @Deprecated
    public static Shape make(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        return new Shape(new int[]{dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9}, true);
    }

    public final int rank() {
        return this.rank;
    }

    public final long number() {
        return this.number;
    }

    public final int dimension(int k) {
        return this.dims[k];
    }

    public final int[] copyDimensions() {
        if (this.rank == 0) {
            return this.dims;
        }
        int[] copy = new int[this.rank];
        for (int k = 0; k < this.rank; ++k) {
            copy[k] = this.dims[k];
        }
        return copy;
    }

    public final boolean equals(Shape other) {
        if (other != this && other.dims != this.dims) {
            if (this.rank != other.rank) {
                return false;
            }
            for (int k = 0; k < this.rank; ++k) {
                if (other.dims[k] == this.dims[k]) continue;
                return false;
            }
        }
        return true;
    }

    private Shape(int[] dims, boolean share) {
        long number = 1L;
        this.rank = dims.length;
        if (share) {
            this.dims = dims;
            for (int k = 0; k < this.rank; ++k) {
                int dim = dims[k];
                if (dim < 1) {
                    Shape.dimensionTooSmall();
                }
                if ((long)dim > Long.MAX_VALUE / number) {
                    Shape.numberOverflow();
                }
                number *= (long)dim;
            }
        } else {
            this.dims = new int[this.rank];
            for (int k = 0; k < this.rank; ++k) {
                int dim = dims[k];
                if (dim < 1) {
                    Shape.dimensionTooSmall();
                }
                if ((long)dim > Long.MAX_VALUE / number) {
                    Shape.numberOverflow();
                }
                number *= (long)dim;
                this.dims[k] = dim;
            }
        }
        this.number = number;
    }

    public Shape(int[] dims) {
        this(dims, false);
    }

    public Shape(long[] dims) {
        long number = 1L;
        this.rank = dims.length;
        this.dims = new int[this.rank];
        for (int k = 0; k < this.rank; ++k) {
            long dim = dims[k];
            if (dim < 1L) {
                Shape.dimensionTooSmall();
            }
            if (dim > Integer.MAX_VALUE) {
                Shape.dimensionTooLarge();
            }
            if (dim > Long.MAX_VALUE / number) {
                Shape.numberOverflow();
            }
            number *= dim;
            this.dims[k] = (int)dim;
        }
        this.number = number;
    }

    public Shape(int dim1) {
        this(new int[]{dim1}, true);
    }

    public Shape(int dim1, int dim2) {
        this(new int[]{dim1, dim2}, true);
    }

    public Shape(int dim1, int dim2, int dim3) {
        this(new int[]{dim1, dim2, dim3}, true);
    }

    public Shape(int dim1, int dim2, int dim3, int dim4) {
        this(new int[]{dim1, dim2, dim3, dim4}, true);
    }

    public Shape(int dim1, int dim2, int dim3, int dim4, int dim5) {
        this(new int[]{dim1, dim2, dim3, dim4, dim5}, true);
    }

    public Shape(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        this(new int[]{dim1, dim2, dim3, dim4, dim5, dim6}, true);
    }

    public Shape(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        this(new int[]{dim1, dim2, dim3, dim4, dim5, dim6, dim7}, true);
    }

    public Shape(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        this(new int[]{dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8}, true);
    }

    public Shape(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        this(new int[]{dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9}, true);
    }

    public String toString() {
        String str = "[";
        for (int k = 0; k < this.rank; ++k) {
            str = str + String.format(k > 0 ? ",%d" : "%d", this.dims[k]);
        }
        return str + "]";
    }

    private static void dimensionTooSmall() {
        throw new IllegalArgumentException("Dimensions must be at least 1");
    }

    private static void dimensionTooLarge() {
        throw new IllegalArgumentException("Dimensions must be at most Integer.MAX_VALUE");
    }

    private static void numberOverflow() {
        throw new IllegalArgumentException("Total number of elements is too large");
    }
}

