/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.base.Shape;
import mitiv.deconv.ConvolutionFloat;
import mitiv.linalg.shaped.ShapedVectorSpace;
import org.jtransforms.fft.FloatFFT_3D;

class ConvolutionFloat3D
extends ConvolutionFloat {
    private FloatFFT_3D fft = null;
    private final PushPullOperator R;
    private final PushPullOperator S;
    private final int dim1;
    private final int dim2;
    private final int dim3;

    public ConvolutionFloat3D(Shape wrk, ShapedVectorSpace inp, int[] inpOff, ShapedVectorSpace out, int[] outOff) {
        super(wrk, inp, inpOff, out, outOff);
        if (this.getRank() != 3) {
            throw new IllegalArgumentException("Input and output spaces must be 3D");
        }
        this.dim1 = this.workShape.dimension(2);
        this.dim2 = this.workShape.dimension(1);
        this.dim3 = this.workShape.dimension(0);
        this.R = new PushPullOperator(this.workShape, out.getShape(), this.outputOffsets, this.fastOutput);
        this.S = new PushPullOperator(this.workShape, inp.getShape(), this.inputOffsets, this.fastInput);
    }

    private final void createFFT() {
        if (this.fft == null) {
            this.fft = new FloatFFT_3D(this.dim1, this.dim2, this.dim3);
        }
    }

    @Override
    public final void forwardFFT(float[] z) {
        if (z.length != 2 * this.getNumberOfFrequencies()) {
            throw new IllegalArgumentException("Bad argument size");
        }
        this.timerForFFT.resume();
        if (this.fft == null) {
            this.createFFT();
        }
        this.fft.complexForward(z);
        this.timerForFFT.stop();
    }

    @Override
    public final void backwardFFT(float[] z) {
        if (z.length != 2 * this.getNumberOfFrequencies()) {
            throw new IllegalArgumentException("Bad argument size");
        }
        this.timerForFFT.resume();
        if (this.fft == null) {
            this.createFFT();
        }
        this.fft.complexInverse(z, false);
        this.timerForFFT.stop();
    }

    @Override
    public void push(float[] z, float[] x, boolean adjoint) {
        if (adjoint) {
            this.R.push(z, x);
        } else {
            this.S.push(z, x);
        }
    }

    @Override
    public void pull(float[] x, float[] z, boolean adjoint) {
        if (adjoint) {
            this.S.pull(x, z);
        } else {
            this.R.pull(x, z);
        }
    }

    private class PushPullOperator {
        private final boolean fast;
        private final int off1;
        private final int off2;
        private final int off3;
        private final int end1;
        private final int end2;
        private final int end3;

        private PushPullOperator(Shape wrk, Shape usr, int[] off, boolean fast) {
            this.fast = fast;
            this.off1 = off[0];
            this.end1 = this.off1 + usr.dimension(0);
            this.off2 = off[1];
            this.end2 = this.off2 + usr.dimension(1);
            this.off3 = off[2];
            this.end3 = this.off3 + usr.dimension(2);
        }

        private void push(float[] z, float[] x) {
            float zero = 0.0f;
            if (this.fast) {
                int j = 0;
                int k = 0;
                while (j < x.length) {
                    z[k] = x[j];
                    z[k + 1] = 0.0f;
                    ++j;
                    k += 2;
                }
            } else {
                int i1;
                int i2;
                int i3;
                int j = 0;
                int k = 0;
                for (i3 = 0; i3 < this.off3; ++i3) {
                    for (i2 = 0; i2 < ConvolutionFloat3D.this.dim2; ++i2) {
                        i1 = 0;
                        while (i1 < ConvolutionFloat3D.this.dim1) {
                            z[k] = 0.0f;
                            z[k + 1] = 0.0f;
                            ++i1;
                            k += 2;
                        }
                    }
                }
                for (i3 = this.off3; i3 < this.end3; ++i3) {
                    for (i2 = 0; i2 < this.off2; ++i2) {
                        i1 = 0;
                        while (i1 < ConvolutionFloat3D.this.dim1) {
                            z[k] = 0.0f;
                            z[k + 1] = 0.0f;
                            ++i1;
                            k += 2;
                        }
                    }
                    for (i2 = this.off2; i2 < this.end2; ++i2) {
                        i1 = 0;
                        while (i1 < this.off1) {
                            z[k] = 0.0f;
                            z[k + 1] = 0.0f;
                            ++i1;
                            k += 2;
                        }
                        i1 = this.off1;
                        while (i1 < this.end1) {
                            z[k] = x[j];
                            z[k + 1] = 0.0f;
                            ++i1;
                            ++j;
                            k += 2;
                        }
                        i1 = this.end1;
                        while (i1 < ConvolutionFloat3D.this.dim1) {
                            z[k] = 0.0f;
                            z[k + 1] = 0.0f;
                            ++i1;
                            k += 2;
                        }
                    }
                    for (i2 = this.end2; i2 < ConvolutionFloat3D.this.dim2; ++i2) {
                        i1 = 0;
                        while (i1 < ConvolutionFloat3D.this.dim1) {
                            z[k] = 0.0f;
                            z[k + 1] = 0.0f;
                            ++i1;
                            k += 2;
                        }
                    }
                }
                for (i3 = this.end3; i3 < ConvolutionFloat3D.this.dim3; ++i3) {
                    for (i2 = 0; i2 < ConvolutionFloat3D.this.dim2; ++i2) {
                        i1 = 0;
                        while (i1 < ConvolutionFloat3D.this.dim1) {
                            z[k] = 0.0f;
                            z[k + 1] = 0.0f;
                            ++i1;
                            k += 2;
                        }
                    }
                }
            }
        }

        private void pull(float[] x, float[] z) {
            if (this.fast) {
                int j = 0;
                int k = 0;
                while (j < x.length) {
                    x[j] = z[k];
                    ++j;
                    k += 2;
                }
            } else {
                int j = 0;
                for (int i3 = this.off3; i3 < this.end3; ++i3) {
                    for (int i2 = this.off2; i2 < this.end2; ++i2) {
                        int k = (this.off1 + ConvolutionFloat3D.this.dim1 * (i2 + ConvolutionFloat3D.this.dim3 * i3)) * 2;
                        int i1 = this.off1;
                        while (i1 < this.end1) {
                            x[j] = z[k];
                            ++i1;
                            ++j;
                            k += 2;
                        }
                    }
                }
            }
        }
    }
}

