/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array7D;
import mitiv.array.Byte7D;
import mitiv.array.Double1D;
import mitiv.array.Double6D;
import mitiv.array.DoubleArray;
import mitiv.array.Float7D;
import mitiv.array.Int7D;
import mitiv.array.Long7D;
import mitiv.array.ShapedArray;
import mitiv.array.Short7D;
import mitiv.array.impl.FlatDouble7D;
import mitiv.array.impl.StriddenDouble7D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double7D
extends Array7D
implements DoubleArray {
    protected Double7D(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        super(dim1, dim2, dim3, dim4, dim5, dim6, dim7);
    }

    protected Double7D(int[] dims) {
        super(dims);
    }

    protected Double7D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, double var8);

    @Override
    public void fill(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, value);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, value);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, this.get(i1, i2, i3, i4, i5, i6, i7) + value);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, this.get(i1, i2, i3, i4, i5, i6, i7) + value);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, this.get(i1, i2, i3, i4, i5, i6, i7) - value);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, this.get(i1, i2, i3, i4, i5, i6, i7) - value);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, this.get(i1, i2, i3, i4, i5, i6, i7) * value);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, this.get(i1, i2, i3, i4, i5, i6, i7) * value);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(DoubleFunction function) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, function.apply(this.get(i1, i2, i3, i4, i5, i6, i7)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, function.apply(this.get(i1, i2, i3, i4, i5, i6, i7)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(DoubleGenerator generator) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, generator.nextDouble());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, generator.nextDouble());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(DoubleScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        if (initialized) {
                                            scanner.update(this.get(i1, i2, i3, i4, i5, i6, i7));
                                            continue;
                                        }
                                        scanner.initialize(this.get(i1, i2, i3, i4, i5, i6, i7));
                                        initialized = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        if (initialized) {
                                            scanner.update(this.get(i1, i2, i3, i4, i5, i6, i7));
                                            continue;
                                        }
                                        scanner.initialize(this.get(i1, i2, i3, i4, i5, i6, i7));
                                        initialized = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double minValue = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        if (skip) {
                                            skip = false;
                                            continue;
                                        }
                                        double value = this.get(i1, i2, i3, i4, i5, i6, i7);
                                        if (!(value < minValue)) continue;
                                        minValue = value;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        if (skip) {
                                            skip = false;
                                            continue;
                                        }
                                        double value = this.get(i1, i2, i3, i4, i5, i6, i7);
                                        if (!(value < minValue)) continue;
                                        minValue = value;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return minValue;
    }

    @Override
    public double max() {
        double maxValue = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        if (skip) {
                                            skip = false;
                                            continue;
                                        }
                                        double value = this.get(i1, i2, i3, i4, i5, i6, i7);
                                        if (!(value > maxValue)) continue;
                                        maxValue = value;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        if (skip) {
                                            skip = false;
                                            continue;
                                        }
                                        double value = this.get(i1, i2, i3, i4, i5, i6, i7);
                                        if (!(value > maxValue)) continue;
                                        maxValue = value;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return maxValue;
    }

    @Override
    public double[] getMinAndMax() {
        double[] result = new double[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(double[] mm) {
        double minValue;
        double maxValue = minValue = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        if (skip) {
                                            skip = false;
                                            continue;
                                        }
                                        double value = this.get(i1, i2, i3, i4, i5, i6, i7);
                                        if (value < minValue) {
                                            minValue = value;
                                        }
                                        if (!(value > maxValue)) continue;
                                        maxValue = value;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        if (skip) {
                                            skip = false;
                                            continue;
                                        }
                                        double value = this.get(i1, i2, i3, i4, i5, i6, i7);
                                        if (value < minValue) {
                                            minValue = value;
                                        }
                                        if (!(value > maxValue)) continue;
                                        maxValue = value;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public double sum() {
        double totalValue = 0.0;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        totalValue += this.get(i1, i2, i3, i4, i5, i6, i7);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        totalValue += this.get(i1, i2, i3, i4, i5, i6, i7);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte7D toByte() {
        byte[] out = new byte[this.number];
        if (this.isFlat()) {
            double[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (byte)inp[i];
            }
        } else {
            int i = -1;
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        out[++i] = (byte)this.get(i1, i2, i3, i4, i5, i6, i7);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Byte7D.wrap(out, this.getShape());
    }

    @Override
    public Short7D toShort() {
        short[] out = new short[this.number];
        if (this.isFlat()) {
            double[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (short)inp[i];
            }
        } else {
            int i = -1;
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        out[++i] = (short)this.get(i1, i2, i3, i4, i5, i6, i7);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Short7D.wrap(out, this.getShape());
    }

    @Override
    public Int7D toInt() {
        int[] out = new int[this.number];
        if (this.isFlat()) {
            double[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (int)inp[i];
            }
        } else {
            int i = -1;
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        out[++i] = (int)this.get(i1, i2, i3, i4, i5, i6, i7);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Int7D.wrap(out, this.getShape());
    }

    @Override
    public Long7D toLong() {
        long[] out = new long[this.number];
        if (this.isFlat()) {
            double[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (long)inp[i];
            }
        } else {
            int i = -1;
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        out[++i] = (long)this.get(i1, i2, i3, i4, i5, i6, i7);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Long7D.wrap(out, this.getShape());
    }

    @Override
    public Float7D toFloat() {
        float[] out = new float[this.number];
        if (this.isFlat()) {
            double[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (float)inp[i];
            }
        } else {
            int i = -1;
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        out[++i] = (float)this.get(i1, i2, i3, i4, i5, i6, i7);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Float7D.wrap(out, this.getShape());
    }

    @Override
    public Double7D toDouble() {
        return this;
    }

    @Override
    public Double7D copy() {
        return new FlatDouble7D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Double7D src = arr.getType() == 5 ? (Double7D)arr : (Double7D)arr.toDouble();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, src.get(i1, i2, i3, i4, i5, i6, i7));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, src.get(i1, i2, i3, i4, i5, i6, i7));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, src.get(++i));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            for (int i7 = 0; i7 < this.dim7; ++i7) {
                for (int i6 = 0; i6 < this.dim6; ++i6) {
                    for (int i5 = 0; i5 < this.dim5; ++i5) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i2 = 0; i2 < this.dim2; ++i2) {
                                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, src.get(++i));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double7D create() {
        return new FlatDouble7D(this.getShape());
    }

    public static Double7D create(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        return new FlatDouble7D(dim1, dim2, dim3, dim4, dim5, dim6, dim7);
    }

    public static Double7D create(int[] dims) {
        return new FlatDouble7D(dims);
    }

    public static Double7D create(Shape shape) {
        return new FlatDouble7D(shape);
    }

    public static Double7D wrap(double[] data, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        return new FlatDouble7D(data, dim1, dim2, dim3, dim4, dim5, dim6, dim7);
    }

    public static Double7D wrap(double[] data, int[] dims) {
        return new FlatDouble7D(data, dims);
    }

    public static Double7D wrap(double[] data, Shape shape) {
        return new FlatDouble7D(data, shape);
    }

    public static Double7D wrap(double[] data, int offset, int stride1, int stride2, int stride3, int stride4, int stride5, int stride6, int stride7, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        return new StriddenDouble7D(data, offset, stride1, stride2, stride3, stride4, stride5, stride6, stride7, dim1, dim2, dim3, dim4, dim5, dim6, dim7);
    }

    @Override
    public abstract Double6D slice(int var1);

    @Override
    public abstract Double6D slice(int var1, int var2);

    @Override
    public abstract Double7D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7);

    @Override
    public abstract Double7D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7);

    @Override
    public abstract Double1D as1D();
}

