/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.DoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleBiCGstab
extends AbstractDoubleIterativeSolver {
    private DoubleMatrix1D p;
    private DoubleMatrix1D s;
    private DoubleMatrix1D phat;
    private DoubleMatrix1D shat;
    private DoubleMatrix1D t;
    private DoubleMatrix1D v;
    private DoubleMatrix1D temp;
    private DoubleMatrix1D r;
    private DoubleMatrix1D rtilde;

    public DoubleBiCGstab(DoubleMatrix1D template) {
        this.p = template.copy();
        this.s = template.copy();
        this.phat = template.copy();
        this.shat = template.copy();
        this.t = template.copy();
        this.v = template.copy();
        this.temp = template.copy();
        this.r = template.copy();
        this.rtilde = template.copy();
    }

    @Override
    public DoubleMatrix1D solve(DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(A, b, x);
        double rho_1 = 1.0;
        double rho_2 = 1.0;
        double alpha = 1.0;
        double beta = 1.0;
        double omega = 1.0;
        A.zMult(x, this.r.assign(b), -1.0, 1.0, false);
        this.rtilde.assign(this.r);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            rho_1 = this.rtilde.zDotProduct(this.r);
            if (rho_1 == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (omega == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "omega", this.iter);
            }
            if (this.iter.isFirst()) {
                this.p.assign(this.r);
            } else {
                beta = rho_1 / rho_2 * (alpha / omega);
                this.temp.assign(this.v, DoubleFunctions.multSecond(-omega)).assign(this.p, DoubleFunctions.plus);
                this.p.assign(this.r).assign(this.temp, DoubleFunctions.plusMultSecond(beta));
            }
            this.M.apply(this.p, this.phat);
            A.zMult(this.phat, this.v);
            alpha = rho_1 / this.rtilde.zDotProduct(this.v);
            this.s.assign(this.r).assign(this.v, DoubleFunctions.plusMultSecond(-alpha));
            if (this.iter.converged(this.s, x)) {
                return x.assign(this.phat, DoubleFunctions.plusMultSecond(alpha));
            }
            this.M.apply(this.s, this.shat);
            A.zMult(this.shat, this.t);
            omega = this.t.zDotProduct(this.s) / this.t.zDotProduct(this.t);
            x.assign(this.phat, DoubleFunctions.plusMultSecond(alpha));
            x.assign(this.shat, DoubleFunctions.plusMultSecond(omega));
            this.r.assign(this.s).assign(this.t, DoubleFunctions.plusMultSecond(-omega));
            rho_2 = rho_1;
            this.iter.next();
        }
        return x;
    }
}

