/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.CGLSDoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoubleIdentity;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleCGLS
extends AbstractDoubleIterativeSolver {
    private static final DenseDoubleAlgebra alg = DenseDoubleAlgebra.DEFAULT;
    public static final double sqrteps = Math.sqrt(Math.pow(2.0, -52.0));

    public DoubleCGLS() {
        this.iter = new CGLSDoubleIterationMonitor();
        ((CGLSDoubleIterationMonitor)this.iter).setRelativeTolerance(-1.0);
    }

    @Override
    public DoubleMatrix1D solve(DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        double gamma;
        double oldgamma = 0.0;
        if (((CGLSDoubleIterationMonitor)this.iter).getRelativeTolerance() == -1.0) {
            ((CGLSDoubleIterationMonitor)this.iter).setRelativeTolerance(sqrteps * alg.norm2(A.zMult(b, null, 1.0, 0.0, true)));
        }
        DoubleMatrix1D s = A.zMult(x, null);
        s.assign(b, DoubleFunctions.plusMultFirst(-1.0));
        DoubleMatrix1D r = A.zMult(s, null, 1.0, 0.0, true);
        double rnrm = alg.norm2(r);
        if (!(this.M instanceof DoubleIdentity)) {
            r = this.M.transApply(r, null);
            gamma = alg.norm2(r);
            gamma *= gamma;
        } else {
            gamma = rnrm;
            gamma *= gamma;
        }
        DoubleMatrix1D p = r.copy();
        this.iter.setFirst();
        while (!this.iter.converged(rnrm, x)) {
            DoubleMatrix1D q;
            if (!this.iter.isFirst()) {
                double beta = gamma / oldgamma;
                p.assign(r, DoubleFunctions.plusMultFirst(beta));
            }
            if (!(this.M instanceof DoubleIdentity)) {
                r = this.M.apply(p, null);
                q = A.zMult(r, null);
            } else {
                q = A.zMult(p, null);
            }
            double nq = alg.norm2(q);
            nq *= nq;
            double alpha = gamma / nq;
            if (!(this.M instanceof DoubleIdentity)) {
                x.assign(r, DoubleFunctions.plusMultSecond(alpha));
            } else {
                x.assign(p, DoubleFunctions.plusMultSecond(alpha));
            }
            s.assign(q, DoubleFunctions.plusMultSecond(-alpha));
            r = A.zMult(s, null, 1.0, 0.0, true);
            rnrm = alg.norm2(r);
            if (!(this.M instanceof DoubleIdentity)) {
                r = this.M.transApply(r, null);
                oldgamma = gamma;
                gamma = alg.norm2(r);
                gamma *= gamma;
            } else {
                oldgamma = gamma;
                gamma = rnrm;
                gamma *= gamma;
            }
            this.iter.next();
        }
        return x;
    }
}

