/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat;

import cern.colt.PersistentObject;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix3D;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatFactory3D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final FloatFactory3D dense = new FloatFactory3D();
    public static final FloatFactory3D sparse = new FloatFactory3D();

    protected FloatFactory3D() {
    }

    public FloatMatrix3D ascending(int slices, int rows, int columns) {
        return this.descending(slices, rows, columns).assign(FloatFunctions.chain(FloatFunctions.neg, FloatFunctions.minus(slices * rows * columns)));
    }

    public FloatMatrix3D descending(int slices, int rows, int columns) {
        FloatMatrix3D matrix = this.make(slices, rows, columns);
        int v = 0;
        int slice = slices;
        while (--slice >= 0) {
            int row = rows;
            while (--row >= 0) {
                int column = columns;
                while (--column >= 0) {
                    matrix.setQuick(slice, row, column, v++);
                }
            }
        }
        return matrix;
    }

    public FloatMatrix3D make(float[][][] values) {
        if (this == sparse) {
            return new SparseFloatMatrix3D(values);
        }
        return new DenseFloatMatrix3D(values);
    }

    public FloatMatrix3D make(int slices, int rows, int columns) {
        if (this == sparse) {
            return new SparseFloatMatrix3D(slices, rows, columns);
        }
        return new DenseFloatMatrix3D(slices, rows, columns);
    }

    public FloatMatrix3D make(int slices, int rows, int columns, float initialValue) {
        return this.make(slices, rows, columns).assign(initialValue);
    }

    public FloatMatrix3D random(int slices, int rows, int columns) {
        return this.make(slices, rows, columns).assign(FloatFunctions.random());
    }
}

