/*
 * Decompiled with CFR 0.152.
 */
package microTiPi.microUtils;

import mitiv.utils.MathUtils;

public class Zernike {
    public static int[] zernumeroNoll(int J) {
        int[] nm = new int[2];
        double k = 0.0;
        int n = 0;
        double n1 = (Math.sqrt(1 + 8 * J) - 1.0) / 2.0;
        if (n1 == (double)(n = (int)Math.floor(n1))) {
            --n;
        }
        k = (n + 1) * (n + 2) / 2;
        nm[1] = (int)((double)n - 2.0 * Math.floor((k - (double)J) / 2.0));
        nm[0] = n;
        return nm;
    }

    public static double[] coeffRadialZCumSumLog(int n, int m) {
        int p = (n - m) / 2;
        int q = (n + m) / 2;
        double[] R_mn = new double[p + 1];
        double[] lfact = new double[n + 1];
        for (int i = 1; i < n + 1; ++i) {
            lfact[i] = Math.log(i);
        }
        lfact = MathUtils.cumSum((double[])lfact);
        for (int s = 0; s <= (n - m) / 2; ++s) {
            R_mn[s] = Math.exp(lfact[n - s] - lfact[s] - lfact[p - s] - lfact[q - s]);
            if (MathUtils.even((int)s)) continue;
            R_mn[s] = -R_mn[s];
        }
        return R_mn;
    }

    public static double[] radialZDegree(int n, int m) {
        double[] degR_mn = new double[(n - m) / 2 + 1];
        for (int s = 0; s <= (n - m) / 2; ++s) {
            degR_mn[s] = n - 2 * s;
        }
        return degR_mn;
    }

    public static double[] zernikeArray(int nbZernike, int width, int height, double radius, boolean normalize, boolean radial) {
        int nz;
        int k;
        int[] nm;
        int n;
        double[] Z = new double[nbZernike * width * height];
        int WH = width * height;
        double[] r = MathUtils.fftDist1D((int)width, (int)height);
        double[] theta = MathUtils.fftAngle1D((int)width, (int)height);
        if (radial) {
            n = nbZernike + 1;
        } else {
            nm = Zernike.zernumeroNoll(nbZernike + 1);
            n = nm[0];
            int n2 = nm[1];
        }
        double[] rPowers = new double[(n + 1) * width * height];
        for (int l = 0; l < WH; ++l) {
            if (!(r[l] < radius)) continue;
            rPowers[l] = 1.0;
            Z[l] = 1.0;
            rPowers[l + WH] = r[l] / radius;
        }
        if (normalize) {
            double NormZ = 1.0 / Math.sqrt(MathUtils.sum((double[])MathUtils.abs2((double[])Z, (int)0, (int)(WH - 1), (int)0)));
            for (int l = 0; l < WH; ++l) {
                Z[l] = Z[l] * NormZ;
            }
        }
        if (radial) {
            for (k = 2; k < nbZernike + 1; ++k) {
                for (int l = 0; l < WH; ++l) {
                    rPowers[l + k * WH] = rPowers[l + (k - 1) * WH] * rPowers[l + WH];
                }
            }
            for (nz = 1; nz < nbZernike; ++nz) {
                double[] R_mn = Zernike.coeffRadialZCumSumLog(nz, 0);
                double zr = 0.0;
                for (int l = 0; l < WH; ++l) {
                    zr = 0.0;
                    double N = Math.sqrt(nz + 1);
                    for (int s = nz / 2; s >= 0; --s) {
                        zr += R_mn[s] * rPowers[l + (nz - 2 * s) * WH];
                    }
                    Z[l + nz * WH] = N * zr;
                }
                if (!normalize) continue;
                double NormZ = 1.0 / Math.sqrt(MathUtils.sum((double[])MathUtils.abs2((double[])Z, (int)(nz * WH), (int)(nz * WH + WH - 1), (int)0)));
                for (int l = 0; l < WH; ++l) {
                    int n3 = l + nz * WH;
                    Z[n3] = Z[n3] * NormZ;
                }
            }
        } else {
            for (k = 2; k < n + 1; ++k) {
                for (int l = 0; l < WH; ++l) {
                    rPowers[l + k * WH] = rPowers[l + (k - 1) * WH] * rPowers[l + WH];
                }
            }
            for (nz = 1; nz < nbZernike; ++nz) {
                int l;
                int s;
                nm = Zernike.zernumeroNoll(nz + 1);
                n = nm[0];
                int m = nm[1];
                double[] R_mn = Zernike.coeffRadialZCumSumLog(n, m);
                double zr = 0.0;
                if (m == 0) {
                    for (int l2 = 0; l2 < WH; ++l2) {
                        zr = 0.0;
                        double N = Math.sqrt(n + 1);
                        for (s = (n - m) / 2; s >= 0; --s) {
                            zr += R_mn[s] * rPowers[l2 + (n - 2 * s) * WH];
                        }
                        Z[l2 + nz * WH] = N * zr;
                    }
                    if (!normalize) continue;
                    double NormZ = 1.0 / Math.sqrt(MathUtils.sum((double[])MathUtils.abs2((double[])Z, (int)(nz * WH), (int)(nz * WH + WH - 1), (int)0)));
                    for (l = 0; l < WH; ++l) {
                        int n4 = l + nz * WH;
                        Z[n4] = Z[n4] * NormZ;
                    }
                    continue;
                }
                if (MathUtils.even((int)(nz + 1))) {
                    for (int l3 = 0; l3 < WH; ++l3) {
                        double N = Math.sqrt(2 * (n + 1));
                        zr = 0.0;
                        for (s = (n - m) / 2; s >= 0; --s) {
                            zr += R_mn[s] * rPowers[l3 + (n - 2 * s) * WH];
                        }
                        Z[l3 + nz * WH] = N * zr * Math.cos((double)m * theta[l3]);
                    }
                    if (!normalize) continue;
                    double NormZ = 1.0 / Math.sqrt(MathUtils.sum((double[])MathUtils.abs2((double[])Z, (int)(nz * WH), (int)(nz * WH + WH - 1), (int)0)));
                    for (l = 0; l < WH; ++l) {
                        Z[l + nz * WH] = Z[l + nz * WH] * NormZ;
                    }
                    continue;
                }
                for (int l4 = 0; l4 < WH; ++l4) {
                    double N = Math.sqrt(2 * (n + 1));
                    zr = 0.0;
                    for (s = (n - m) / 2; s >= 0; --s) {
                        zr += R_mn[s] * rPowers[l4 + (n - 2 * s) * WH];
                    }
                    Z[l4 + nz * WH] = N * zr * Math.sin((double)m * theta[l4]);
                }
                if (!normalize) continue;
                double NormZ = 1.0 / Math.sqrt(MathUtils.sum((double[])MathUtils.abs2((double[])Z, (int)(nz * WH), (int)(nz * WH + WH - 1), (int)0)));
                for (l = 0; l < WH; ++l) {
                    Z[l + nz * WH] = Z[l + nz * WH] * NormZ;
                }
            }
        }
        return Z;
    }
}

