/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol;

import org.ejml.alg.dense.decomposition.DecompositionFactory;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionCommon;
import org.ejml.alg.dense.linsol.LinearSolver;
import org.ejml.alg.dense.linsol.LinearSolverSafe;
import org.ejml.alg.dense.linsol.chol.LinearSolverChol;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class SolvePseudoInverse
implements LinearSolver<DenseMatrix64F> {
    private LinearSolver<DenseMatrix64F> inverter;
    private DenseMatrix64F ATA;
    private DenseMatrix64F pinv;
    private int maxRows = -1;
    private int maxCols = -1;

    public SolvePseudoInverse(LinearSolver<DenseMatrix64F> linearSolver) {
        this.inverter = linearSolver.modifiesA() ? new LinearSolverSafe<DenseMatrix64F>(linearSolver) : linearSolver;
    }

    public SolvePseudoInverse(int n) {
        this(new LinearSolverChol((CholeskyDecompositionCommon)DecompositionFactory.chol(n, true)));
    }

    public SolvePseudoInverse() {
        this(new LinearSolverChol((CholeskyDecompositionCommon)DecompositionFactory.chol(0, true)));
    }

    public void setMaxSize(int n, int n2) {
        this.maxRows = n;
        this.maxCols = n2;
        this.ATA = new DenseMatrix64F(n2, n2);
        this.pinv = new DenseMatrix64F(n2, n);
    }

    @Override
    public boolean setA(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows > this.maxRows || denseMatrix64F.numCols > this.maxCols) {
            this.setMaxSize(denseMatrix64F.numRows, denseMatrix64F.numCols);
        }
        this.ATA.reshape(denseMatrix64F.numCols, denseMatrix64F.numCols, false);
        CommonOps.multTransA(denseMatrix64F, denseMatrix64F, this.ATA);
        if (!this.inverter.setA(this.ATA)) {
            return false;
        }
        this.inverter.invert(this.ATA);
        CommonOps.multTransB(this.ATA, denseMatrix64F, this.pinv);
        return true;
    }

    @Override
    public double quality() {
        throw new IllegalArgumentException("Not supported by this solver.");
    }

    @Override
    public void solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        CommonOps.mult(this.pinv, denseMatrix64F, denseMatrix64F2);
    }

    @Override
    public void invert(DenseMatrix64F denseMatrix64F) {
        denseMatrix64F.set(this.pinv);
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

