/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool.event;

import com.xuggle.mediatool.IMediaGenerator;
import com.xuggle.mediatool.event.AStreamMixin;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IMediaData;
import java.util.concurrent.TimeUnit;

public abstract class ARawMediaMixin
extends AStreamMixin {
    private final IMediaData mMediaData;
    private final Object mJavaData;
    private final long mTimeStamp;
    private final TimeUnit mTimeUnit;

    public ARawMediaMixin(IMediaGenerator source, IMediaData picture, Object image, long timeStamp, TimeUnit timeUnit, Integer streamIndex) {
        super(source, streamIndex);
        if (image == null && picture == null) {
            throw new IllegalArgumentException();
        }
        this.mMediaData = picture;
        this.mJavaData = image;
        if (image == null) {
            timeStamp = picture.getTimeStamp();
            timeUnit = TimeUnit.MICROSECONDS;
        }
        this.mTimeStamp = timeStamp;
        if (timeUnit == null) {
            throw new IllegalArgumentException();
        }
        this.mTimeUnit = timeUnit;
    }

    public IMediaData getMediaData() {
        return this.mMediaData;
    }

    public Object getJavaData() {
        return this.mJavaData;
    }

    public Long getTimeStamp() {
        return this.getTimeStamp(TimeUnit.MICROSECONDS);
    }

    public Long getTimeStamp(TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        if (this.mTimeStamp == Global.NO_PTS) {
            return null;
        }
        return unit.convert(this.mTimeStamp, this.mTimeUnit);
    }

    public TimeUnit getTimeUnit() {
        return this.mTimeUnit;
    }
}

