/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

abstract class CompilerTool {
    CompilerTool() {
    }

    public static CompilerTool getDefault() {
        JavaxCompilerTool javax;
        if (IJ.isJava16() && ((CompilerTool)(javax = new JavaxCompilerTool())).isSupported()) {
            return javax;
        }
        LegacyCompilerTool legacy = new LegacyCompilerTool();
        if (((CompilerTool)legacy).isSupported()) {
            return legacy;
        }
        return null;
    }

    public abstract boolean compile(List var1, List var2, StringWriter var3);

    protected abstract Object getJavac() throws Exception;

    public boolean isSupported() {
        try {
            return null != this.getJavac();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class LegacyCompilerTool
    extends CompilerTool {
        protected static Class javacC;

        @Override
        public boolean compile(List sources, List options, StringWriter log) {
            if (IJ.debugMode) {
                IJ.log("Compiler: using com.sun.tools.javac");
            }
            try {
                String[] args = new String[sources.size() + options.size()];
                int argsIndex = 0;
                for (int optionsIndex = 0; optionsIndex < options.size(); ++optionsIndex) {
                    args[argsIndex++] = (String)options.get(optionsIndex);
                }
                for (int sourcesIndex = 0; sourcesIndex < sources.size(); ++sourcesIndex) {
                    args[argsIndex++] = (String)sources.get(sourcesIndex);
                }
                PrintWriter printer = new PrintWriter(log);
                Object javac = this.getJavac();
                Class[] compileTypes = new Class[]{String[].class, PrintWriter.class};
                Method compile = javacC.getMethod("compile", compileTypes);
                Object result = compile.invoke(javac, args, printer);
                printer.flush();
                return Integer.valueOf(0).equals(result);
            }
            catch (Exception e) {
                e.printStackTrace(new PrintWriter(log));
                return false;
            }
        }

        @Override
        protected Object getJavac() throws Exception {
            if (javacC == null) {
                javacC = Class.forName("com.sun.tools.javac.Main");
            }
            return javacC.newInstance();
        }
    }

    public static class JavaxCompilerTool
    extends CompilerTool {
        @Override
        public boolean compile(List sources, List options, StringWriter log) {
            if (IJ.debugMode) {
                IJ.log("Compiler: using javax.tool.JavaCompiler");
            }
            try {
                JavaCompiler javac = this.getJavac();
                DiagnosticCollector diagnostics = new DiagnosticCollector();
                StandardJavaFileManager fileManager = javac.getStandardFileManager(diagnostics, null, null);
                Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromStrings(sources);
                JavaCompiler.CompilationTask task = javac.getTask(log, fileManager, null, options, null, compilationUnits);
                fileManager.close();
                return task.call();
            }
            catch (Exception e) {
                PrintWriter printer = new PrintWriter(log);
                e.printStackTrace(printer);
                printer.flush();
                return false;
            }
        }

        @Override
        protected JavaCompiler getJavac() throws Exception {
            JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
            return javac;
        }
    }
}

