/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jpeg;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import com.sun.media.NBA;
import com.sun.media.codec.video.jpeg.NativeEncoder;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public final class NativeDecoder
extends BasicCodec {
    private VideoFormat inputFormat = null;
    private RGBFormat outputFormat = null;
    private static boolean loaded = false;
    private static boolean canLoad = true;
    private int peer = 0;
    int returnVal = 0;
    private boolean dropFrame = false;
    private boolean minimal = false;
    private int decimation = -1;

    public NativeDecoder() {
        this.inputFormats = new VideoFormat[2];
        this.inputFormats[0] = new VideoFormat("jpeg");
        this.inputFormats[1] = new VideoFormat("mjpg");
        this.outputFormats = new RGBFormat[1];
        this.outputFormats[0] = new RGBFormat();
        FrameProcessingControl fpc = new FrameProcessingControl(){

            public boolean setMinimalProcessing(boolean newMinimal) {
                NativeDecoder.this.minimal = newMinimal;
                return NativeDecoder.this.minimal;
            }

            public void setFramesBehind(float frames) {
                if (frames >= 1.0f) {
                    NativeDecoder.this.dropFrame = true;
                } else {
                    NativeDecoder.this.dropFrame = false;
                }
            }

            public Component getControlComponent() {
                return null;
            }

            public int getFramesDropped() {
                return 0;
            }
        };
        this.controls = new Control[1];
        this.controls[0] = fpc;
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return this.outputFormats;
        }
        if (!this.verifyInputFormat(in)) {
            return new Format[0];
        }
        return this.computeOutputFormats(in);
    }

    private boolean verifyInputFormat(Format input) {
        if (!(input instanceof VideoFormat)) {
            return false;
        }
        return input.getEncoding().equalsIgnoreCase("jpeg") || input.getEncoding().equalsIgnoreCase("mjpg");
    }

    public Format setInputFormat(Format input) {
        if (!this.verifyInputFormat(input)) {
            return null;
        }
        this.inputFormat = (VideoFormat)input;
        if (this.opened) {
            this.close();
            this.outputFormat = this.updateRGBFormat(this.inputFormat, this.outputFormat);
        }
        return input;
    }

    public Format setOutputFormat(Format output) {
        if (BasicPlugIn.matches(output, this.outputFormats) == null) {
            return null;
        }
        this.outputFormat = (RGBFormat)output;
        return output;
    }

    private final VideoFormat[] computeOutputFormats(Format in) {
        VideoFormat jpeg = (VideoFormat)in;
        Dimension size = jpeg.getSize();
        if (size == null) {
            size = new Dimension(320, 240);
        }
        int area = (size.width + 7 & 0xFFFFFFF8) * (size.height + 7 & 0xFFFFFFF8);
        VideoFormat[] rgb = new RGBFormat[]{new RGBFormat(size, area * 3, Format.byteArray, jpeg.getFrameRate(), 24, 1, 2, 3, 3, size.width * 3, 1, -1), new RGBFormat(size, area * 3, Format.byteArray, jpeg.getFrameRate(), 24, 3, 2, 1, 3, size.width * 3, 1, -1), new RGBFormat(size, area, Format.intArray, jpeg.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, size.width, 1, -1), new RGBFormat(size, area, Format.intArray, jpeg.getFrameRate(), 32, 255, 65280, 0xFF0000, 1, size.width, 1, -1), new RGBFormat(size, area * 3, Format.byteArray, jpeg.getFrameRate(), 24, 1, 2, 3, 3, size.width * 3, 0, -1), new RGBFormat(size, area * 3, Format.byteArray, jpeg.getFrameRate(), 24, 3, 2, 1, 3, size.width * 3, 0, -1), new RGBFormat(size, area, Format.intArray, jpeg.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, size.width, 0, -1), new RGBFormat(size, area, Format.intArray, jpeg.getFrameRate(), 32, 255, 65280, 0xFF0000, 1, size.width, 0, -1)};
        return rgb;
    }

    public void open() throws ResourceUnavailableException {
        if (!canLoad) {
            throw new ResourceUnavailableException("Unable to load native JPEG converter");
        }
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmutil");
                JMFSecurityManager.loadLibrary("jmjpeg");
                loaded = true;
            }
            catch (Throwable t) {
                canLoad = false;
                throw new ResourceUnavailableException("Unable to load native JPEG decoder");
            }
        }
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Formats not set on the JPEG decoder");
        }
        if (this.peer != 0) {
            this.close();
        }
        Dimension size = this.inputFormat.getSize();
        try {
            this.peer = this.initJPEGDecoder(size.width, size.height);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.inputFormat instanceof JPEGFormat) {
            this.decimation = ((JPEGFormat)this.inputFormat).getDecimation();
        }
        if (this.peer == 0) {
            throw new ResourceUnavailableException("Unable to initialize JPEG decoder");
        }
        super.open();
    }

    public synchronized void close() {
        if (this.peer != 0) {
            this.freeJPEGDecoder(this.peer);
        }
        this.peer = 0;
        super.close();
    }

    public void reset() {
    }

    public synchronized int process(Buffer inBuffer, Buffer outBuffer) {
        boolean flipped;
        Object header = null;
        RGBFormat outFormat = null;
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            return 0;
        }
        if (this.minimal || this.dropFrame) {
            outBuffer.setFlags(outBuffer.getFlags() | 2);
            return 0;
        }
        Format inFormat = inBuffer.getFormat();
        byte[] inData = (byte[])inBuffer.getData();
        if (inBuffer.getLength() < 1) {
            return 0;
        }
        if (!inFormat.equals(this.inputFormat)) {
            this.setInputFormat(inFormat);
            this.close();
        }
        if (outFormat == null) {
            outBuffer.setFormat(this.outputFormat);
            outFormat = this.outputFormat;
        }
        Object outData = this.validateData(outBuffer, 0, true);
        boolean bl = flipped = outFormat.getFlipped() == 1;
        if (this.peer == 0) {
            try {
                this.open();
            }
            catch (ResourceUnavailableException re) {
                return 1;
            }
        }
        Dimension size = this.inputFormat.getSize();
        Integer n2 = NativeEncoder.processLock;
        synchronized (n2) {
            if (outData instanceof byte[]) {
                this.returnVal = this.decodeJPEGToByte(this.peer, inData, inBuffer.getLength(), size.width, size.height, (byte[])outData, this.outputFormat.getMaxDataLength(), flipped, this.outputFormat.getRedMask(), this.outputFormat.getGreenMask(), this.outputFormat.getBlueMask(), this.outputFormat.getBitsPerPixel());
                outBuffer.setLength(size.width * size.height * this.outputFormat.getBitsPerPixel() / 8);
            } else if (outData instanceof int[]) {
                this.returnVal = this.decodeJPEGToInt(this.peer, inData, inBuffer.getLength(), size.width, size.height, (int[])outData, this.outputFormat.getMaxDataLength(), flipped, this.outputFormat.getRedMask(), this.outputFormat.getGreenMask(), this.outputFormat.getBlueMask(), this.outputFormat.getBitsPerPixel());
                outBuffer.setLength(size.width * size.height);
            } else if (outData instanceof NBA) {
                NBA nba = (NBA)outData;
                this.returnVal = this.decodeJPEGToNBA(this.peer, inData, inBuffer.getLength(), size.width, size.height, nba.getNativeData(), this.outputFormat.getMaxDataLength(), flipped, this.outputFormat.getRedMask(), this.outputFormat.getGreenMask(), this.outputFormat.getBlueMask(), this.outputFormat.getBitsPerPixel());
                outBuffer.setLength(size.width * size.height);
                if (this.outputFormat.getDataType() == Format.byteArray) {
                    outBuffer.setLength(outBuffer.getLength() * this.outputFormat.getBitsPerPixel() / 8);
                }
            }
        }
        if (this.returnVal > 0) {
            outBuffer.setOffset(0);
            inBuffer.setLength(0);
            outBuffer.setFlags(outBuffer.getFlags() | 0x10);
            outBuffer.setTimeStamp(inBuffer.getTimeStamp());
            return 0;
        }
        outBuffer.setDiscard(true);
        return 1;
    }

    protected void finalize() {
        this.close();
    }

    public String getName() {
        return "JPEG Decoder";
    }

    private native int initJPEGDecoder(int var1, int var2);

    private native int decodeJPEGToByte(int var1, byte[] var2, int var3, int var4, int var5, byte[] var6, int var7, boolean var8, int var9, int var10, int var11, int var12);

    private native int decodeJPEGToInt(int var1, byte[] var2, int var3, int var4, int var5, int[] var6, int var7, boolean var8, int var9, int var10, int var11, int var12);

    private native int decodeJPEGToNBA(int var1, byte[] var2, int var3, int var4, int var5, long var6, int var8, boolean var9, int var10, int var11, int var12, int var13);

    private native boolean freeJPEGDecoder(int var1);
}

