/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Array2D;
import mitiv.array.Array3D;
import mitiv.array.Array4D;
import mitiv.array.Array5D;
import mitiv.array.Array6D;
import mitiv.array.Array7D;
import mitiv.array.Array8D;
import mitiv.array.Array9D;
import mitiv.array.ArrayFactory;
import mitiv.array.ByteArray;
import mitiv.array.DoubleArray;
import mitiv.array.FloatArray;
import mitiv.array.IntArray;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;

public class ArrayUtils {
    public static double sum(ShapedArray arr) {
        double sum = 0.0;
        if (arr != null) {
            switch (arr.getType()) {
                case 0: {
                    sum = ((ByteArray)arr).sum();
                    break;
                }
                case 1: {
                    sum = ((ShortArray)arr).sum();
                    break;
                }
                case 2: {
                    sum = ((IntArray)arr).sum();
                    break;
                }
                case 3: {
                    sum = ((LongArray)arr).sum();
                    break;
                }
                case 4: {
                    sum = ((FloatArray)arr).sum();
                    break;
                }
                case 5: {
                    sum = ((DoubleArray)arr).sum();
                }
            }
        }
        return sum;
    }

    public static byte[] toByte(byte[] src) {
        return src;
    }

    public static byte[] toByte(short[] src) {
        int number = src.length;
        byte[] dst = new byte[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (byte)src[j];
        }
        return dst;
    }

    public static byte[] toByte(int[] src) {
        int number = src.length;
        byte[] dst = new byte[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (byte)src[j];
        }
        return dst;
    }

    public static byte[] toByte(long[] src) {
        int number = src.length;
        byte[] dst = new byte[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (byte)src[j];
        }
        return dst;
    }

    public static byte[] toByte(float[] src) {
        int number = src.length;
        byte[] dst = new byte[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (byte)src[j];
        }
        return dst;
    }

    public static byte[] toByte(double[] src) {
        int number = src.length;
        byte[] dst = new byte[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (byte)src[j];
        }
        return dst;
    }

    public static short[] toShort(byte[] src) {
        int number = src.length;
        short[] dst = new short[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (short)(src[j] & 0xFF);
        }
        return dst;
    }

    public static short[] toShort(short[] src) {
        return src;
    }

    public static short[] toShort(int[] src) {
        int number = src.length;
        short[] dst = new short[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (short)src[j];
        }
        return dst;
    }

    public static short[] toShort(long[] src) {
        int number = src.length;
        short[] dst = new short[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (short)src[j];
        }
        return dst;
    }

    public static short[] toShort(float[] src) {
        int number = src.length;
        short[] dst = new short[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (short)src[j];
        }
        return dst;
    }

    public static short[] toShort(double[] src) {
        int number = src.length;
        short[] dst = new short[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (short)src[j];
        }
        return dst;
    }

    public static int[] toInt(byte[] src) {
        int number = src.length;
        int[] dst = new int[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j] & 0xFF;
        }
        return dst;
    }

    public static int[] toInt(short[] src) {
        int number = src.length;
        int[] dst = new int[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static int[] toInt(int[] src) {
        return src;
    }

    public static int[] toInt(long[] src) {
        int number = src.length;
        int[] dst = new int[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (int)src[j];
        }
        return dst;
    }

    public static int[] toInt(float[] src) {
        int number = src.length;
        int[] dst = new int[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (int)src[j];
        }
        return dst;
    }

    public static int[] toInt(double[] src) {
        int number = src.length;
        int[] dst = new int[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (int)src[j];
        }
        return dst;
    }

    public static long[] toLong(byte[] src) {
        int number = src.length;
        long[] dst = new long[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j] & 0xFF;
        }
        return dst;
    }

    public static long[] toLong(short[] src) {
        int number = src.length;
        long[] dst = new long[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static long[] toLong(int[] src) {
        int number = src.length;
        long[] dst = new long[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static long[] toLong(long[] src) {
        return src;
    }

    public static long[] toLong(float[] src) {
        int number = src.length;
        long[] dst = new long[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (long)src[j];
        }
        return dst;
    }

    public static long[] toLong(double[] src) {
        int number = src.length;
        long[] dst = new long[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (long)src[j];
        }
        return dst;
    }

    public static float[] toFloat(byte[] src) {
        int number = src.length;
        float[] dst = new float[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j] & 0xFF;
        }
        return dst;
    }

    public static float[] toFloat(short[] src) {
        int number = src.length;
        float[] dst = new float[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static float[] toFloat(int[] src) {
        int number = src.length;
        float[] dst = new float[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static float[] toFloat(long[] src) {
        int number = src.length;
        float[] dst = new float[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static float[] toFloat(float[] src) {
        return src;
    }

    public static float[] toFloat(double[] src) {
        int number = src.length;
        float[] dst = new float[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (float)src[j];
        }
        return dst;
    }

    public static double[] toDouble(byte[] src) {
        int number = src.length;
        double[] dst = new double[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j] & 0xFF;
        }
        return dst;
    }

    public static double[] toDouble(short[] src) {
        int number = src.length;
        double[] dst = new double[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static double[] toDouble(int[] src) {
        int number = src.length;
        double[] dst = new double[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static double[] toDouble(long[] src) {
        int number = src.length;
        double[] dst = new double[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static double[] toDouble(float[] src) {
        int number = src.length;
        double[] dst = new double[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static double[] toDouble(double[] src) {
        return src;
    }

    public static ShapedArray pad(ShapedArray array, Shape shape) {
        return ArrayUtils.pad(array, shape, null, 0.0);
    }

    public static ShapedArray pad(ShapedArray array, Shape shape, Double value) {
        return ArrayUtils.pad(array, shape, null, value);
    }

    public static ShapedArray pad(ShapedArray array, Shape shape, int[] offset) {
        return ArrayUtils.pad(array, shape, offset, 0.0);
    }

    public static ShapedArray pad(ShapedArray array, Shape shape, int[] offset, double value) {
        Range[] range = ArrayUtils.getROI(shape, array.getShape(), offset);
        if (range == null) {
            return array;
        }
        int rank = range.length;
        int type = array.getType();
        ShapedArray result = ArrayFactory.create(type, shape);
        switch (type) {
            case 0: {
                ((ByteArray)result).fill((byte)value);
                break;
            }
            case 1: {
                ((ShortArray)result).fill((short)value);
                break;
            }
            case 2: {
                ((IntArray)result).fill((int)value);
                break;
            }
            case 3: {
                ((LongArray)result).fill((long)value);
                break;
            }
            case 4: {
                ((FloatArray)result).fill((float)value);
                break;
            }
            case 5: {
                ((DoubleArray)result).fill(value);
                break;
            }
            default: {
                throw new IllegalTypeException();
            }
        }
        switch (rank) {
            case 1: {
                ((Array1D)result).view(range[0]).assign(array);
                break;
            }
            case 2: {
                ((Array2D)result).view(range[0], range[1]).assign(array);
                break;
            }
            case 3: {
                ((Array3D)result).view(range[0], range[1], range[2]).assign(array);
                break;
            }
            case 4: {
                ((Array4D)result).view(range[0], range[1], range[2], range[3]).assign(array);
                break;
            }
            case 5: {
                ((Array5D)result).view(range[0], range[1], range[2], range[3], range[4]).assign(array);
                break;
            }
            case 6: {
                ((Array6D)result).view(range[0], range[1], range[2], range[3], range[4], range[5]).assign(array);
                break;
            }
            case 7: {
                ((Array7D)result).view(range[0], range[1], range[2], range[3], range[4], range[5], range[6]).assign(array);
                break;
            }
            case 8: {
                ((Array8D)result).view(range[0], range[1], range[2], range[3], range[4], range[5], range[6], range[7]).assign(array);
                break;
            }
            case 9: {
                ((Array9D)result).view(range[0], range[1], range[2], range[3], range[4], range[5], range[6], range[7], range[8]).assign(array);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported rank");
            }
        }
        return result;
    }

    public static ShapedArray crop(ShapedArray array, Shape shape) {
        return ArrayUtils.crop(array, shape, null);
    }

    public static ShapedArray crop(ShapedArray array, Shape shape, int[] offset) {
        Range[] range = ArrayUtils.getROI(array.getShape(), shape, offset);
        if (range == null) {
            return array;
        }
        switch (range.length) {
            case 1: {
                return ((Array1D)array).view(range[0]);
            }
            case 2: {
                return ((Array2D)array).view(range[0], range[1]);
            }
            case 3: {
                return ((Array3D)array).view(range[0], range[1], range[2]);
            }
            case 4: {
                return ((Array4D)array).view(range[0], range[1], range[2], range[3]);
            }
            case 5: {
                return ((Array5D)array).view(range[0], range[1], range[2], range[3], range[4]);
            }
            case 6: {
                return ((Array6D)array).view(range[0], range[1], range[2], range[3], range[4], range[5]);
            }
            case 7: {
                return ((Array7D)array).view(range[0], range[1], range[2], range[3], range[4], range[5], range[6]);
            }
            case 8: {
                return ((Array8D)array).view(range[0], range[1], range[2], range[3], range[4], range[5], range[6], range[7]);
            }
            case 9: {
                return ((Array9D)array).view(range[0], range[1], range[2], range[3], range[4], range[5], range[6], range[7], range[8]);
            }
        }
        throw new IllegalArgumentException("Unsupported rank");
    }

    private static Range[] getROI(Shape large, Shape small, int[] offset) {
        int k;
        int smallDim;
        int largeDim;
        int k2;
        int rank = large.rank();
        if (small.rank() != rank) {
            throw new NonConformableArrayException("Not same rank");
        }
        Boolean nothing = true;
        Boolean outOfBounds = false;
        if (offset == null) {
            for (k2 = 0; k2 < rank; ++k2) {
                largeDim = large.dimension(k2);
                smallDim = small.dimension(k2);
                if (smallDim > largeDim) {
                    outOfBounds = true;
                    break;
                }
                if (smallDim == largeDim) continue;
                nothing = false;
            }
        } else {
            if (offset.length != rank) {
                throw new NonConformableArrayException("Bad number of offsets");
            }
            for (k2 = 0; k2 < rank; ++k2) {
                largeDim = large.dimension(k2);
                smallDim = small.dimension(k2);
                if (offset[k2] < 0 || smallDim + offset[k2] > largeDim) {
                    outOfBounds = true;
                    break;
                }
                if (smallDim == largeDim) continue;
                nothing = false;
            }
        }
        if (outOfBounds.booleanValue()) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds region of interest");
        }
        if (nothing.booleanValue()) {
            return null;
        }
        Range[] range = new Range[rank];
        if (offset == null) {
            for (k = 0; k < rank; ++k) {
                int largeDim2 = large.dimension(k);
                int smallDim2 = small.dimension(k);
                int first = largeDim2 / 2 - smallDim2 / 2;
                int last = first + smallDim2 - 1;
                range[k] = new Range(first, last, 1);
            }
        } else {
            for (k = 0; k < rank; ++k) {
                smallDim = small.dimension(k);
                int first = offset[k];
                int last = first + smallDim - 1;
                range[k] = new Range(first, last, 1);
            }
        }
        return range;
    }

    public static ShapedArray extract(ShapedArray array, Shape shape, int[] offset, double value) {
        int rank = shape.rank();
        if (array.getRank() != rank) {
            throw new NonConformableArrayException("Bad number of dimensions for the resized array");
        }
        Range[] srcRange = new Range[rank];
        Range[] dstRange = new Range[rank];
        int ops = 0;
        for (int k = 0; k < rank; ++k) {
            int srcOff;
            int dstDim = shape.dimension(k);
            int srcDim = array.getDimension(k);
            int off = offset == null ? srcDim / 2 - dstDim / 2 : offset[k];
            int dstOff = Math.max(0, -off);
            int len = Math.min(dstDim - dstOff, srcDim - (srcOff = Math.max(0, off)));
            if (len <= 0) {
                ops = 5;
                break;
            }
            if (dstDim != srcDim) {
                ops |= 2;
            }
            if (dstOff > 0 || dstOff + len < dstDim) {
                ops |= 1;
            }
            srcRange[k] = new Range(srcOff, srcOff + len - 1);
            dstRange[k] = new Range(dstOff, dstOff + len - 1);
        }
        if (ops == 0) {
            return array;
        }
        int type = array.getType();
        ShapedArray result = ArrayFactory.create(type, shape);
        if (ops & true) {
            switch (type) {
                case 0: {
                    ((ByteArray)result).fill((byte)value);
                    break;
                }
                case 1: {
                    ((ShortArray)result).fill((short)value);
                    break;
                }
                case 2: {
                    ((IntArray)result).fill((int)value);
                    break;
                }
                case 3: {
                    ((LongArray)result).fill((long)value);
                    break;
                }
                case 4: {
                    ((FloatArray)result).fill((float)value);
                    break;
                }
                case 5: {
                    ((DoubleArray)result).fill(value);
                    break;
                }
                default: {
                    throw new IllegalTypeException();
                }
            }
        }
        if ((ops & 4) == 0) {
            switch (rank) {
                case 1: {
                    ((Array1D)result).view(dstRange[0]).assign(((Array1D)array).view(srcRange[0]));
                    break;
                }
                case 2: {
                    ((Array2D)result).view(dstRange[0], dstRange[1]).assign(((Array2D)array).view(srcRange[0], srcRange[1]));
                    break;
                }
                case 3: {
                    ((Array3D)result).view(dstRange[0], dstRange[1], dstRange[2]).assign(((Array3D)array).view(srcRange[0], srcRange[1], srcRange[2]));
                    break;
                }
                case 4: {
                    ((Array4D)result).view(dstRange[0], dstRange[1], dstRange[2], dstRange[3]).assign(((Array4D)array).view(srcRange[0], srcRange[1], srcRange[2], srcRange[3]));
                    break;
                }
                case 5: {
                    ((Array5D)result).view(dstRange[0], dstRange[1], dstRange[2], dstRange[3], dstRange[4]).assign(((Array5D)array).view(srcRange[0], srcRange[1], srcRange[2], srcRange[3], srcRange[4]));
                    break;
                }
                case 6: {
                    ((Array6D)result).view(dstRange[0], dstRange[1], dstRange[2], dstRange[3], dstRange[4], dstRange[5]).assign(((Array6D)array).view(srcRange[0], srcRange[1], srcRange[2], srcRange[3], srcRange[4], srcRange[5]));
                    break;
                }
                case 7: {
                    ((Array7D)result).view(dstRange[0], dstRange[1], dstRange[2], dstRange[3], dstRange[4], dstRange[5], dstRange[6]).assign(((Array7D)array).view(srcRange[0], srcRange[1], srcRange[2], srcRange[3], srcRange[4], srcRange[5], srcRange[6]));
                    break;
                }
                case 8: {
                    ((Array8D)result).view(dstRange[0], dstRange[1], dstRange[2], dstRange[3], dstRange[4], dstRange[5], dstRange[6], dstRange[7]).assign(((Array8D)array).view(srcRange[0], srcRange[1], srcRange[2], srcRange[3], srcRange[4], srcRange[5], srcRange[6], srcRange[7]));
                    break;
                }
                case 9: {
                    ((Array9D)result).view(dstRange[0], dstRange[1], dstRange[2], dstRange[3], dstRange[4], dstRange[5], dstRange[6], dstRange[7], dstRange[8]).assign(((Array9D)array).view(srcRange[0], srcRange[1], srcRange[2], srcRange[3], srcRange[4], srcRange[5], srcRange[6], srcRange[7], srcRange[8]));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported rank");
                }
            }
        }
        return result;
    }

    public static ShapedArray extract(ShapedArray array, Shape shape, int[] offset) {
        return ArrayUtils.extract(array, shape, offset, 0.0);
    }

    public static ShapedArray extract(ShapedArray array, Shape shape, double value) {
        return ArrayUtils.extract(array, shape, null, value);
    }

    public static ShapedArray extract(ShapedArray array, Shape shape) {
        return ArrayUtils.extract(array, shape, null, 0.0);
    }

    public static ShapedArray roll(ShapedArray arr) {
        Shape shape = arr.getShape();
        int rank = shape.rank();
        int[] off = new int[rank];
        boolean nothing = true;
        for (int k = 0; k < rank; ++k) {
            int dim = shape.dimension(k);
            off[k] = -(dim / 2);
            if (dim == 1) continue;
            nothing = false;
        }
        if (nothing) {
            return arr;
        }
        return ArrayUtils.roll(arr, off);
    }

    public static ShapedArray roll(ShapedArray arr, int[] off) {
        Shape shape = arr.getShape();
        int rank = shape.rank();
        if (off.length != rank) {
            throw new IllegalArgumentException("Range mismatch");
        }
        boolean nothing = true;
        int[][] sel = new int[rank][];
        for (int k = 0; k < rank; ++k) {
            int dim = shape.dimension(k);
            int offset = dim == 1 ? 0 : (dim + off[k] % dim) % dim;
            if (offset != 0) {
                nothing = false;
            }
            int[] index = new int[dim];
            for (int j = 0; j < dim; ++j) {
                index[j] = (j + offset) % dim;
            }
            sel[k] = index;
        }
        if (nothing) {
            return arr;
        }
        switch (rank) {
            case 1: {
                return ((Array1D)arr).view(sel[0]);
            }
            case 2: {
                return ((Array2D)arr).view(sel[0], sel[1]);
            }
            case 3: {
                return ((Array3D)arr).view(sel[0], sel[1], sel[2]);
            }
            case 4: {
                return ((Array4D)arr).view(sel[0], sel[1], sel[2], sel[3]);
            }
            case 5: {
                return ((Array5D)arr).view(sel[0], sel[1], sel[2], sel[3], sel[4]);
            }
            case 6: {
                return ((Array6D)arr).view(sel[0], sel[1], sel[2], sel[3], sel[4], sel[5]);
            }
            case 7: {
                return ((Array7D)arr).view(sel[0], sel[1], sel[2], sel[3], sel[4], sel[5], sel[6]);
            }
            case 8: {
                return ((Array8D)arr).view(sel[0], sel[1], sel[2], sel[3], sel[4], sel[5], sel[6], sel[7]);
            }
            case 9: {
                return ((Array9D)arr).view(sel[0], sel[1], sel[2], sel[3], sel[4], sel[5], sel[6], sel[7], sel[8]);
            }
        }
        throw new IllegalArgumentException("Unsupported rank");
    }
}

