/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.utils;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Plot;
import ij.measure.CurveFitter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArrayUtil {
    private double[] values;
    private int size;
    private boolean sorted;

    public ArrayUtil(int size) {
        this.size = size;
        this.values = new double[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = 0.0;
        }
        this.sorted = false;
    }

    public ArrayUtil(double[] data) {
        this.size = data.length;
        this.sorted = false;
        this.values = data;
    }

    public ArrayUtil(int[] data) {
        this.size = data.length;
        this.sorted = false;
        this.values = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = data[i];
        }
    }

    public static double[] fitGaussian(double[] values, double initSD, int maxR) {
        int cm = 0;
        while (Double.isNaN(values[cm])) {
            ++cm;
        }
        if (cm > 0) {
            maxR -= cm;
            double[] vv = new double[values.length - 2 * cm];
            System.arraycopy(values, 0 + cm, vv, 0, vv.length);
            values = vv;
        }
        double[] id = new double[values.length];
        int c = 0;
        double minVal = values[0];
        double maxVal = values[0];
        for (int i = -maxR; i <= maxR; ++i) {
            double val = values[c];
            if (val > maxVal) {
                maxVal = val;
            }
            if (val < minVal) {
                minVal = val;
            }
            id[c] = i;
            ++c;
        }
        CurveFitter fit = new CurveFitter(id, values);
        double[] params = new double[]{minVal, maxVal, 0.0, initSD};
        fit.setInitialParameters(params);
        fit.setMaxIterations(10000);
        fit.setRestarts(1000);
        fit.doFit(12);
        params = fit.getParams();
        if (Double.isNaN(params[0])) {
            return null;
        }
        return params;
    }

    public static int[] kMeans_Histogram1D(int[] histogram, int nbClasses, int thmin) {
        int[] centers = new int[nbClasses];
        double[] sums = new double[nbClasses];
        double[] nbElements = new double[nbClasses];
        ArrayUtil tab = new ArrayUtil(histogram);
        int start = tab.getLimitInf(0);
        int end = tab.getLimitSup();
        if (thmin > start && thmin < end) {
            start = thmin;
        }
        double step = (end - start) / nbClasses;
        for (int i = 0; i < nbClasses; ++i) {
            centers[i] = (int)((double)start + (double)(i + 1) * step);
        }
        boolean convergence = false;
        int count = 1;
        while (!convergence) {
            IJ.showStatus((String)("K-means " + count));
            ++count;
            convergence = true;
            Arrays.fill(nbElements, 0.0);
            Arrays.fill(sums, 0.0);
            for (int i = thmin; i < histogram.length; ++i) {
                if (histogram[i] == 0) continue;
                int closestClass = 0;
                double minDistance = Double.MAX_VALUE;
                for (int k = 0; k < nbClasses; ++k) {
                    double distance = Math.abs(i - centers[k]);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                    closestClass = k;
                }
                double nbElemInCurrentBin = histogram[i];
                int n = closestClass;
                sums[n] = sums[n] + (double)i * nbElemInCurrentBin;
                int n2 = closestClass;
                nbElements[n2] = nbElements[n2] + nbElemInCurrentBin;
            }
            for (int k = 0; k < nbClasses; ++k) {
                int oldCenter = centers[k];
                int newCenter = (int)(sums[k] / nbElements[k]);
                convergence &= oldCenter == newCenter;
                centers[k] = newCenter;
            }
        }
        return centers;
    }

    public void fromArrayListInt(ArrayList<Integer> arr) {
        this.size = arr.size();
        this.sorted = false;
        this.values = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = arr.get(i).intValue();
        }
    }

    public void fromArrayListDouble(ArrayList<Double> arr) {
        this.size = arr.size();
        this.sorted = false;
        this.values = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = arr.get(i);
        }
    }

    public boolean putValue(int pos, double value) {
        if (pos < this.size) {
            this.values[pos] = value;
            this.sorted = false;
            return true;
        }
        return false;
    }

    public double getValue(int pos) {
        if (pos < this.size) {
            return this.values[pos];
        }
        return Double.NaN;
    }

    public int getValueInt(int pos) {
        if (pos < this.size) {
            return (int)this.values[pos];
        }
        return 0;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size > this.size) {
            double[] temp = new double[size];
            System.arraycopy(this.values, 0, temp, 0, this.size);
            this.values = temp;
        }
        this.size = size;
        this.sorted = false;
    }

    public double[] getArray() {
        return this.values;
    }

    public int[] getArrayInt() {
        int[] res = new int[this.getSize()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (int)this.values[i];
        }
        return res;
    }

    public ArrayList<Double> getArrayList() {
        ArrayList<Double> list = new ArrayList<Double>(this.getSize());
        for (int i = 0; i < this.getSize(); ++i) {
            list.add(this.getValue(i));
        }
        return list;
    }

    public void fillValue(double val) {
        for (int i = 0; i < this.size; ++i) {
            this.putValue(i, val);
        }
        this.sorted = false;
    }

    public void fillRange(int start, int end, int step) {
        int c = 0;
        for (int i = start; i < end; i += step) {
            this.values[c++] = i;
        }
    }

    public double getMaximum() {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.size; ++i) {
            if (Double.isNaN(this.values[i]) || !(this.values[i] > max)) continue;
            max = this.values[i];
        }
        return max;
    }

    public double[] getMaximumAbove(double th) {
        double max = Double.MIN_VALUE;
        double maxIdx = -1.0;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.values[i] > max) || !(this.values[i] > th)) continue;
            max = this.values[i];
            maxIdx = i;
        }
        return new double[]{max, maxIdx};
    }

    public double[] getMaximumStarting(int th) {
        double max = Double.NEGATIVE_INFINITY;
        double maxIdx = -1.0;
        for (int i = th; i < this.size; ++i) {
            if (Double.isNaN(this.values[i]) || !(this.values[i] > max)) continue;
            max = this.values[i];
            maxIdx = i;
        }
        return new double[]{max, maxIdx};
    }

    public int getMaximumIndex() {
        double max = this.values[0];
        int imax = 0;
        for (int i = 1; i < this.size; ++i) {
            if (!(this.values[i] > max)) continue;
            max = this.values[i];
            imax = i;
        }
        return imax;
    }

    public int getFirstLocalMaxima(int start, double threshold) {
        int st = start;
        if (st <= 0) {
            st = 1;
        }
        for (int i = st; i < this.size - 1; ++i) {
            if (!(this.values[i] >= threshold)) continue;
            double v0 = this.values[i - 1];
            double v1 = this.values[i];
            double v2 = this.values[i + 1];
            if (!(v1 >= v0) || !(v1 >= v2)) continue;
            return i;
        }
        return -1;
    }

    public int getFirstLocalMinima(double threshold) {
        for (int i = 1; i < this.size - 1; ++i) {
            if (!(this.values[i] <= threshold)) continue;
            double v0 = this.values[i - 1];
            double v1 = this.values[i];
            double v2 = this.values[i + 1];
            if (!(v1 <= v0) || !(v1 <= v2)) continue;
            return i;
        }
        return -1;
    }

    public int getFirstLocalExtrema(double thresholdMax, double thresholdMin) {
        for (int i = 1; i < this.size - 1; ++i) {
            double v2;
            double v1;
            double v0;
            if (this.values[i] >= thresholdMax) {
                v0 = this.values[i - 1];
                v1 = this.values[i];
                v2 = this.values[i + 1];
                if (v1 >= v0 && v1 >= v2) {
                    return i;
                }
            }
            if (!(this.values[i] <= thresholdMin)) continue;
            v0 = this.values[i - 1];
            v1 = this.values[i];
            v2 = this.values[i + 1];
            if (!(v1 <= v0) || !(v1 <= v2)) continue;
            return i;
        }
        return -1;
    }

    public boolean isMaximum(double val) {
        int i;
        boolean maxok = true;
        for (i = 0; i < this.size && this.values[i] <= val; ++i) {
        }
        if (i < this.size) {
            maxok = false;
        }
        return maxok;
    }

    public double getMaximumBelow(double th) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.values[i] > max) || !(this.values[i] < th)) continue;
            max = this.values[i];
        }
        return max;
    }

    public int getLimitSup() {
        int i;
        for (i = this.size - 1; i >= 0 && this.values[i] == 0.0; --i) {
        }
        return i;
    }

    public int getLimitInf(int th) {
        int i;
        for (i = th; i < this.size && this.values[i] == 0.0; ++i) {
        }
        return i;
    }

    public double getMinimum() {
        double min = this.values[0];
        for (int i = 1; i < this.size; ++i) {
            if (!(this.values[i] < min)) continue;
            min = this.values[i];
        }
        return min;
    }

    public int getMinimumIndex() {
        double min = this.values[0];
        int imin = 0;
        for (int i = 1; i < this.size; ++i) {
            if (!(this.values[i] < min)) continue;
            min = this.values[i];
            imin = i;
        }
        return imin;
    }

    public double[] getMinMax() {
        double min = this.values[0];
        double max = this.values[0];
        for (int i = 1; i < this.size; ++i) {
            if (this.values[i] < min) {
                min = this.values[i];
            }
            if (!(this.values[i] > max)) continue;
            max = this.values[i];
        }
        return new double[]{min, max};
    }

    public double getMinimumAbove(double th) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.values[i] > th) || !(this.values[i] < min)) continue;
            min = this.values[i];
        }
        if (min < Double.MAX_VALUE) {
            return min;
        }
        return th;
    }

    public double getMean() {
        double total = 0.0;
        for (int i = 0; i < this.size; ++i) {
            total += this.values[i];
        }
        return total / (double)this.size;
    }

    public double getSum() {
        double total = 0.0;
        for (int i = 0; i < this.size; ++i) {
            total += this.values[i];
        }
        return total;
    }

    public double getStdDev() {
        double var = this.getVariance();
        return Math.sqrt(var);
    }

    public double getSkewness() {
        double mu = this.getMean();
        double si = this.getStdDev();
        double total = 0.0;
        for (int i = 0; i < this.size; ++i) {
            double diff = (this.values[i] - mu) / si;
            total += diff * diff * diff;
        }
        if (this.size > 1) {
            double fsize = this.size;
            total *= fsize / ((fsize - 1.0) * (fsize - 2.0));
        } else {
            total = 0.0;
        }
        return total;
    }

    public double getKurtosis() {
        double mu = this.getMean();
        double var = this.getVariance();
        double total = 0.0;
        for (int i = 0; i < this.size; ++i) {
            double diff = this.values[i] - mu;
            total += diff * diff * diff * diff;
        }
        if (this.size > 1) {
            double fsize = this.size;
            total *= fsize * (fsize + 1.0) / ((fsize - 1.0) * (fsize - 2.0) * (fsize - 3.0) * var * var);
            total -= 3.0 * (fsize - 1.0) * (fsize - 1.0) / ((fsize - 2.0) * (fsize - 3.0));
        } else {
            total = 0.0;
        }
        return total;
    }

    public double getVariance() {
        if (this.size == 1) {
            return 0.0;
        }
        double mean = this.getMean();
        double total = 0.0;
        for (int i = 0; i < this.size; ++i) {
            total += (this.values[i] - mean) * (this.values[i] - mean);
        }
        total = this.size > 1 ? (total /= (double)(this.size - 1)) : 0.0;
        return total;
    }

    public double getVariance2() {
        if (this.size == 1) {
            return 0.0;
        }
        double total = 0.0;
        double total2 = 0.0;
        for (int i = 0; i < this.size; ++i) {
            total += this.values[i];
            total2 += this.values[i] * this.values[i];
        }
        return (total2 - total * total / (double)this.size) / (double)(this.size - 1);
    }

    public double getMaxAbsDifference(ArrayUtil hmean) {
        double diffmax = 0.0;
        for (int b = 0; b < this.size; ++b) {
            double diff = Math.abs(this.values[b] - hmean.getValue(b));
            if (!(diff > diffmax)) continue;
            diffmax = diff;
        }
        return diffmax;
    }

    public int countValue(double val) {
        int c = 0;
        for (int b = 0; b < this.size; ++b) {
            if (this.values[b] != val) continue;
            ++c;
        }
        return c;
    }

    public int countValueAbove(double val) {
        int c = 0;
        for (int b = 0; b < this.size; ++b) {
            if (!(this.values[b] > val)) continue;
            ++c;
        }
        return c;
    }

    public ArrayUtil distinctValues() {
        this.sort();
        ArrayUtil V = new ArrayUtil(this.getSize());
        int s = 0;
        double tmp = this.getValue(0);
        V.addValue(0, tmp);
        ++s;
        int p = 1;
        int si = this.getSize();
        while (p < si) {
            while (p < si && this.getValue(p) == tmp) {
                ++p;
            }
            if (p >= si) continue;
            tmp = this.getValue(p);
            V.addValue(s, tmp);
            ++s;
            ++p;
        }
        return V.getSubTabUtil(0, s);
    }

    public ArrayUtil localMean(int rad) {
        ArrayUtil tab2 = new ArrayUtil(this.size);
        for (int i = 0; i < this.size; ++i) {
            if (i > rad && i < this.size - rad) {
                int total = 0;
                int nombre = 0;
                for (int j = i - rad; j <= i + rad; ++j) {
                    total = (int)((double)total + this.values[j]);
                    ++nombre;
                }
                tab2.putValue(i, total / nombre);
                continue;
            }
            tab2.putValue(i, this.values[i]);
        }
        return tab2;
    }

    public boolean addValue(int position, double value) {
        if (position < this.size) {
            int n = position;
            this.values[n] = this.values[n] + value;
            this.sorted = false;
            return true;
        }
        return false;
    }

    public void divideAll(double value) {
        int i = 0;
        while (i < this.size) {
            int n = i++;
            this.values[n] = this.values[n] / value;
        }
        if (value < 0.0) {
            this.sorted = false;
        }
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void sortJava() {
        if (this.size < this.values.length) {
            double[] tosort = new double[this.size];
            System.arraycopy(this.values, 0, tosort, 0, this.size);
            Arrays.sort(tosort);
            System.arraycopy(tosort, 0, this.values, 0, this.size);
        } else {
            Arrays.sort(this.values);
        }
        this.sorted = true;
    }

    public void sort() {
        this.sortJava();
    }

    public void sortShellMeitzner() {
        for (int ecart = this.size / 2; ecart > 0; ecart /= 2) {
            int i = 0;
            int pos_mem = 0;
            while (i < this.size - ecart) {
                if (this.values[i] > this.values[i + ecart]) {
                    double aux = this.values[i];
                    this.values[i] = this.values[i + ecart];
                    this.values[i + ecart] = aux;
                    if (i - ecart >= 0) {
                        i -= ecart;
                        continue;
                    }
                    i = ++pos_mem;
                    continue;
                }
                i = ++pos_mem;
            }
        }
        this.sorted = true;
    }

    public int[] sortIndexShellMeitzner() {
        int[] td = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            td[i] = i;
        }
        for (int ecart = this.size / 2; ecart > 0; ecart /= 2) {
            int i = 0;
            int pos_mem = 0;
            while (i < this.size - ecart) {
                if (this.values[td[i]] > this.values[td[i + ecart]]) {
                    int aux = td[i];
                    td[i] = td[i + ecart];
                    td[i + ecart] = aux;
                    if (i - ecart >= 0) {
                        i -= ecart;
                        continue;
                    }
                    i = ++pos_mem;
                    continue;
                }
                i = ++pos_mem;
            }
        }
        return td;
    }

    public double medianSort() {
        if (!this.sorted) {
            this.sort();
        }
        if (this.size % 2 == 1) {
            return this.values[this.size / 2];
        }
        return 0.5 * (this.values[this.size / 2 - 1] + this.values[this.size / 2]);
    }

    public double median() {
        int nValues = this.size;
        int nv1b2 = (nValues - 1) / 2;
        int l = 0;
        int m = nValues - 1;
        double med = this.values[nv1b2];
        while (l < m) {
            int i = l;
            int j = m;
            while (true) {
                if (this.values[i] < med) {
                    ++i;
                    continue;
                }
                while (med < this.values[j]) {
                    --j;
                }
                double dum = this.values[j];
                this.values[j] = this.values[i];
                this.values[i] = dum;
                if (--j < nv1b2 || ++i > nv1b2) break;
            }
            if (j < nv1b2) {
                l = i;
            }
            if (nv1b2 < i) {
                m = j;
            }
            med = this.values[nv1b2];
        }
        return med;
    }

    public double convolve(double[] kernel, double D) {
        if (this.size != kernel.length) {
            return -1.0;
        }
        double sum = 0.0;
        for (int i = 0; i < this.size; ++i) {
            sum += this.values[i] * kernel[i];
        }
        return sum /= D;
    }

    public int indexOf(double value) {
        int i;
        for (i = 0; i < this.size && this.values[i] != value; ++i) {
        }
        if (i == this.size) {
            i = -1;
        }
        return i;
    }

    public int indexOfSumPercent(double percent) {
        int i;
        int total = 0;
        int sum = 0;
        for (i = 0; i < this.size; ++i) {
            total = (int)((double)total + this.values[i]);
        }
        for (i = 0; i < this.size; ++i) {
            if (!((double)(sum = (int)((double)sum + this.values[i])) >= percent * (double)total)) continue;
            return i > 0 ? i - 1 : 0;
        }
        return this.size - 1;
    }

    public boolean hasValue(int val) {
        boolean in = false;
        for (int i = 0; !in && i < this.size; ++i) {
            if (this.values[i] != (double)val) continue;
            in = true;
        }
        return in;
    }

    public boolean hasOneValue(ArrayList vals) {
        boolean in = false;
        for (int i = 0; !in && i < this.size; ++i) {
            if (!vals.contains(this.values[i])) continue;
            in = true;
        }
        return in;
    }

    public boolean hasOneValueInt(ArrayList vals) {
        boolean in = false;
        for (int i = 0; !in && i < this.size; ++i) {
            if (!vals.contains((int)this.values[i])) continue;
            in = true;
        }
        return in;
    }

    public boolean hasOnlyValue(int val) {
        for (int i = 0; i < this.size; ++i) {
            if (this.values[i] == (double)val) continue;
            return false;
        }
        return true;
    }

    public boolean hasOnlyValuesInt(ArrayList vals) {
        for (int i = 0; i < this.size; ++i) {
            if (vals.contains((int)this.values[i])) continue;
            return false;
        }
        return true;
    }

    public int IsoData() {
        int sup = this.getLimitSup();
        int m1 = sup / 2;
        int m0 = 0;
        int nb = 0;
        boolean debug = false;
        while (Math.abs(m0 - m1) > 2 && nb < this.size) {
            int i;
            ++nb;
            m0 = m1;
            double md = 0.0;
            double nombre_pixels = 0.0;
            if (debug) {
                IJ.log((String)("size=" + this.size + " m0=" + m0));
            }
            for (i = 0; i < m0; ++i) {
                nombre_pixels += this.values[i];
                md += this.values[i] * (double)i;
            }
            if (debug) {
                IJ.log((String)("md=" + md + " nb=" + nombre_pixels));
            }
            md /= nombre_pixels;
            double mg = 0.0;
            nombre_pixels = 0.0;
            for (i = m0; i <= sup; ++i) {
                nombre_pixels += this.values[i];
                mg += this.values[i] * (double)i;
            }
            if (debug) {
                IJ.log((String)("mg=" + mg + " nb=" + nombre_pixels));
            }
            m1 = (int)((md + (mg /= nombre_pixels)) / 2.0);
            if (!debug) continue;
            IJ.log((String)("m0=" + m0 + " m1=" + m1));
        }
        if (nb == this.size && debug) {
            System.out.println("Pb convergence moyenne intermediaire");
        }
        return m1;
    }

    public ImagePlus drawBar(int scale) {
        int haut = 256;
        double max = this.getMaximum();
        ByteProcessor ip = new ByteProcessor(this.size, haut);
        ip.setColor(255);
        for (int i = 0; i < this.size; ++i) {
            ip.moveTo(i, haut - 1);
            double val = scale == -1 ? (double)haut * this.values[i] / max : (this.values[i] > (double)scale ? (double)(haut - 1) : (double)haut * this.values[i] / (double)scale);
            ip.lineTo(i, (int)((double)haut - val));
        }
        return new ImagePlus("tab", (ImageProcessor)ip);
    }

    public void shuffle() {
        this.sorted = false;
        for (int i = 0; i < this.size - 1; ++i) {
            int pos = (int)Math.round(Math.random() * (double)(this.size - 1 - i) + (double)i);
            double aux = this.values[i];
            this.values[i] = this.values[pos];
            this.values[pos] = aux;
        }
    }

    public void setValues(ArrayUtil tmp) {
        if (tmp.getSize() > this.values.length) {
            this.values = new double[tmp.getSize()];
        }
        this.setSize(tmp.getSize());
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = tmp.getValue(i);
        }
        this.sorted = false;
    }

    public void insertValues(int pos, ArrayUtil tmp) {
        if (tmp.getSize() + pos > this.values.length) {
            double[] values2 = new double[tmp.getSize() + pos];
            System.arraycopy(this.values, 0, values2, 0, pos);
            this.values = values2;
            this.size = this.values.length;
        }
        System.arraycopy(tmp.getArray(), 0, this.values, pos, tmp.getSize());
        this.size = Math.max(this.size, pos + tmp.getSize());
        this.sorted = false;
    }

    public boolean isEqual(ArrayUtil other) {
        if (other.getSize() != this.getSize()) {
            return false;
        }
        return this.isEqual(other, 0, this.getSize() - 1);
    }

    public boolean isEqual(ArrayUtil other, int begin, int end) {
        boolean result = true;
        for (int i = begin; i <= end; ++i) {
            if (this.values[i] == other.values[i]) continue;
            result = false;
        }
        return result;
    }

    public ArrayUtil getCopy() {
        ArrayUtil result = new ArrayUtil(this.size);
        System.arraycopy(this.values, 0, result.values, 0, this.size);
        return result;
    }

    public String toString() {
        String str = "{" + this.values[0];
        for (int i = 1; i < this.size; ++i) {
            str = str + ", " + this.values[i];
        }
        return str + "}";
    }

    public void removeValueAt(int index) {
        --this.size;
        System.arraycopy(this.values, index + 1, this.values, index, this.size - index);
    }

    public int removeValues(double val) {
        int remove = 0;
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.values[i] != val) continue;
            this.removeValueAt(i);
            ++remove;
        }
        return remove;
    }

    public void addValueArray(ArrayUtil tabToAdd) {
        if (this.size != tabToAdd.size) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            int n = i;
            this.values[n] = this.values[n] + tabToAdd.values[i];
        }
        this.sorted = false;
    }

    public Plot getPlot() {
        return this.getPlot("Plot", "x", "y");
    }

    public Plot getPlot(String title, String xLabel, String yLabel) {
        double[] xVal = new double[this.size];
        for (int i = 0; i < xVal.length; ++i) {
            xVal[i] = i;
        }
        Plot plot = new Plot(title, xLabel, yLabel, xVal, this.values);
        plot.draw();
        return plot;
    }

    public void concat(ArrayUtil tabToAdd) {
        int newsize = this.size + tabToAdd.size;
        double[] tmp = new double[newsize];
        System.arraycopy(this.values, 0, tmp, 0, this.size);
        System.arraycopy(tabToAdd.values, 0, tmp, this.size, tabToAdd.size);
        this.values = tmp;
        this.size = newsize;
        this.sorted = false;
    }

    public void reverse() {
        for (int i = 0; i < this.size / 2; ++i) {
            double tmp = this.values[i];
            this.values[i] = this.values[this.size - 1 - i];
            this.values[this.size - 1 - i] = tmp;
        }
    }

    public ArrayUtil getSubTabUtil(int startIndex, int newSize) {
        ArrayUtil tmp = new ArrayUtil(newSize);
        int i = 0;
        while (i < newSize) {
            tmp.putValue(i, this.getValue(startIndex));
            ++i;
            ++startIndex;
        }
        return tmp;
    }

    public ArrayUtil getDifferenceNext() {
        ArrayUtil diff = new ArrayUtil(this.getSize() - 1);
        for (int i = 0; i < diff.getSize(); ++i) {
            diff.putValue(i, this.getValue(i + 1) - this.getValue(i));
        }
        return diff;
    }

    public ArrayUtil getDifferenceNextAbs() {
        ArrayUtil diff = new ArrayUtil(this.getSize() - 1);
        for (int i = 0; i < diff.getSize(); ++i) {
            diff.putValue(i, Math.abs(this.getValue(i + 1) - this.getValue(i)));
        }
        return diff;
    }

    public ArrayUtil[] getHistogram(int nBins) {
        int i;
        double[] res = new double[nBins];
        double[] xx = new double[nBins];
        double minimum = this.getMinimum();
        double maximum = this.getMaximum();
        double step = (maximum - minimum + 1.0) / (double)nBins;
        double iStep = 1.0 / step;
        for (i = 0; i < nBins; ++i) {
            xx[i] = minimum + (double)i * step;
        }
        for (i = 0; i < this.getSize(); ++i) {
            int pos = (int)Math.floor((this.getValue(i) - minimum) * iStep);
            if (pos >= nBins) {
                pos = nBins - 1;
            } else if (pos < 0) {
                pos = 0;
            }
            int n = pos;
            res[n] = res[n] + 1.0;
        }
        ArrayUtil[] tab = new ArrayUtil[]{new ArrayUtil(xx), new ArrayUtil(res)};
        return tab;
    }

    public ArrayUtil getIntegerHistogram() {
        int i;
        int max = (int)this.getMaximum();
        if (max < 0) {
            return null;
        }
        double[] yNumber = new double[max + 1];
        int nBins = yNumber.length;
        int si = this.getSize();
        for (i = 0; i < nBins; ++i) {
            yNumber[i] = 0.0;
        }
        for (i = 0; i < si; ++i) {
            double val = this.getValue(i);
            if (Double.isNaN(val)) continue;
            int bi = (int)val;
            if (bi >= nBins) {
                bi = nBins - 1;
            }
            if (bi < 0) {
                bi = 0;
            }
            int n = bi;
            yNumber[n] = yNumber[n] + 1.0;
        }
        return new ArrayUtil(yNumber);
    }

    public int getMode() {
        ArrayUtil hist = this.getIntegerHistogram();
        if (hist == null) {
            return -1;
        }
        return hist.getMaximumIndex();
    }

    public int getModeNonZero() {
        ArrayUtil hist = this.getIntegerHistogram();
        if (hist == null) {
            return -1;
        }
        return (int)this.getIntegerHistogram().getMaximumStarting(1)[1];
    }

    public void saveArray(String dir, String file, String header) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(dir + file));
            out.write("idx\t" + header);
            for (int i = 0; i < this.size; ++i) {
                out.write("\n" + i + "\t" + this.values[i]);
            }
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ArrayUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

