/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CommandListener;
import ij.Executer;
import ij.IJ;
import ij.IJEventListener;
import ij.ImageListener;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.gui.RoiListener;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;

public class EventListener
implements PlugIn,
IJEventListener,
ImageListener,
RoiListener,
CommandListener {
    @Override
    public void run(String arg) {
        IJ.addEventListener(this);
        Executer.addCommandListener(this);
        ImagePlus.addImageListener(this);
        Roi.addRoiListener(this);
        IJ.log("EventListener started");
    }

    @Override
    public void eventOccurred(int eventID) {
        switch (eventID) {
            case 0: {
                String c = Integer.toHexString(Toolbar.getForegroundColor().getRGB());
                c = "#" + c.substring(2);
                IJ.log("Changed foreground color to " + c);
                break;
            }
            case 1: {
                String c = Integer.toHexString(Toolbar.getBackgroundColor().getRGB());
                c = "#" + c.substring(2);
                IJ.log("Changed background color to " + c);
                break;
            }
            case 4: {
                String name = IJ.getToolName();
                IJ.log("Switched to the " + name + (name.endsWith("Tool") ? "" : " tool"));
                break;
            }
            case 2: {
                IJ.log("Color picker closed");
                break;
            }
            case 3: {
                IJ.removeEventListener(this);
                Executer.removeCommandListener(this);
                ImagePlus.removeImageListener(this);
                Roi.removeRoiListener(this);
                IJ.showStatus("Log window closed; EventListener stopped");
            }
        }
    }

    @Override
    public void imageOpened(ImagePlus imp) {
        IJ.log("Opened \"" + imp.getTitle() + "\"");
    }

    @Override
    public void imageClosed(ImagePlus imp) {
        IJ.log("Closed \"" + imp.getTitle() + "\"");
    }

    @Override
    public void imageUpdated(ImagePlus imp) {
        IJ.log("Updated \"" + imp.getTitle() + "\"");
    }

    @Override
    public String commandExecuting(String command) {
        IJ.log("Executed \"" + command + "\" command");
        return command;
    }

    @Override
    public void roiModified(ImagePlus img, int id) {
        String type = "UNKNOWN";
        switch (id) {
            case 1: {
                type = "CREATED";
                break;
            }
            case 2: {
                type = "MOVED";
                break;
            }
            case 3: {
                type = "MODIFIED";
                break;
            }
            case 4: {
                type = "EXTENDED";
                break;
            }
            case 5: {
                type = "COMPLETED";
                break;
            }
            case 6: {
                type = "DELETED";
            }
        }
        IJ.log("ROI Modified: " + (img != null ? img.getTitle() : "") + ", " + type);
    }
}

