/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tboolean;

import cern.colt.PersistentObject;
import cern.colt.buffer.tboolean.BooleanBuffer3DConsumer;
import cern.colt.list.tboolean.BooleanArrayList;

public class BooleanBuffer3D
extends PersistentObject
implements BooleanBuffer3DConsumer {
    private static final long serialVersionUID = 1L;
    protected BooleanBuffer3DConsumer target;
    protected boolean[] xElements;
    protected boolean[] yElements;
    protected boolean[] zElements;
    protected BooleanArrayList xList;
    protected BooleanArrayList yList;
    protected BooleanArrayList zList;
    protected int capacity;
    protected int size;

    public BooleanBuffer3D(BooleanBuffer3DConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.xElements = new boolean[capacity];
        this.yElements = new boolean[capacity];
        this.zElements = new boolean[capacity];
        this.xList = new BooleanArrayList(this.xElements);
        this.yList = new BooleanArrayList(this.yElements);
        this.zList = new BooleanArrayList(this.zElements);
        this.size = 0;
    }

    public void add(boolean x, boolean y, boolean z) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = x;
        this.yElements[this.size] = y;
        this.zElements[this.size++] = z;
    }

    @Override
    public void addAllOf(BooleanArrayList xElements, BooleanArrayList yElements, BooleanArrayList zElements) {
        int listSize = xElements.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(xElements, yElements, zElements);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

