/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.io;

import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.VectorInfo;
import cern.colt.matrix.io.VectorSize;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.LinkedList;

public class MatrixVectorReader
extends BufferedReader {
    private StreamTokenizer st;

    public MatrixVectorReader(Reader in) {
        super(in);
        this.setup();
    }

    public MatrixVectorReader(Reader in, int sz) {
        super(in, sz);
        this.setup();
    }

    private void setup() {
        this.st = new StreamTokenizer(this);
        this.st.resetSyntax();
        this.st.eolIsSignificant(false);
        this.st.lowerCaseMode(true);
        this.st.wordChars(48, 57);
        this.st.wordChars(45, 46);
        this.st.wordChars(0, 255);
        this.st.commentChar(37);
        this.st.whitespaceChars(32, 32);
        this.st.whitespaceChars(9, 14);
    }

    public void add(int num, int[] indexes) {
        int i = 0;
        while (i < indexes.length) {
            int n = i++;
            indexes[n] = indexes[n] + num;
        }
    }

    private String readTrimmedLine() throws IOException {
        String line = this.readLine();
        if (line != null) {
            return line.trim();
        }
        throw new EOFException();
    }

    public MatrixInfo readMatrixInfo() throws IOException {
        String[] component = this.readTrimmedLine().split(" +");
        if (component.length != 5) {
            throw new IOException("Current line unparsable. It must consist of 5 tokens");
        }
        if (!component[0].equalsIgnoreCase("%%MatrixMarket")) {
            throw new IOException("Not in Matrix Market exchange format");
        }
        if (!component[1].equalsIgnoreCase("matrix")) {
            throw new IOException("Expected \"matrix\", got " + component[1]);
        }
        boolean sparse = false;
        if (component[2].equalsIgnoreCase("coordinate")) {
            sparse = true;
        } else if (component[2].equalsIgnoreCase("array")) {
            sparse = false;
        } else {
            throw new IOException("Unknown layout " + component[2]);
        }
        MatrixInfo.MatrixField field = null;
        if (component[3].equalsIgnoreCase("real")) {
            field = MatrixInfo.MatrixField.Real;
        } else if (component[3].equalsIgnoreCase("integer")) {
            field = MatrixInfo.MatrixField.Integer;
        } else if (component[3].equalsIgnoreCase("complex")) {
            field = MatrixInfo.MatrixField.Complex;
        } else if (component[3].equalsIgnoreCase("pattern")) {
            field = MatrixInfo.MatrixField.Pattern;
        } else {
            throw new IOException("Unknown field specification " + component[3]);
        }
        MatrixInfo.MatrixSymmetry symmetry = null;
        if (component[4].equalsIgnoreCase("general")) {
            symmetry = MatrixInfo.MatrixSymmetry.General;
        } else if (component[4].equalsIgnoreCase("symmetric")) {
            symmetry = MatrixInfo.MatrixSymmetry.Symmetric;
        } else if (component[4].equalsIgnoreCase("skew-symmetric")) {
            symmetry = MatrixInfo.MatrixSymmetry.SkewSymmetric;
        } else if (component[4].equalsIgnoreCase("Hermitian")) {
            symmetry = MatrixInfo.MatrixSymmetry.Hermitian;
        } else {
            throw new IOException("Unknown symmetry specification " + component[4]);
        }
        return new MatrixInfo(sparse, field, symmetry);
    }

    public VectorInfo readVectorInfo() throws IOException {
        String[] component = this.readTrimmedLine().split(" +");
        if (component.length != 4) {
            throw new IOException("Current line unparsable. It must consist of 4 tokens");
        }
        if (!component[0].equalsIgnoreCase("%%MatrixMarket")) {
            throw new IOException("Not in Matrix Market exchange format");
        }
        if (!component[1].equalsIgnoreCase("vector")) {
            throw new IOException("Expected \"vector\", got " + component[1]);
        }
        boolean sparse = false;
        if (component[2].equalsIgnoreCase("coordinate")) {
            sparse = true;
        } else if (component[2].equalsIgnoreCase("array")) {
            sparse = false;
        } else {
            throw new IOException("Unknown layout " + component[2]);
        }
        VectorInfo.VectorField field = null;
        if (component[3].equalsIgnoreCase("real")) {
            field = VectorInfo.VectorField.Real;
        } else if (component[3].equalsIgnoreCase("integer")) {
            field = VectorInfo.VectorField.Integer;
        } else if (component[3].equalsIgnoreCase("complex")) {
            field = VectorInfo.VectorField.Complex;
        } else if (component[3].equalsIgnoreCase("pattern")) {
            field = VectorInfo.VectorField.Pattern;
        } else {
            throw new IOException("Unknown field specification " + component[3]);
        }
        return new VectorInfo(sparse, field);
    }

    public boolean hasInfo() throws IOException {
        this.mark(1024);
        String[] component = this.readTrimmedLine().split(" +");
        this.reset();
        return component[0].equalsIgnoreCase("%%MatrixMarket");
    }

    public String[] readComments() throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        while (true) {
            this.mark(1024);
            String line = this.readTrimmedLine();
            if (line.length() <= 0) continue;
            if (line.charAt(0) != '%') break;
            list.add(line.substring(1));
        }
        this.reset();
        return list.toArray(new String[list.size()]);
    }

    public MatrixSize readMatrixSize(MatrixInfo info) throws IOException {
        int numRows = this.getInt();
        int numColumns = this.getInt();
        if (info.isDense()) {
            return new MatrixSize(numRows, numColumns, info);
        }
        int numEntries = this.getInt();
        return new MatrixSize(numRows, numColumns, numEntries);
    }

    public MatrixSize readArraySize() throws IOException {
        int numRows = this.getInt();
        int numColumns = this.getInt();
        return new MatrixSize(numRows, numColumns, numRows * numColumns);
    }

    public MatrixSize readCoordinateSize() throws IOException {
        int numRows = this.getInt();
        int numColumns = this.getInt();
        int numEntries = this.getInt();
        return new MatrixSize(numRows, numColumns, numEntries);
    }

    public VectorSize readVectorSize(VectorInfo info) throws IOException {
        int size = this.getInt();
        if (info.isDense()) {
            return new VectorSize(size);
        }
        int numEntries = this.getInt();
        return new VectorSize(size, numEntries);
    }

    public VectorSize readVectorArraySize() throws IOException {
        int size = this.getInt();
        return new VectorSize(size);
    }

    public VectorSize readVectorCoordinateSize() throws IOException {
        int size = this.getInt();
        int numEntries = this.getInt();
        return new VectorSize(size, numEntries);
    }

    public void readArray(double[] data) throws IOException {
        int size = data.length;
        int i = 0;
        while (i < size) {
            data[i] = this.getDouble();
            ++i;
        }
    }

    public void readArray(float[] data) throws IOException {
        int size = data.length;
        int i = 0;
        while (i < size) {
            data[i] = this.getFloat();
            ++i;
        }
    }

    public void readArray(int[] data) throws IOException {
        int size = data.length;
        int i = 0;
        while (i < size) {
            data[i] = this.getInt();
            ++i;
        }
    }

    public void readArray(long[] data) throws IOException {
        int size = data.length;
        int i = 0;
        while (i < size) {
            data[i] = this.getLong();
            ++i;
        }
    }

    public void readArray(double[] dataR, double[] dataI) throws IOException {
        int size = dataR.length;
        if (size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            dataR[i] = this.getDouble();
            dataI[i] = this.getDouble();
            ++i;
        }
    }

    public void readArray(float[] dataR, float[] dataI) throws IOException {
        int size = dataR.length;
        if (size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            dataR[i] = this.getFloat();
            dataI[i] = this.getFloat();
            ++i;
        }
    }

    public void readCoordinate(int[] index, double[] data) throws IOException {
        int size = index.length;
        if (size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            index[i] = this.getInt() - 1;
            data[i] = this.getDouble();
            ++i;
        }
    }

    public void readCoordinate(int[] index, float[] data) throws IOException {
        int size = index.length;
        if (size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            index[i] = this.getInt() - 1;
            data[i] = this.getFloat();
            ++i;
        }
    }

    public void readCoordinate(int[] index, int[] data) throws IOException {
        int size = index.length;
        if (size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            index[i] = this.getInt() - 1;
            data[i] = this.getInt();
            ++i;
        }
    }

    public void readCoordinate(int[] index, long[] data) throws IOException {
        int size = index.length;
        if (size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            index[i] = this.getInt() - 1;
            data[i] = this.getLong();
            ++i;
        }
    }

    public void readCoordinate(int[] index, float[] dataR, float[] dataI) throws IOException {
        int size = index.length;
        if (size != dataR.length || size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            index[i] = this.getInt() - 1;
            dataR[i] = this.getFloat();
            dataI[i] = this.getFloat();
            ++i;
        }
    }

    public void readCoordinate(int[] index, double[] dataR, double[] dataI) throws IOException {
        int size = index.length;
        if (size != dataR.length || size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            index[i] = this.getInt() - 1;
            dataR[i] = this.getDouble();
            dataI[i] = this.getDouble();
            ++i;
        }
    }

    public void readPattern(int[] index) throws IOException {
        int size = index.length;
        int i = 0;
        while (i < size) {
            index[i] = this.getInt() - 1;
            ++i;
        }
    }

    public void readCoordinate(int[] row, int[] column, double[] data) throws IOException {
        int size = row.length;
        if (size != column.length || size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            row[i] = this.getInt() - 1;
            column[i] = this.getInt() - 1;
            data[i] = this.getDouble();
            ++i;
        }
    }

    public void readCoordinate(int[] row, int[] column, float[] data) throws IOException {
        int size = row.length;
        if (size != column.length || size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            row[i] = this.getInt() - 1;
            column[i] = this.getInt() - 1;
            data[i] = this.getFloat();
            ++i;
        }
    }

    public void readCoordinate(int[] row, int[] column, int[] data) throws IOException {
        int size = row.length;
        if (size != column.length || size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            row[i] = this.getInt() - 1;
            column[i] = this.getInt() - 1;
            data[i] = this.getInt();
            ++i;
        }
    }

    public void readCoordinate(int[] row, int[] column, long[] data) throws IOException {
        int size = row.length;
        if (size != column.length || size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            row[i] = this.getInt() - 1;
            column[i] = this.getInt() - 1;
            data[i] = this.getLong();
            ++i;
        }
    }

    public void readPattern(int[] row, int[] column) throws IOException {
        int size = row.length;
        if (size != column.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            row[i] = this.getInt() - 1;
            column[i] = this.getInt() - 1;
            ++i;
        }
    }

    public void readCoordinate(int[] row, int[] column, double[] dataR, double[] dataI) throws IOException {
        int size = row.length;
        if (size != column.length || size != dataR.length || size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            row[i] = this.getInt() - 1;
            column[i] = this.getInt() - 1;
            dataR[i] = this.getDouble();
            dataI[i] = this.getDouble();
            ++i;
        }
    }

    public void readCoordinate(int[] row, int[] column, float[] dataR, float[] dataI) throws IOException {
        int size = row.length;
        if (size != column.length || size != dataR.length || size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            row[i] = this.getInt() - 1;
            column[i] = this.getInt() - 1;
            dataR[i] = this.getFloat();
            dataI[i] = this.getFloat();
            ++i;
        }
    }

    private int getInt() throws IOException {
        this.st.nextToken();
        if (this.st.ttype == -3) {
            return Integer.parseInt(this.st.sval);
        }
        if (this.st.ttype == -1) {
            throw new EOFException("End-of-File encountered during parsing");
        }
        throw new IOException("Unknown token found during parsing");
    }

    private long getLong() throws IOException {
        this.st.nextToken();
        if (this.st.ttype == -3) {
            return Long.parseLong(this.st.sval);
        }
        if (this.st.ttype == -1) {
            throw new EOFException("End-of-File encountered during parsing");
        }
        throw new IOException("Unknown token found during parsing");
    }

    private double getDouble() throws IOException {
        this.st.nextToken();
        if (this.st.ttype == -3) {
            return Double.parseDouble(this.st.sval);
        }
        if (this.st.ttype == -1) {
            throw new EOFException("End-of-File encountered during parsing");
        }
        throw new IOException("Unknown token found during parsing");
    }

    private float getFloat() throws IOException {
        this.st.nextToken();
        if (this.st.ttype == -3) {
            return Float.parseFloat(this.st.sval);
        }
        if (this.st.ttype == -1) {
            throw new EOFException("End-of-File encountered during parsing");
        }
        throw new IOException("Unknown token found during parsing");
    }
}

