/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;

class DelegateDComplexMatrix2D
extends DComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected DComplexMatrix3D content;
    protected int index;
    protected int axis;

    public DelegateDComplexMatrix2D(DComplexMatrix3D newContent, int axis, int index) {
        switch (axis) {
            case 0: {
                if (index < 0 || index >= newContent.slices()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(newContent.rows(), newContent.columns());
                break;
            }
            case 1: {
                if (index < 0 || index >= newContent.rows()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(newContent.slices(), newContent.columns());
                break;
            }
            case 2: {
                if (index < 0 || index >= newContent.columns()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(newContent.slices(), newContent.rows());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.axis = axis;
        this.index = index;
        this.content = newContent;
    }

    @Override
    public synchronized double[] getQuick(int row, int column) {
        switch (this.axis) {
            case 0: {
                return this.content.getQuick(this.index, row, column);
            }
            case 1: {
                return this.content.getQuick(row, this.index, column);
            }
            case 2: {
                return this.content.getQuick(row, column, this.index);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public DComplexMatrix2D like(int rows, int columns) {
        return this.content.like2D(rows, columns);
    }

    @Override
    public synchronized void setQuick(int row, int column, double[] value) {
        switch (this.axis) {
            case 0: {
                this.content.setQuick(this.index, row, column, value);
                break;
            }
            case 1: {
                this.content.setQuick(row, this.index, column, value);
                break;
            }
            case 2: {
                this.content.setQuick(row, column, this.index, value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public synchronized void setQuick(int row, int column, double re, double im) {
        switch (this.axis) {
            case 0: {
                this.content.setQuick(this.index, row, column, re, im);
                break;
            }
            case 1: {
                this.content.setQuick(row, this.index, column, re, im);
                break;
            }
            case 2: {
                this.content.setQuick(row, column, this.index, re, im);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public DComplexMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        return new WrapperDComplexMatrix2D(this).viewColumn(column);
    }

    @Override
    public Object elements() {
        return this.content.elements();
    }

    @Override
    protected DComplexMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public DComplexMatrix1D like1D(int size) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    protected DComplexMatrix1D like1D(int size, int zero, int stride) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public DComplexMatrix1D vectorize() {
        DenseDComplexMatrix1D v = new DenseDComplexMatrix1D(this.rows * this.columns);
        int idx = 0;
        int c = 0;
        while (c < this.columns) {
            int r = 0;
            while (r < this.rows) {
                ((DComplexMatrix1D)v).setQuick(idx++, this.getQuick(r, c));
                ++r;
            }
            ++c;
        }
        return v;
    }

    @Override
    public DoubleMatrix2D getImaginaryPart() {
        switch (this.axis) {
            case 0: {
                return this.content.viewSlice(this.index).getImaginaryPart();
            }
            case 1: {
                return this.content.viewRow(this.index).getImaginaryPart();
            }
            case 2: {
                return this.content.viewColumn(this.index).getImaginaryPart();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public DoubleMatrix2D getRealPart() {
        switch (this.axis) {
            case 0: {
                return this.content.viewSlice(this.index).getRealPart();
            }
            case 1: {
                return this.content.viewRow(this.index).getRealPart();
            }
            case 2: {
                return this.content.viewColumn(this.index).getRealPart();
            }
        }
        throw new IllegalArgumentException();
    }
}

