/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.algo.DoubleFormatter;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.DoubleSorting;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class DoubleMatrix1D
extends AbstractMatrix1D {
    private static final long serialVersionUID = 1L;

    protected DoubleMatrix1D() {
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f) {
        if (this.size == 0) {
            return Double.NaN;
        }
        double a = f.apply(this.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DoubleMatrix1D.this.getQuick(firstIdx));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            a = aggr.apply(a, f.apply(DoubleMatrix1D.this.getQuick(i)));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int i = 1;
            while (i < this.size) {
                a = aggr.apply(a, f.apply(this.getQuick(i)));
                ++i;
            }
        }
        return a;
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f, IntArrayList indexList) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        int size = indexList.size();
        final int[] indexElements = indexList.elements();
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DoubleMatrix1D.this.getQuick(indexElements[firstIdx]));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            double elem = DoubleMatrix1D.this.getQuick(indexElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(indexElements[0]));
            int i = 1;
            while (i < size) {
                double elem = this.getQuick(indexElements[i]);
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    public double aggregate(final DoubleMatrix1D other, final DoubleDoubleFunction aggr, final DoubleDoubleFunction f) {
        this.checkSize(other);
        if (this.size == 0) {
            return Double.NaN;
        }
        double a = f.apply(this.getQuick(0), other.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DoubleMatrix1D.this.getQuick(firstIdx), other.getQuick(firstIdx));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            a = aggr.apply(a, f.apply(DoubleMatrix1D.this.getQuick(i), other.getQuick(i)));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int i = 1;
            while (i < this.size) {
                a = aggr.apply(a, f.apply(this.getQuick(i), other.getQuick(i)));
                ++i;
            }
        }
        return a;
    }

    public DoubleMatrix1D assign(final DoubleFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            DoubleMatrix1D.this.setQuick(i, f.apply(DoubleMatrix1D.this.getQuick(i)));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, f.apply(this.getQuick(i)));
                ++i;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final DoubleProcedure cond, final DoubleFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            double elem = DoubleMatrix1D.this.getQuick(i);
                            if (cond.apply(elem)) {
                                DoubleMatrix1D.this.setQuick(i, f.apply(elem));
                            }
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                double elem = this.getQuick(i);
                if (cond.apply(elem)) {
                    this.setQuick(i, f.apply(elem));
                }
                ++i;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final DoubleProcedure cond, final double value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            double elem = DoubleMatrix1D.this.getQuick(i);
                            if (cond.apply(elem)) {
                                DoubleMatrix1D.this.setQuick(i, value);
                            }
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                double elem = this.getQuick(i);
                if (cond.apply(elem)) {
                    this.setQuick(i, value);
                }
                ++i;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final double value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            DoubleMatrix1D.this.setQuick(i, value);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, value);
                ++i;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final double[] values) {
        if (values.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + "size()=" + this.size());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            DoubleMatrix1D.this.setQuick(i, values[i]);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, values[i]);
                ++i;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D other) {
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        final DoubleMatrix1D source = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            DoubleMatrix1D.this.setQuick(i, source.getQuick(i));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, source.getQuick(i));
                ++i;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final DoubleMatrix1D y, final DoubleDoubleFunction function) {
        this.checkSize(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            DoubleMatrix1D.this.setQuick(i, function.apply(DoubleMatrix1D.this.getQuick(i), y.getQuick(i)));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, function.apply(this.getQuick(i), y.getQuick(i)));
                ++i;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D y, DoubleDoubleFunction function, IntArrayList nonZeroIndexes) {
        this.checkSize(y);
        int[] nonZeroElements = nonZeroIndexes.elements();
        if (function == DoubleFunctions.mult) {
            int j = 0;
            int index = nonZeroIndexes.size();
            while (--index >= 0) {
                int i = nonZeroElements[index];
                while (j < i) {
                    this.setQuick(j, 0.0);
                    ++j;
                }
                this.setQuick(i, this.getQuick(i) * y.getQuick(i));
                ++j;
            }
        } else if (function instanceof DoublePlusMultSecond) {
            double multiplicator = ((DoublePlusMultSecond)function).multiplicator;
            if (multiplicator == 0.0) {
                return this;
            }
            if (multiplicator == 1.0) {
                int index = nonZeroIndexes.size();
                while (--index >= 0) {
                    int i = nonZeroElements[index];
                    this.setQuick(i, this.getQuick(i) + y.getQuick(i));
                }
            } else if (multiplicator == -1.0) {
                int index = nonZeroIndexes.size();
                while (--index >= 0) {
                    int i = nonZeroElements[index];
                    this.setQuick(i, this.getQuick(i) - y.getQuick(i));
                }
            } else {
                int index = nonZeroIndexes.size();
                while (--index >= 0) {
                    int i = nonZeroElements[index];
                    this.setQuick(i, this.getQuick(i) + multiplicator * y.getQuick(i));
                }
            }
        } else {
            return this.assign(y, function);
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            if (DoubleMatrix1D.this.getQuick(i) != 0.0) {
                                ++cardinality;
                            }
                            ++i;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int i = 0;
            while (i < this.size) {
                if (this.getQuick(i) != 0.0) {
                    ++cardinality;
                }
                ++i;
            }
        }
        return cardinality;
    }

    public DoubleMatrix1D copy() {
        DoubleMatrix1D copy = this.like();
        copy.assign(this);
        return copy;
    }

    public abstract Object elements();

    public boolean equals(double value) {
        return DoubleProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleMatrix1D)) {
            return false;
        }
        return DoubleProperty.DEFAULT.equals(this, (DoubleMatrix1D)obj);
    }

    public double get(int index) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        return this.getQuick(index);
    }

    public double[] getMaxLocation() {
        int location = 0;
        double maxValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int location = firstIdx;
                        double maxValue = DoubleMatrix1D.this.getQuick(location);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            double elem = DoubleMatrix1D.this.getQuick(i);
                            if (maxValue < elem) {
                                maxValue = elem;
                                location = i;
                            }
                            ++i;
                        }
                        return new double[]{maxValue, location};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (double[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                location = (int)results[0][1];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        location = (int)results[j][1];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.getQuick(location);
            int i = 1;
            while ((long)i < this.size()) {
                double elem = this.getQuick(i);
                if (maxValue < elem) {
                    maxValue = elem;
                    location = i;
                }
                ++i;
            }
        }
        return new double[]{maxValue, location};
    }

    public double[] getMinLocation() {
        int location = 0;
        double minValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int location = firstIdx;
                        double minValue = DoubleMatrix1D.this.getQuick(location);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            double elem = DoubleMatrix1D.this.getQuick(i);
                            if (minValue > elem) {
                                minValue = elem;
                                location = i;
                            }
                            ++i;
                        }
                        return new double[]{minValue, location};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (double[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                location = (int)results[0][1];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        location = (int)results[j][1];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.getQuick(location);
            int i = 1;
            while ((long)i < this.size()) {
                double elem = this.getQuick(i);
                if (minValue > elem) {
                    minValue = elem;
                    location = i;
                }
                ++i;
            }
        }
        return new double[]{minValue, location};
    }

    public void getNegativeValues(IntArrayList indexList, DoubleArrayList valueList) {
        double value;
        int rem;
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        if ((rem = this.size % 2) == 1 && (value = this.getQuick(0)) < 0.0) {
            if (fillIndexList) {
                indexList.add(0);
            }
            if (fillValueList) {
                valueList.add(value);
            }
        }
        int i = rem;
        while (i < this.size) {
            double value2 = this.getQuick(i);
            if (value2 < 0.0) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value2);
                }
            }
            if ((value2 = this.getQuick(i + 1)) < 0.0) {
                if (fillIndexList) {
                    indexList.add(i + 1);
                }
                if (fillValueList) {
                    valueList.add(value2);
                }
            }
            i += 2;
        }
    }

    public void getNonZeros(IntArrayList indexList, DoubleArrayList valueList) {
        double value;
        int rem;
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        if ((rem = this.size % 2) == 1 && (value = this.getQuick(0)) != 0.0) {
            if (fillIndexList) {
                indexList.add(0);
            }
            if (fillValueList) {
                valueList.add(value);
            }
        }
        int i = rem;
        while (i < this.size) {
            double value2 = this.getQuick(i);
            if (value2 != 0.0) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value2);
                }
            }
            if ((value2 = this.getQuick(i + 1)) != 0.0) {
                if (fillIndexList) {
                    indexList.add(i + 1);
                }
                if (fillValueList) {
                    valueList.add(value2);
                }
            }
            i += 2;
        }
    }

    public void getNonZeros(IntArrayList indexList, DoubleArrayList valueList, int maxCardinality) {
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        int s = this.size;
        int currentSize = 0;
        int i = 0;
        while (i < s) {
            double value = this.getQuick(i);
            if (value != 0.0) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
                ++currentSize;
            }
            if (currentSize >= maxCardinality) break;
            ++i;
        }
    }

    public void getPositiveValues(IntArrayList indexList, DoubleArrayList valueList) {
        double value;
        int rem;
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        if ((rem = this.size % 2) == 1 && (value = this.getQuick(0)) > 0.0) {
            if (fillIndexList) {
                indexList.add(0);
            }
            if (fillValueList) {
                valueList.add(value);
            }
        }
        int i = rem;
        while (i < this.size) {
            double value2 = this.getQuick(i);
            if (value2 > 0.0) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value2);
                }
            }
            if ((value2 = this.getQuick(i + 1)) > 0.0) {
                if (fillIndexList) {
                    indexList.add(i + 1);
                }
                if (fillValueList) {
                    valueList.add(value2);
                }
            }
            i += 2;
        }
    }

    public abstract double getQuick(int var1);

    public DoubleMatrix1D like() {
        return this.like(this.size);
    }

    public abstract DoubleMatrix1D like(int var1);

    public abstract DoubleMatrix2D like2D(int var1, int var2);

    public void normalize() {
        double min = this.getMinLocation()[0];
        if (min < 0.0) {
            this.assign(DoubleFunctions.minus(min));
        }
        if (this.getMaxLocation()[0] == 0.0) {
            this.assign(1.0 / (double)this.size());
        } else {
            double sumScaleFactor = this.zSum();
            sumScaleFactor = 1.0 / sumScaleFactor;
            this.assign(DoubleFunctions.mult(sumScaleFactor));
        }
    }

    public abstract DoubleMatrix2D reshape(int var1, int var2);

    public abstract DoubleMatrix3D reshape(int var1, int var2, int var3);

    public void set(int index, double value) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        this.setQuick(index, value);
    }

    public abstract void setQuick(int var1, double var2);

    public void swap(final DoubleMatrix1D other) {
        this.checkSize(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            double tmp = DoubleMatrix1D.this.getQuick(i);
                            DoubleMatrix1D.this.setQuick(i, other.getQuick(i));
                            other.setQuick(i, tmp);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                double tmp = this.getQuick(i);
                this.setQuick(i, other.getQuick(i));
                other.setQuick(i, tmp);
                ++i;
            }
        }
    }

    public double[] toArray() {
        double[] values = new double[this.size];
        this.toArray(values);
        return values;
    }

    public void toArray(final double[] values) {
        if (values.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            values[i] = DoubleMatrix1D.this.getQuick(i);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                values[i] = this.getQuick(i);
                ++i;
            }
        }
    }

    public String toString() {
        return new DoubleFormatter().toString(this);
    }

    public DoubleMatrix1D viewFlip() {
        return (DoubleMatrix1D)this.view().vFlip();
    }

    public DoubleMatrix1D viewPart(int index, int width) {
        return (DoubleMatrix1D)this.view().vPart(index, width);
    }

    public DoubleMatrix1D viewSelection(DoubleProcedure condition) {
        IntArrayList matches = new IntArrayList();
        int i = 0;
        while (i < this.size) {
            if (condition.apply(this.getQuick(i))) {
                matches.add(i);
            }
            ++i;
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements());
    }

    public DoubleMatrix1D viewSelection(int[] indexes) {
        if (indexes == null) {
            indexes = new int[this.size];
            int i = 0;
            while (i < this.size) {
                indexes[i] = i;
                ++i;
            }
        }
        this.checkIndexes(indexes);
        int[] offsets = new int[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            offsets[i] = (int)this.index(indexes[i]);
            ++i;
        }
        return this.viewSelectionLike(offsets);
    }

    public DoubleMatrix1D viewSorted() {
        return DoubleSorting.mergeSort.sort(this);
    }

    public DoubleMatrix1D viewStrides(int stride) {
        return (DoubleMatrix1D)this.view().vStrides(stride);
    }

    public double zDotProduct(DoubleMatrix1D y) {
        return this.zDotProduct(y, 0, this.size);
    }

    public double zDotProduct(final DoubleMatrix1D y, final int from, int length) {
        if (from < 0 || length <= 0) {
            return 0.0;
        }
        int tail = from + length;
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        length = tail - from;
        double sum = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, length);
            Future[] futures = new Future[nthreads];
            Double[] results = new Double[nthreads];
            int k = length / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double sum = 0.0;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            int idx = k + from;
                            sum += DoubleMatrix1D.this.getQuick(idx) * y.getQuick(idx);
                            ++k;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Double)futures[j].get();
                    ++j;
                }
                sum = results[0];
                j = 1;
                while (j < nthreads) {
                    sum += results[j].doubleValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int i = tail - 1;
            int k = length;
            while (--k >= 0) {
                sum += this.getQuick(i) * y.getQuick(i);
                --i;
            }
        }
        return sum;
    }

    public double zDotProduct(DoubleMatrix1D y, int from, int length, IntArrayList nonZeroIndexes) {
        int i;
        if (from < 0 || length <= 0) {
            return 0.0;
        }
        int tail = from + length;
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        if ((length = tail - from) <= 0) {
            return 0.0;
        }
        IntArrayList indexesCopy = nonZeroIndexes.copy();
        indexesCopy.trimToSize();
        indexesCopy.quickSort();
        int[] nonZeroIndexElements = indexesCopy.elements();
        int index = 0;
        int s = indexesCopy.size();
        while (index < s && nonZeroIndexElements[index] < from) {
            ++index;
        }
        double sum = 0.0;
        while (--length >= 0 && index < s && (i = nonZeroIndexElements[index]) < tail) {
            sum += this.getQuick(i) * y.getQuick(i);
            ++index;
        }
        return sum;
    }

    public double zSum() {
        if (this.size() == 0L) {
            return 0.0;
        }
        return this.aggregate(DoubleFunctions.plus, DoubleFunctions.identity);
    }

    protected int cardinality(int maxCardinality) {
        int cardinality = 0;
        int i = this.size;
        while (--i >= 0 && cardinality < maxCardinality) {
            if (this.getQuick(i) == 0.0) continue;
            ++cardinality;
        }
        return cardinality;
    }

    protected DoubleMatrix1D getContent() {
        return this;
    }

    protected boolean haveSharedCells(DoubleMatrix1D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix1D other) {
        return false;
    }

    protected DoubleMatrix1D view() {
        return (DoubleMatrix1D)this.clone();
    }

    protected abstract DoubleMatrix1D viewSelectionLike(int[] var1);

    protected double zDotProduct(DoubleMatrix1D y, IntArrayList nonZeroIndexes) {
        return this.zDotProduct(y, 0, this.size, nonZeroIndexes);
    }
}

