/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1DProcedure;
import cern.colt.matrix.tfcomplex.algo.FComplexProperty;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class FComplexMatrix2D
extends AbstractMatrix2D {
    private static final long serialVersionUID = 1L;

    protected FComplexMatrix2D() {
    }

    public float[] aggregate(final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFunction f) {
        float[] b = new float[2];
        if (this.size() == 0L) {
            b[0] = Float.NaN;
            b[1] = Float.NaN;
            return b;
        }
        float[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] a = f.apply(FComplexMatrix2D.this.getQuick(firstRow, 0));
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < FComplexMatrix2D.this.columns) {
                                a = aggr.apply(a, f.apply(FComplexMatrix2D.this.getQuick(r, c)));
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0));
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c)));
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    public float[] aggregate(final FComplexMatrix2D other, final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFComplexFunction f) {
        this.checkShape(other);
        float[] b = new float[2];
        if (this.size() == 0L) {
            b[0] = Float.NaN;
            b[1] = Float.NaN;
            return b;
        }
        float[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] a = f.apply(FComplexMatrix2D.this.getQuick(firstRow, 0), other.getQuick(firstRow, 0));
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < FComplexMatrix2D.this.columns) {
                                a = aggr.apply(a, f.apply(FComplexMatrix2D.this.getQuick(r, c), other.getQuick(r, c)));
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0), other.getQuick(0, 0));
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c), other.getQuick(r, c)));
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    public FComplexMatrix2D assign(final FComplexFComplexFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FComplexMatrix2D.this.columns) {
                                FComplexMatrix2D.this.setQuick(r, c, f.apply(FComplexMatrix2D.this.getQuick(r, c)));
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, f.apply(this.getQuick(r, c)));
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(final FComplexProcedure cond, final FComplexFComplexFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FComplexMatrix2D.this.columns) {
                                float[] elem = FComplexMatrix2D.this.getQuick(r, c);
                                if (cond.apply(elem)) {
                                    FComplexMatrix2D.this.setQuick(r, c, f.apply(elem));
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    float[] elem = this.getQuick(r, c);
                    if (cond.apply(elem)) {
                        this.setQuick(r, c, f.apply(elem));
                    }
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(final FComplexProcedure cond, final float[] value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FComplexMatrix2D.this.columns) {
                                float[] elem = FComplexMatrix2D.this.getQuick(r, c);
                                if (cond.apply(elem)) {
                                    FComplexMatrix2D.this.setQuick(r, c, value);
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    float[] elem = this.getQuick(r, c);
                    if (cond.apply(elem)) {
                        this.setQuick(r, c, value);
                    }
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(final FComplexRealFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FComplexMatrix2D.this.columns) {
                                float re = f.apply(FComplexMatrix2D.this.getQuick(r, c));
                                FComplexMatrix2D.this.setQuick(r, c, re, 0.0f);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    float re = f.apply(this.getQuick(r, c));
                    this.setQuick(r, c, re, 0.0f);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(FComplexMatrix2D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        final FComplexMatrix2D otherLoc = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FComplexMatrix2D.this.columns) {
                                FComplexMatrix2D.this.setQuick(r, c, otherLoc.getQuick(r, c));
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, otherLoc.getQuick(r, c));
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(final FComplexMatrix2D y, final FComplexFComplexFComplexFunction f) {
        this.checkShape(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FComplexMatrix2D.this.columns) {
                                FComplexMatrix2D.this.setQuick(r, c, f.apply(FComplexMatrix2D.this.getQuick(r, c), y.getQuick(r, c)));
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, f.apply(this.getQuick(r, c), y.getQuick(r, c)));
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(final FComplexMatrix2D y, final FComplexFComplexFComplexFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            FComplexMatrix2D.this.setQuick(rowElements[i], columnElements[i], function.apply(FComplexMatrix2D.this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                this.setQuick(rowElements[i], columnElements[i], function.apply(this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
                ++i;
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(final float re, final float im) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FComplexMatrix2D.this.columns) {
                                FComplexMatrix2D.this.setQuick(r, c, re, im);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, re, im);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(final float[] values) {
        if (values.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstRow * FComplexMatrix2D.this.columns * 2;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FComplexMatrix2D.this.columns) {
                                FComplexMatrix2D.this.setQuick(r, c, values[idx], values[idx + 1]);
                                idx += 2;
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, values[idx], values[idx + 1]);
                    idx += 2;
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(final float[][] values) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            float[] currentRow = values[r];
                            if (currentRow.length != 2 * FComplexMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + 2 * FComplexMatrix2D.this.columns());
                            }
                            int c = 0;
                            while (c < FComplexMatrix2D.this.columns) {
                                FComplexMatrix2D.this.setQuick(r, c, currentRow[2 * c], currentRow[2 * c + 1]);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                float[] currentRow = values[r];
                if (currentRow.length != 2 * this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + 2 * this.columns());
                }
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, currentRow[2 * c], currentRow[2 * c + 1]);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public FComplexMatrix2D assignImaginary(final FloatMatrix2D other) {
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FComplexMatrix2D.this.columns) {
                                float re = FComplexMatrix2D.this.getQuick(r, c)[0];
                                float im = other.getQuick(r, c);
                                FComplexMatrix2D.this.setQuick(r, c, re, im);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    float re = this.getQuick(r, c)[0];
                    float im = other.getQuick(r, c);
                    this.setQuick(r, c, re, im);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public FComplexMatrix2D assignReal(final FloatMatrix2D other) {
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FComplexMatrix2D.this.columns) {
                                float re = other.getQuick(r, c);
                                float im = FComplexMatrix2D.this.getQuick(r, c)[1];
                                FComplexMatrix2D.this.setQuick(r, c, re, im);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    float re = other.getQuick(r, c);
                    float im = this.getQuick(r, c)[1];
                    this.setQuick(r, c, re, im);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        float[] tmp = new float[2];
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FComplexMatrix2D.this.columns) {
                                tmp = FComplexMatrix2D.this.getQuick(r, c);
                                if ((double)tmp[0] != 0.0 || (double)tmp[1] != 0.0) {
                                    ++cardinality;
                                }
                                ++c;
                            }
                            ++r;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            float[] tmp = new float[2];
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    tmp = this.getQuick(r, c);
                    if (tmp[0] != 0.0f || tmp[1] != 0.0f) {
                        ++cardinality;
                    }
                    ++c;
                }
                ++r;
            }
        }
        return cardinality;
    }

    public FComplexMatrix2D copy() {
        return this.like().assign(this);
    }

    public boolean equals(float[] value) {
        return FComplexProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FComplexMatrix2D)) {
            return false;
        }
        return FComplexProperty.DEFAULT.equals(this, (FComplexMatrix2D)obj);
    }

    public FComplexMatrix2D forEachNonZero(final IntIntFComplexFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FComplexMatrix2D.this.columns) {
                                float[] value = FComplexMatrix2D.this.getQuick(r, c);
                                if (value[0] != 0.0f || value[1] != 0.0f) {
                                    float[] v = function.apply(r, c, value);
                                    FComplexMatrix2D.this.setQuick(r, c, v);
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    float[] value = this.getQuick(r, c);
                    if (value[0] != 0.0f || value[1] != 0.0f) {
                        float[] v = function.apply(r, c, value);
                        this.setQuick(r, c, v);
                    }
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public float[] get(int row, int column) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        return this.getQuick(row, column);
    }

    public FComplexMatrix2D getConjugateTranspose() {
        final FComplexMatrix2D transpose = this.viewDice().copy();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.columns : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] tmp = new float[2];
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FComplexMatrix2D.this.rows) {
                                tmp = transpose.getQuick(r, c);
                                tmp[1] = -tmp[1];
                                transpose.setQuick(r, c, tmp);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] tmp = new float[2];
            int r = 0;
            while (r < this.columns) {
                int c = 0;
                while (c < this.rows) {
                    tmp = transpose.getQuick(r, c);
                    tmp[1] = -tmp[1];
                    transpose.setQuick(r, c, tmp);
                    ++c;
                }
                ++r;
            }
        }
        return transpose;
    }

    public abstract Object elements();

    public abstract FloatMatrix2D getImaginaryPart();

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, ArrayList<float[]> valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.columns) {
                float[] value = this.getQuick(r, c);
                if (value[0] != 0.0f || value[1] != 0.0f) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                ++c;
            }
            ++r;
        }
    }

    public abstract float[] getQuick(int var1, int var2);

    public abstract FloatMatrix2D getRealPart();

    public FComplexMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract FComplexMatrix2D like(int var1, int var2);

    public abstract FComplexMatrix1D like1D(int var1);

    public void set(int row, int column, float[] value) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        this.setQuick(row, column, value);
    }

    public void set(int row, int column, float re, float im) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        this.setQuick(row, column, re, im);
    }

    public abstract void setQuick(int var1, int var2, float var3, float var4);

    public abstract void setQuick(int var1, int var2, float[] var3);

    public float[][] toArray() {
        final float[][] values = new float[this.rows][2 * this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FComplexMatrix2D.this.columns) {
                                float[] tmp = FComplexMatrix2D.this.getQuick(r, c);
                                values[r][2 * c] = tmp[0];
                                values[r][2 * c + 1] = tmp[1];
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    float[] tmp = this.getQuick(r, c);
                    values[r][2 * c] = tmp[0];
                    values[r][2 * c + 1] = tmp[1];
                    ++c;
                }
                ++r;
            }
        }
        return values;
    }

    public String toString() {
        return this.toString("%.4f");
    }

    public String toString(String format) {
        StringBuffer s = new StringBuffer(String.format("ComplexMatrix2D: %d rows, %d columns\n\n", this.rows, this.columns));
        float[] elem = new float[2];
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.columns) {
                elem = this.getQuick(r, c);
                if (elem[1] == 0.0f) {
                    s.append(String.format(String.valueOf(format) + "\t", Float.valueOf(elem[0])));
                } else if (elem[0] == 0.0f) {
                    s.append(String.format(String.valueOf(format) + "i\t", Float.valueOf(elem[1])));
                } else if (elem[1] < 0.0f) {
                    s.append(String.format(String.valueOf(format) + " - " + format + "i\t", Float.valueOf(elem[0]), Float.valueOf(-elem[1])));
                } else {
                    s.append(String.format(String.valueOf(format) + " + " + format + "i\t", Float.valueOf(elem[0]), Float.valueOf(elem[1])));
                }
                ++c;
            }
            s.append("\n");
            ++r;
        }
        return s.toString();
    }

    public abstract FComplexMatrix1D vectorize();

    public FComplexMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = (int)this.index(0, column);
        int viewStride = this.rowStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public FComplexMatrix2D viewColumnFlip() {
        return (FComplexMatrix2D)this.view().vColumnFlip();
    }

    public FComplexMatrix2D viewDice() {
        return (FComplexMatrix2D)this.view().vDice();
    }

    public FComplexMatrix2D viewPart(int row, int column, int height, int width) {
        return (FComplexMatrix2D)this.view().vPart(row, column, height, width);
    }

    public FComplexMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = (int)this.index(row, 0);
        int viewStride = this.columnStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public FComplexMatrix2D viewRowFlip() {
        return (FComplexMatrix2D)this.view().vRowFlip();
    }

    public FComplexMatrix2D viewSelection(FComplexMatrix1DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        int i = 0;
        while (i < this.rows) {
            if (condition.apply(this.viewRow(i))) {
                matches.add(i);
            }
            ++i;
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null);
    }

    public FComplexMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = 0;
            while (i < this.rows) {
                rowIndexes[i] = i;
                ++i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = 0;
            while (i < this.columns) {
                columnIndexes[i] = i;
                ++i;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        int i2 = 0;
        while (i2 < rowIndexes.length) {
            rowOffsets[i2] = this._rowOffset(this._rowRank(rowIndexes[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < columnIndexes.length) {
            columnOffsets[i2] = this._columnOffset(this._columnRank(columnIndexes[i2]));
            ++i2;
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    public FComplexMatrix2D viewStrides(int rowStride, int columnStride) {
        return (FComplexMatrix2D)this.view().vStrides(rowStride, columnStride);
    }

    public FComplexMatrix1D zMult(FComplexMatrix1D y, FComplexMatrix1D z) {
        float[] fArray;
        float[] fArray2 = new float[]{1.0f, 0.0f};
        if (z == null) {
            float[] fArray3 = new float[2];
            fArray3[0] = 1.0f;
            fArray = fArray3;
            fArray3[1] = 0.0f;
        } else {
            float[] fArray4 = new float[2];
            fArray4[0] = 0.0f;
            fArray = fArray4;
            fArray4[1] = 0.0f;
        }
        return this.zMult(y, z, fArray2, fArray, false);
    }

    public FComplexMatrix1D zMult(final FComplexMatrix1D y, FComplexMatrix1D z, final float[] alpha, final float[] beta, boolean transposeA) {
        if (transposeA) {
            return this.getConjugateTranspose().zMult(y, z, alpha, beta, false);
        }
        final FComplexMatrix1D zz = z == null ? y.like(this.rows) : z;
        if ((long)this.columns != y.size() || (long)this.rows > zz.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + zz.toStringShort());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] s = new float[2];
                        int r = firstRow;
                        while (r < lastRow) {
                            s[0] = 0.0f;
                            s[1] = 0.0f;
                            int c = 0;
                            while (c < FComplexMatrix2D.this.columns) {
                                s = FComplex.plus(s, FComplex.mult(FComplexMatrix2D.this.getQuick(r, c), y.getQuick(c)));
                                ++c;
                            }
                            zz.setQuick(r, FComplex.plus(FComplex.mult(s, alpha), FComplex.mult(zz.getQuick(r), beta)));
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] s = new float[2];
            int r = 0;
            while (r < this.rows) {
                s[0] = 0.0f;
                s[1] = 0.0f;
                int c = 0;
                while (c < this.columns) {
                    s = FComplex.plus(s, FComplex.mult(this.getQuick(r, c), y.getQuick(c)));
                    ++c;
                }
                zz.setQuick(r, FComplex.plus(FComplex.mult(s, alpha), FComplex.mult(zz.getQuick(r), beta)));
                ++r;
            }
        }
        return zz;
    }

    public FComplexMatrix2D zMult(FComplexMatrix2D B, FComplexMatrix2D C) {
        float[] fArray;
        float[] fArray2 = new float[]{1.0f, 0.0f};
        if (C == null) {
            float[] fArray3 = new float[2];
            fArray3[0] = 1.0f;
            fArray = fArray3;
            fArray3[1] = 0.0f;
        } else {
            float[] fArray4 = new float[2];
            fArray4[0] = 0.0f;
            fArray = fArray4;
            fArray4[1] = 0.0f;
        }
        return this.zMult(B, C, fArray2, fArray, false, false);
    }

    public FComplexMatrix2D zMult(final FComplexMatrix2D B, FComplexMatrix2D C, final float[] alpha, final float[] beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.getConjugateTranspose().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.getConjugateTranspose(), C, alpha, beta, transposeA, false);
        }
        final int m = this.rows;
        final int n = this.columns;
        int p = B.columns;
        final FComplexMatrix2D CC = C == null ? this.like(m, p) : C;
        if (B.rows != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (CC.rows != m || CC.columns != p) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + CC.toStringShort());
        }
        if (this == CC || B == CC) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, p);
            Future[] futures = new Future[nthreads];
            int k = p / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? p : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] s = new float[2];
                        int a = firstIdx;
                        while (a < lastIdx) {
                            int b = 0;
                            while (b < m) {
                                s[0] = 0.0f;
                                s[1] = 0.0f;
                                int c = 0;
                                while (c < n) {
                                    s = FComplex.plus(s, FComplex.mult(FComplexMatrix2D.this.getQuick(b, c), B.getQuick(c, a)));
                                    ++c;
                                }
                                CC.setQuick(b, a, FComplex.plus(FComplex.mult(s, alpha), FComplex.mult(CC.getQuick(b, a), beta)));
                                ++b;
                            }
                            ++a;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] s = new float[2];
            int a = 0;
            while (a < p) {
                int b = 0;
                while (b < m) {
                    s[0] = 0.0f;
                    s[1] = 0.0f;
                    int c = 0;
                    while (c < n) {
                        s = FComplex.plus(s, FComplex.mult(this.getQuick(b, c), B.getQuick(c, a)));
                        ++c;
                    }
                    CC.setQuick(b, a, FComplex.plus(FComplex.mult(s, alpha), FComplex.mult(CC.getQuick(b, a), beta)));
                    ++b;
                }
                ++a;
            }
        }
        return CC;
    }

    public float[] zSum() {
        if (this.size() == 0L) {
            return new float[]{0.0f, 0.0f};
        }
        return this.aggregate(FComplexFunctions.plus, FComplexFunctions.identity);
    }

    protected FComplexMatrix2D getContent() {
        return this;
    }

    protected boolean haveSharedCells(FComplexMatrix2D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(FComplexMatrix2D other) {
        return false;
    }

    protected abstract FComplexMatrix1D like1D(int var1, int var2, int var3);

    protected FComplexMatrix2D view() {
        return (FComplexMatrix2D)this.clone();
    }

    protected abstract FComplexMatrix2D viewSelectionLike(int[] var1, int[] var2);
}

