/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import java.util.concurrent.Future;

class SelectedDenseFComplexMatrix1D
extends FComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected float[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseFComplexMatrix1D(float[] elements, int[] offsets) {
        this(offsets.length, elements, 0, 1, offsets, 0);
    }

    protected SelectedDenseFComplexMatrix1D(int size, float[] elements, int zero, int stride, int[] offsets, int offset) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.offsets = offsets;
        this.offset = offset;
        this.isNoView = false;
    }

    @Override
    protected int _offset(int absRank) {
        return this.offsets[absRank];
    }

    @Override
    public float[] getQuick(int index) {
        int idx = this.zero + index * this.stride;
        return new float[]{this.elements[this.offset + this.offsets[idx]], this.elements[this.offset + this.offsets[idx] + 1]};
    }

    @Override
    public FloatMatrix1D getRealPart() {
        final DenseFloatMatrix1D R = new DenseFloatMatrix1D(this.size);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){
                    float[] tmp;

                    @Override
                    public void run() {
                        int k = firstIdx;
                        while (k < lastIdx) {
                            this.tmp = SelectedDenseFComplexMatrix1D.this.getQuick(k);
                            R.setQuick(k, this.tmp[0]);
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                float[] tmp = this.getQuick(i);
                R.setQuick(i, tmp[0]);
                ++i;
            }
        }
        return R;
    }

    @Override
    public FloatMatrix1D getImaginaryPart() {
        final DenseFloatMatrix1D Im = new DenseFloatMatrix1D(this.size);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){
                    float[] tmp;

                    @Override
                    public void run() {
                        int k = firstIdx;
                        while (k < lastIdx) {
                            this.tmp = SelectedDenseFComplexMatrix1D.this.getQuick(k);
                            Im.setQuick(k, this.tmp[1]);
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                float[] tmp = this.getQuick(i);
                Im.setQuick(i, tmp[1]);
                ++i;
            }
        }
        return Im;
    }

    public float[] elements() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix1D other) {
        if (other instanceof SelectedDenseFComplexMatrix1D) {
            SelectedDenseFComplexMatrix1D otherMatrix = (SelectedDenseFComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseFComplexMatrix1D) {
            DenseFComplexMatrix1D otherMatrix = (DenseFComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int rank) {
        return this.offset + this.offsets[this.zero + rank * this.stride];
    }

    @Override
    public FComplexMatrix1D like(int size) {
        return new DenseFComplexMatrix1D(size);
    }

    @Override
    public FComplexMatrix2D like2D(int rows, int columns) {
        return new DenseFComplexMatrix2D(rows, columns);
    }

    @Override
    public FComplexMatrix2D reshape(int rows, int columns) {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public FComplexMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public void setQuick(int index, float[] value) {
        int idx = this.zero + index * this.stride;
        this.elements[this.offset + this.offsets[idx]] = value[0];
        this.elements[this.offset + this.offsets[idx] + 1] = value[1];
    }

    @Override
    public void setQuick(int index, float re, float im) {
        int idx = this.zero + index * this.stride;
        this.elements[this.offset + this.offsets[idx]] = re;
        this.elements[this.offset + this.offsets[idx] + 1] = im;
    }

    @Override
    protected void setUp(int size) {
        super.setUp(size, 0, 1);
        this.offset = 0;
    }

    @Override
    protected FComplexMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseFComplexMatrix1D(this.elements, offsets);
    }
}

