/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver.preconditioner;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;

public class FloatDiagonal
implements FloatPreconditioner {
    private float[] invdiag;

    public FloatDiagonal(int n) {
        this.invdiag = new float[n];
    }

    @Override
    public FloatMatrix1D apply(FloatMatrix1D b, FloatMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        if (!(x instanceof DenseFloatMatrix1D) || !(b instanceof DenseFloatMatrix1D)) {
            throw new IllegalArgumentException("a nad b must be dense vectors");
        }
        float[] xd = ((DenseFloatMatrix1D)x).elements();
        float[] bd = ((DenseFloatMatrix1D)b).elements();
        int i = 0;
        while (i < this.invdiag.length) {
            xd[i] = bd[i] * this.invdiag[i];
            ++i;
        }
        return x;
    }

    @Override
    public FloatMatrix1D transApply(FloatMatrix1D b, FloatMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        return this.apply(b, x);
    }

    @Override
    public void setMatrix(FloatMatrix2D A) {
        if (A.rows() != this.invdiag.length) {
            throw new IllegalArgumentException("Matrix size differs from preconditioner size");
        }
        int i = 0;
        while (i < this.invdiag.length) {
            this.invdiag[i] = A.getQuick(i, i);
            if (this.invdiag[i] == 0.0f) {
                throw new RuntimeException("Zero diagonal on row " + (i + 1));
            }
            this.invdiag[i] = 1.0f / this.invdiag[i];
            ++i;
        }
    }
}

