/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix2D;

public class SparseCCMFloatMatrix2D
extends WrapperFloatMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseFloatMatrix1D[] elements;

    public SparseCCMFloatMatrix2D(int rows, int columns) {
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        this.elements = new SparseFloatMatrix1D[columns];
        int i = 0;
        while (i < columns) {
            this.elements[i] = new SparseFloatMatrix1D(rows);
            ++i;
        }
    }

    public SparseFloatMatrix1D[] elements() {
        return this.elements;
    }

    @Override
    public float getQuick(int row, int column) {
        return this.elements[column].getQuick(row);
    }

    @Override
    public void setQuick(int row, int column, float value) {
        this.elements[column].setQuick(row, value);
    }

    @Override
    public void trimToSize() {
        int c = 0;
        while (c < this.columns) {
            this.elements[c].trimToSize();
            ++c;
        }
    }

    @Override
    public SparseFloatMatrix1D viewColumn(int column) {
        return this.elements[column];
    }

    @Override
    protected FloatMatrix2D getContent() {
        return this;
    }

    @Override
    public FloatMatrix2D like(int rows, int columns) {
        return new SparseCCMFloatMatrix2D(rows, columns);
    }
}

