/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix2D;

public class SparseRCMFloatMatrix2D
extends WrapperFloatMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseFloatMatrix1D[] elements;

    public SparseRCMFloatMatrix2D(int rows, int columns) {
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        this.elements = new SparseFloatMatrix1D[rows];
        int i = 0;
        while (i < rows) {
            this.elements[i] = new SparseFloatMatrix1D(columns);
            ++i;
        }
    }

    public SparseFloatMatrix1D[] elements() {
        return this.elements;
    }

    @Override
    public float getQuick(int row, int column) {
        return this.elements[row].getQuick(column);
    }

    @Override
    public void setQuick(int row, int column, float value) {
        this.elements[row].setQuick(column, value);
    }

    @Override
    public void trimToSize() {
        int r = 0;
        while (r < this.rows) {
            this.elements[r].trimToSize();
            ++r;
        }
    }

    @Override
    public SparseFloatMatrix1D viewRow(int row) {
        return this.elements[row];
    }

    @Override
    protected FloatMatrix2D getContent() {
        return this;
    }

    @Override
    public FloatMatrix2D like(int rows, int columns) {
        return new SparseRCMFloatMatrix2D(rows, columns);
    }
}

