/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SelectedDenseColumnIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntMult;
import cern.jet.math.tint.IntPlusMultFirst;
import cern.jet.math.tint.IntPlusMultSecond;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseColumnIntMatrix2D
extends IntMatrix2D {
    static final long serialVersionUID = 1L;
    protected int[] elements;

    public DenseColumnIntMatrix2D(int[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public DenseColumnIntMatrix2D(int rows, int columns) {
        this.setUp(rows, columns, 0, 0, 1, rows);
        this.elements = new int[rows * columns];
    }

    public DenseColumnIntMatrix2D(int rows, int columns, int[] elements, int rowZero, int columnZero, int rowStride, int columnStride, boolean isView) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    public DenseColumnIntMatrix2D(MatrixVectorReader reader) throws IOException {
        block9: {
            int i;
            int[] values;
            int[] rowIndexes;
            int[] columnIndexes;
            int numEntries;
            MatrixInfo info;
            block8: {
                info = reader.hasInfo() ? reader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (info.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (info.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (info.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize size = reader.readMatrixSize(info);
                this.setUp(size.numRows(), size.numColumns());
                this.elements = new int[this.rows * this.columns];
                numEntries = size.numEntries();
                columnIndexes = new int[numEntries];
                rowIndexes = new int[numEntries];
                values = new int[numEntries];
                reader.readCoordinate(rowIndexes, columnIndexes, values);
                i = 0;
                while (i < numEntries) {
                    this.setQuick(rowIndexes[i], columnIndexes[i], values[i]);
                    ++i;
                }
                if (!info.isSymmetric()) break block8;
                i = 0;
                while (i < numEntries) {
                    if (rowIndexes[i] != columnIndexes[i]) {
                        this.setQuick(columnIndexes[i], rowIndexes[i], values[i]);
                    }
                    ++i;
                }
                break block9;
            }
            if (!info.isSkewSymmetric()) break block9;
            i = 0;
            while (i < numEntries) {
                if (rowIndexes[i] != columnIndexes[i]) {
                    this.setQuick(columnIndexes[i], rowIndexes[i], -values[i]);
                }
                ++i;
            }
        }
    }

    @Override
    public int aggregate(final IntIntFunction aggr, final IntFunction f) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int zero = (int)this.index(0, 0);
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(DenseColumnIntMatrix2D.this.elements[zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride]);
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnIntMatrix2D.this.columnStride;
                            int r = DenseColumnIntMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                a = aggr.apply(a, f.apply(DenseColumnIntMatrix2D.this.elements[r * DenseColumnIntMatrix2D.this.rowStride + cidx]));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride]);
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    a = aggr.apply(a, f.apply(this.elements[r * this.rowStride + cidx]));
                }
                d = 0;
            }
        }
        return a;
    }

    @Override
    public int aggregate(final IntIntFunction aggr, final IntFunction f, final IntProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int zero = (int)this.index(0, 0);
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int elem = DenseColumnIntMatrix2D.this.elements[zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride];
                        int a = 0;
                        if (cond.apply(elem)) {
                            a = f.apply(elem);
                        }
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnIntMatrix2D.this.columnStride;
                            int r = DenseColumnIntMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                elem = DenseColumnIntMatrix2D.this.elements[r * DenseColumnIntMatrix2D.this.rowStride + cidx];
                                if (!cond.apply(elem)) continue;
                                a = aggr.apply(a, f.apply(elem));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int elem = this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            if (cond.apply(elem)) {
                a = f.apply(elem);
            }
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    elem = this.elements[r * this.rowStride + cidx];
                    if (!cond.apply(elem)) continue;
                    a = aggr.apply(a, f.apply(elem));
                }
                d = 0;
            }
        }
        return a;
    }

    @Override
    public int aggregate(final IntIntFunction aggr, final IntFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int zero = (int)this.index(0, 0);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = size - j * k;
                final int lastIdx = j == nthreads - 1 ? 0 : firstIdx - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(DenseColumnIntMatrix2D.this.elements[zero + rowElements[firstIdx - 1] * DenseColumnIntMatrix2D.this.rowStride + columnElements[firstIdx - 1] * DenseColumnIntMatrix2D.this.columnStride]);
                        int i = firstIdx - 1;
                        while (--i >= lastIdx) {
                            a = aggr.apply(a, f.apply(DenseColumnIntMatrix2D.this.elements[zero + rowElements[i] * DenseColumnIntMatrix2D.this.rowStride + columnElements[i] * DenseColumnIntMatrix2D.this.columnStride]));
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + rowElements[size - 1] * this.rowStride + columnElements[size - 1] * this.columnStride]);
            int i = size - 1;
            while (--i >= 0) {
                a = aggr.apply(a, f.apply(this.elements[zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride]));
            }
        }
        return a;
    }

    @Override
    public int aggregate(IntMatrix2D other, final IntIntFunction aggr, final IntIntFunction f) {
        if (!(other instanceof DenseColumnIntMatrix2D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)other.index(0, 0);
        final int rowStrideOther = other.rowStride();
        final int columnStrideOther = other.columnStride();
        final int[] otherElements = (int[])other.elements();
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(DenseColumnIntMatrix2D.this.elements[zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride], otherElements[zeroOther + (DenseColumnIntMatrix2D.this.rows - 1) * rowStrideOther + (firstColumn - 1) * columnStrideOther]);
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnIntMatrix2D.this.columnStride;
                            int cidxOther = zeroOther + c * columnStrideOther;
                            int r = DenseColumnIntMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                a = aggr.apply(a, f.apply(DenseColumnIntMatrix2D.this.elements[r * DenseColumnIntMatrix2D.this.rowStride + cidx], otherElements[r * rowStrideOther + cidxOther]));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int d = 1;
            a = f.apply(this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride], otherElements[zeroOther + (this.rows - 1) * rowStrideOther + (this.columns - 1) * columnStrideOther]);
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int cidxOther = zeroOther + c * columnStrideOther;
                int r = this.rows - d;
                while (--r >= 0) {
                    a = aggr.apply(a, f.apply(this.elements[r * this.rowStride + cidx], otherElements[r * rowStrideOther + cidxOther]));
                }
                d = 0;
            }
        }
        return a;
    }

    @Override
    public IntMatrix2D assign(final IntFunction function) {
        if (function instanceof IntMult) {
            int multiplicator = ((IntMult)function).multiplicator;
            if (multiplicator == 1) {
                return this;
            }
            if (multiplicator == 0) {
                return this.assign(0);
            }
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        if (function instanceof IntMult) {
                            int multiplicator = ((IntMult)function).multiplicator;
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnIntMatrix2D.this.rows;
                                while (--r >= 0) {
                                    int n = i;
                                    DenseColumnIntMatrix2D.this.elements[n] = DenseColumnIntMatrix2D.this.elements[n] * multiplicator;
                                    i -= DenseColumnIntMatrix2D.this.rowStride;
                                }
                                idx -= DenseColumnIntMatrix2D.this.columnStride;
                            }
                        } else {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnIntMatrix2D.this.rows;
                                while (--r >= 0) {
                                    DenseColumnIntMatrix2D.this.elements[i] = function.apply(DenseColumnIntMatrix2D.this.elements[i]);
                                    i -= DenseColumnIntMatrix2D.this.rowStride;
                                }
                                idx -= DenseColumnIntMatrix2D.this.columnStride;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            if (function instanceof IntMult) {
                int multiplicator = ((IntMult)function).multiplicator;
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        int n = i;
                        this.elements[n] = this.elements[n] * multiplicator;
                        i -= this.rowStride;
                    }
                    idx -= this.columnStride;
                }
            } else {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        this.elements[i] = function.apply(this.elements[i]);
                        i -= this.rowStride;
                    }
                    idx -= this.columnStride;
                }
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(final IntProcedure cond, final IntFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnIntMatrix2D.this.rows;
                            while (--r >= 0) {
                                int elem = DenseColumnIntMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseColumnIntMatrix2D.this.elements[i] = function.apply(elem);
                                }
                                i -= DenseColumnIntMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnIntMatrix2D.this.columnStride;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    int elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = function.apply(elem);
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(final IntProcedure cond, final int value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnIntMatrix2D.this.rows;
                            while (--r >= 0) {
                                int elem = DenseColumnIntMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseColumnIntMatrix2D.this.elements[i] = value;
                                }
                                i -= DenseColumnIntMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnIntMatrix2D.this.columnStride;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    int elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = value;
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(final int value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnIntMatrix2D.this.rows;
                            while (--r >= 0) {
                                DenseColumnIntMatrix2D.this.elements[i] = value;
                                i -= DenseColumnIntMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnIntMatrix2D.this.columnStride;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    this.elements[i] = value;
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(final int[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstColumn = this.columns - j * k;
                    final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride;
                            int idxOther = DenseColumnIntMatrix2D.this.rows - 1 + (firstColumn - 1) * DenseColumnIntMatrix2D.this.rows;
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnIntMatrix2D.this.rows;
                                while (--r >= 0) {
                                    DenseColumnIntMatrix2D.this.elements[i] = values[idxOther--];
                                    i -= DenseColumnIntMatrix2D.this.rowStride;
                                }
                                idx -= DenseColumnIntMatrix2D.this.columnStride;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int idxOther = values.length - 1;
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        this.elements[i] = values[idxOther--];
                        i -= this.rowStride;
                    }
                    idx -= this.columnStride;
                }
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(final int[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "columns()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (firstRow - 1) * DenseColumnIntMatrix2D.this.rowStride + (DenseColumnIntMatrix2D.this.columns - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int r = firstRow;
                        while (--r >= lastRow) {
                            int[] currentRow = values[r];
                            if (currentRow.length != DenseColumnIntMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: column=" + currentRow.length + "columns()=" + DenseColumnIntMatrix2D.this.columns());
                            }
                            int i = idx;
                            int c = DenseColumnIntMatrix2D.this.columns;
                            while (--c >= 0) {
                                DenseColumnIntMatrix2D.this.elements[i] = currentRow[c];
                                i -= DenseColumnIntMatrix2D.this.columnStride;
                            }
                            idx -= DenseColumnIntMatrix2D.this.rowStride;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int r = this.rows;
            while (--r >= 0) {
                int[] currentRow = values[r];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: column=" + currentRow.length + "columns()=" + this.columns());
                }
                int i = idx;
                int c = this.columns;
                while (--c >= 0) {
                    this.elements[i] = currentRow[c];
                    i -= this.columnStride;
                }
                idx -= this.rowStride;
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(IntMatrix2D source) {
        if (!(source instanceof DenseColumnIntMatrix2D)) {
            super.assign(source);
            return this;
        }
        DenseColumnIntMatrix2D other = (DenseColumnIntMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            IntMatrix2D c = other.copy();
            if (!(c instanceof DenseColumnIntMatrix2D)) {
                super.assign(other);
                return this;
            }
            other = (DenseColumnIntMatrix2D)c;
        }
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        final int[] otherElements = other.elements;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int idxOther = zeroOther + (DenseColumnIntMatrix2D.this.rows - 1) * rowStrideOther + (firstColumn - 1) * columnStrideOther;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = DenseColumnIntMatrix2D.this.rows;
                            while (--r >= 0) {
                                DenseColumnIntMatrix2D.this.elements[i] = otherElements[j];
                                i -= DenseColumnIntMatrix2D.this.rowStride;
                                j -= rowStrideOther;
                            }
                            idx -= DenseColumnIntMatrix2D.this.columnStride;
                            idxOther -= columnStrideOther;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxOther = zeroOther + (this.rows - 1) * rowStrideOther + (this.columns - 1) * columnStrideOther;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int j = idxOther;
                int r = this.rows;
                while (--r >= 0) {
                    this.elements[i] = otherElements[j];
                    i -= this.rowStride;
                    j -= rowStrideOther;
                }
                idx -= this.columnStride;
                idxOther -= columnStrideOther;
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(IntMatrix2D y, final IntIntFunction function) {
        int multiplicator;
        if (function instanceof IntPlusMultSecond && (multiplicator = ((IntPlusMultSecond)function).multiplicator) == 0) {
            return this;
        }
        if (function instanceof IntPlusMultFirst && (multiplicator = ((IntPlusMultFirst)function).multiplicator) == 0) {
            return this.assign(y);
        }
        if (!(y instanceof DenseColumnIntMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        DenseColumnIntMatrix2D other = (DenseColumnIntMatrix2D)y;
        this.checkShape(y);
        final int[] otherElements = other.elements;
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int idxOther = zeroOther + (DenseColumnIntMatrix2D.this.rows - 1) * rowStrideOther + (firstColumn - 1) * columnStrideOther;
                        if (function == IntFunctions.mult) {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = DenseColumnIntMatrix2D.this.rows;
                                while (--r >= 0) {
                                    int n = i;
                                    DenseColumnIntMatrix2D.this.elements[n] = DenseColumnIntMatrix2D.this.elements[n] * otherElements[j];
                                    i -= DenseColumnIntMatrix2D.this.rowStride;
                                    j -= rowStrideOther;
                                }
                                idx -= DenseColumnIntMatrix2D.this.columnStride;
                                idxOther -= columnStrideOther;
                            }
                        } else if (function == IntFunctions.div) {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = DenseColumnIntMatrix2D.this.rows;
                                while (--r >= 0) {
                                    int n = i;
                                    DenseColumnIntMatrix2D.this.elements[n] = DenseColumnIntMatrix2D.this.elements[n] / otherElements[j];
                                    i -= DenseColumnIntMatrix2D.this.rowStride;
                                    j -= rowStrideOther;
                                }
                                idx -= DenseColumnIntMatrix2D.this.columnStride;
                                idxOther -= columnStrideOther;
                            }
                        } else if (function instanceof IntPlusMultSecond) {
                            int multiplicator = ((IntPlusMultSecond)function).multiplicator;
                            if (multiplicator == 1) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnIntMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnIntMatrix2D.this.elements[n] = DenseColumnIntMatrix2D.this.elements[n] + otherElements[j];
                                        i -= DenseColumnIntMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnIntMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else if (multiplicator == -1) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnIntMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnIntMatrix2D.this.elements[n] = DenseColumnIntMatrix2D.this.elements[n] - otherElements[j];
                                        i -= DenseColumnIntMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnIntMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnIntMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnIntMatrix2D.this.elements[n] = DenseColumnIntMatrix2D.this.elements[n] + multiplicator * otherElements[j];
                                        i -= DenseColumnIntMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnIntMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            }
                        } else if (function instanceof IntPlusMultFirst) {
                            int multiplicator = ((IntPlusMultFirst)function).multiplicator;
                            if (multiplicator == 1) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnIntMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnIntMatrix2D.this.elements[n] = DenseColumnIntMatrix2D.this.elements[n] + otherElements[j];
                                        i -= DenseColumnIntMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnIntMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else if (multiplicator == -1) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnIntMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        DenseColumnIntMatrix2D.this.elements[i] = otherElements[j] - DenseColumnIntMatrix2D.this.elements[i];
                                        i -= DenseColumnIntMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnIntMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnIntMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        DenseColumnIntMatrix2D.this.elements[i] = multiplicator * DenseColumnIntMatrix2D.this.elements[i] + otherElements[j];
                                        i -= DenseColumnIntMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnIntMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            }
                        } else {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = DenseColumnIntMatrix2D.this.rows;
                                while (--r >= 0) {
                                    DenseColumnIntMatrix2D.this.elements[i] = function.apply(DenseColumnIntMatrix2D.this.elements[i], otherElements[j]);
                                    i -= DenseColumnIntMatrix2D.this.rowStride;
                                    j -= rowStrideOther;
                                }
                                idx -= DenseColumnIntMatrix2D.this.columnStride;
                                idxOther -= columnStrideOther;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxOther = zeroOther + (this.rows - 1) * rowStrideOther + (this.columns - 1) * columnStrideOther;
            if (function == IntFunctions.mult) {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int j = idxOther;
                    int r = this.rows;
                    while (--r >= 0) {
                        int n = i;
                        this.elements[n] = this.elements[n] * otherElements[j];
                        i -= this.rowStride;
                        j -= rowStrideOther;
                    }
                    idx -= this.columnStride;
                    idxOther -= columnStrideOther;
                }
            } else if (function == IntFunctions.div) {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int j = idxOther;
                    int r = this.rows;
                    while (--r >= 0) {
                        int n = i;
                        this.elements[n] = this.elements[n] / otherElements[j];
                        i -= this.rowStride;
                        j -= rowStrideOther;
                    }
                    idx -= this.columnStride;
                    idxOther -= columnStrideOther;
                }
            } else if (function instanceof IntPlusMultSecond) {
                int multiplicator2 = ((IntPlusMultSecond)function).multiplicator;
                if (multiplicator2 == 1) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] + otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else if (multiplicator2 == -1) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] - otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] + multiplicator2 * otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                }
            } else if (function instanceof IntPlusMultFirst) {
                int multiplicator3 = ((IntPlusMultFirst)function).multiplicator;
                if (multiplicator3 == 1) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] + otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else if (multiplicator3 == -1) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            this.elements[i] = otherElements[j] - this.elements[i];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            this.elements[i] = multiplicator3 * this.elements[i] + otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                }
            } else {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int j = idxOther;
                    int r = this.rows;
                    while (--r >= 0) {
                        this.elements[i] = function.apply(this.elements[i], otherElements[j]);
                        i -= this.rowStride;
                        j -= rowStrideOther;
                    }
                    idx -= this.columnStride;
                    idxOther -= columnStrideOther;
                }
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(IntMatrix2D y, final IntIntFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        if (!(y instanceof DenseColumnIntMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        DenseColumnIntMatrix2D other = (DenseColumnIntMatrix2D)y;
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final int[] otherElements = other.elements();
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride();
        final int rowStrideOther = other.rowStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = size - j * k;
                final int lastIdx = j == nthreads - 1 ? 0 : firstIdx - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (--i >= lastIdx) {
                            int idx = zero + rowElements[i] * DenseColumnIntMatrix2D.this.rowStride + columnElements[i] * DenseColumnIntMatrix2D.this.columnStride;
                            int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseColumnIntMatrix2D.this.elements[idx] = function.apply(DenseColumnIntMatrix2D.this.elements[idx], otherElements[idxOther]);
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = size;
            while (--i >= 0) {
                int idx = zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], otherElements[idxOther]);
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnIntMatrix2D.this.rows;
                            while (--r >= 0) {
                                if (DenseColumnIntMatrix2D.this.elements[i] != 0) {
                                    ++cardinality;
                                }
                                i -= DenseColumnIntMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnIntMatrix2D.this.columnStride;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    if (this.elements[i] != 0) {
                        ++cardinality;
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return cardinality;
    }

    public int[] elements() {
        return this.elements;
    }

    @Override
    public IntMatrix2D forEachNonZero(final IntIntIntFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnIntMatrix2D.this.rows;
                            while (--r >= 0) {
                                int value = DenseColumnIntMatrix2D.this.elements[i];
                                if (value != 0) {
                                    DenseColumnIntMatrix2D.this.elements[i] = function.apply(r, c, value);
                                }
                                i -= DenseColumnIntMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnIntMatrix2D.this.columnStride;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    int value = this.elements[i];
                    if (value != 0) {
                        this.elements[i] = function.apply(r, c, value);
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    public DenseIntMatrix2D getRowMajor() {
        DenseIntMatrix2D R = new DenseIntMatrix2D(this.rows, this.columns);
        final int zeroR = (int)R.index(0, 0);
        final int rowStrideR = R.rowStride();
        final int columnStrideR = R.columnStride();
        final int[] elementsR = R.elements();
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int idxR = zeroR + (DenseColumnIntMatrix2D.this.rows - 1) * rowStrideR + (firstColumn - 1) * columnStrideR;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int j = idxR;
                            int r = DenseColumnIntMatrix2D.this.rows;
                            while (--r >= 0) {
                                elementsR[j] = DenseColumnIntMatrix2D.this.elements[i];
                                i -= DenseColumnIntMatrix2D.this.rowStride;
                                j -= rowStrideR;
                            }
                            idx -= DenseColumnIntMatrix2D.this.columnStride;
                            idxR -= columnStrideR;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxR = zeroR + (this.rows - 1) * rowStrideR + (this.columns - 1) * columnStrideR;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int j = idxR;
                int r = this.rows;
                while (--r >= 0) {
                    elementsR[j] = this.elements[i];
                    i -= this.rowStride;
                    j -= rowStrideR;
                }
                idx -= this.columnStride;
                idxR -= columnStrideR;
            }
        }
        return R;
    }

    @Override
    public void getNegativeValues(IntArrayList rowList, IntArrayList columnList, IntArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        int c = 0;
        while (c < this.columns) {
            int i = idx;
            int r = 0;
            while (r < this.rows) {
                int value = this.elements[i];
                if (value < 0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.rowStride;
                ++r;
            }
            idx += this.columnStride;
            ++c;
        }
    }

    @Override
    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, IntArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        int c = 0;
        while (c < this.columns) {
            int i = idx;
            int r = 0;
            while (r < this.rows) {
                int value = this.elements[i];
                if (value != 0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.rowStride;
                ++r;
            }
            idx += this.columnStride;
            ++c;
        }
    }

    @Override
    public void getPositiveValues(IntArrayList rowList, IntArrayList columnList, IntArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        int c = 0;
        while (c < this.columns) {
            int i = idx;
            int r = 0;
            while (r < this.rows) {
                int value = this.elements[i];
                if (value > 0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.rowStride;
                ++r;
            }
            idx += this.columnStride;
            ++c;
        }
    }

    @Override
    public int getQuick(int row, int column) {
        return this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    @Override
    public long index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public IntMatrix2D like(int rows, int columns) {
        return new DenseColumnIntMatrix2D(rows, columns);
    }

    @Override
    public IntMatrix1D like1D(int size) {
        return new DenseIntMatrix1D(size);
    }

    @Override
    public int[] getMaxLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        int maxValue = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int[][] results = new int[nthreads][3];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int maxValue = DenseColumnIntMatrix2D.this.elements[zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride];
                        int rowLocation = DenseColumnIntMatrix2D.this.rows - 1;
                        int columnLocation = firstColumn - 1;
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnIntMatrix2D.this.columnStride;
                            int r = DenseColumnIntMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                int elem = DenseColumnIntMatrix2D.this.elements[r * DenseColumnIntMatrix2D.this.rowStride + cidx];
                                if (maxValue >= elem) continue;
                                maxValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new int[]{maxValue, rowLocation, columnLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (int[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                rowLocation = results[0][1];
                columnLocation = results[0][2];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        rowLocation = results[j][1];
                        columnLocation = results[j][2];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            rowLocation = this.rows - 1;
            columnLocation = this.columns - 1;
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    int elem = this.elements[r * this.rowStride + cidx];
                    if (maxValue >= elem) continue;
                    maxValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new int[]{maxValue, rowLocation, columnLocation};
    }

    @Override
    public int[] getMinLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        int minValue = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int[][] results = new int[nthreads][3];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int minValue = DenseColumnIntMatrix2D.this.elements[zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride];
                        int rowLocation = DenseColumnIntMatrix2D.this.rows - 1;
                        int columnLocation = firstColumn - 1;
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnIntMatrix2D.this.columnStride;
                            int r = DenseColumnIntMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                int elem = DenseColumnIntMatrix2D.this.elements[r * DenseColumnIntMatrix2D.this.rowStride + cidx];
                                if (minValue <= elem) continue;
                                minValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new int[]{minValue, rowLocation, columnLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (int[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                rowLocation = results[0][1];
                columnLocation = results[0][2];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        rowLocation = results[j][1];
                        columnLocation = results[j][2];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            rowLocation = this.rows - 1;
            columnLocation = this.columns - 1;
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    int elem = this.elements[r * this.rowStride + cidx];
                    if (minValue <= elem) continue;
                    minValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new int[]{minValue, rowLocation, columnLocation};
    }

    @Override
    public void setQuick(int row, int column, int value) {
        this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    @Override
    public int[][] toArray() {
        final int[][] values = new int[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnIntMatrix2D.this.rows;
                            while (--r >= 0) {
                                values[r][c] = DenseColumnIntMatrix2D.this.elements[i];
                                i -= DenseColumnIntMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnIntMatrix2D.this.columnStride;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    values[r][c] = this.elements[i];
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return values;
    }

    @Override
    public IntMatrix1D vectorize() {
        int size = (int)this.size();
        DenseIntMatrix1D v = new DenseIntMatrix1D(size);
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, ((IntMatrix1D)v).elements(), 0, size);
        } else {
            final int zero = (int)this.index(0, 0);
            final int zeroOther = (int)((AbstractMatrix1D)v).index(0);
            final int strideOther = v.stride();
            final int[] elementsOther = (int[])((IntMatrix1D)v).elements();
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstColumn = this.columns - j * k;
                    final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                    final int firstIdxOther = size - j * k * this.rows;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride;
                            int idxOther = zeroOther + (firstIdxOther - 1) * strideOther;
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnIntMatrix2D.this.rows;
                                while (--r >= 0) {
                                    elementsOther[idxOther] = DenseColumnIntMatrix2D.this.elements[i];
                                    i -= DenseColumnIntMatrix2D.this.rowStride;
                                    idxOther -= strideOther;
                                }
                                idx -= DenseColumnIntMatrix2D.this.columnStride;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int idxOther = zeroOther + size - 1;
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        elementsOther[idxOther] = this.elements[i];
                        i -= this.rowStride;
                        --idxOther;
                    }
                    idx -= this.columnStride;
                }
            }
        }
        return v;
    }

    @Override
    public int zSum() {
        int sum = 0;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int sum = 0;
                        int idx = zero + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnIntMatrix2D.this.rows;
                            while (--r >= 0) {
                                sum += DenseColumnIntMatrix2D.this.elements[i];
                                i -= DenseColumnIntMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnIntMatrix2D.this.columnStride;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    sum += ((Integer)futures[j].get()).intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    sum += this.elements[i];
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return sum;
    }

    @Override
    protected boolean haveSharedCellsRaw(IntMatrix2D other) {
        if (other instanceof SelectedDenseColumnIntMatrix2D) {
            SelectedDenseColumnIntMatrix2D otherMatrix = (SelectedDenseColumnIntMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseColumnIntMatrix2D) {
            DenseColumnIntMatrix2D otherMatrix = (DenseColumnIntMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected IntMatrix1D like1D(int size, int zero, int stride) {
        return new DenseIntMatrix1D(size, this.elements, zero, stride, true);
    }

    @Override
    protected IntMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseColumnIntMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

