/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.map.tlong.AbstractLongIntMap;
import cern.colt.map.tlong.OpenLongIntHashMap;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.SelectedSparseIntMatrix3D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;

public class SparseIntMatrix3D
extends IntMatrix3D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongIntMap elements;

    public SparseIntMatrix3D(int[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length));
        this.assign(values);
    }

    public SparseIntMatrix3D(int slices, int rows, int columns) {
        this(slices, rows, columns, slices * rows * (columns / 1000), 0.2, 0.5);
    }

    public SparseIntMatrix3D(int slices, int rows, int columns, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        block2: {
            try {
                this.setUp(slices, rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new OpenLongIntHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    protected SparseIntMatrix3D(int slices, int rows, int columns, AbstractLongIntMap elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride) {
        block2: {
            try {
                this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public IntMatrix3D assign(int value) {
        if (this.isNoView && value == 0) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public AbstractLongIntMap elements() {
        return this.elements;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public synchronized int getQuick(int slice, int row, int column) {
        return this.elements.get((long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride);
    }

    @Override
    public long index(int slice, int row, int column) {
        return (long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
    }

    @Override
    public IntMatrix3D like(int slices, int rows, int columns) {
        return new SparseIntMatrix3D(slices, rows, columns);
    }

    @Override
    public IntMatrix2D like2D(int rows, int columns) {
        return new SparseIntMatrix2D(rows, columns);
    }

    @Override
    public synchronized void setQuick(int slice, int row, int column, int value) {
        long index = (long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
        if (value == 0) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.slices).append(" x ").append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    int elem = this.getQuick(s, r, c);
                    if (elem != 0) {
                        builder.append('(').append(s).append(',').append(r).append(',').append(c).append(')').append('\t').append(elem).append('\n');
                    }
                    ++c;
                }
                ++r;
            }
            ++s;
        }
        return builder.toString();
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    public IntMatrix1D vectorize() {
        SparseIntMatrix1D v = new SparseIntMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        int s = 0;
        while (s < this.slices) {
            v.viewPart(s * length, length).assign(this.viewSlice(s).vectorize());
            ++s;
        }
        return v;
    }

    @Override
    protected boolean haveSharedCellsRaw(IntMatrix3D other) {
        if (other instanceof SelectedSparseIntMatrix3D) {
            SelectedSparseIntMatrix3D otherMatrix = (SelectedSparseIntMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseIntMatrix3D) {
            SparseIntMatrix3D otherMatrix = (SparseIntMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected IntMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new SparseIntMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride);
    }

    @Override
    protected IntMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseIntMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }
}

