/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SelectedDenseLongMatrix3D;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseLongMatrix3D
extends LongMatrix3D {
    private static final long serialVersionUID = 1L;
    protected long[] elements;

    public DenseLongMatrix3D(long[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length));
        this.assign(values);
    }

    public DenseLongMatrix3D(int slices, int rows, int columns) {
        this.setUp(slices, rows, columns);
        this.elements = new long[slices * rows * columns];
    }

    public DenseLongMatrix3D(int slices, int rows, int columns, long[] elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride, boolean isView) {
        this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    @Override
    public long aggregate(final LongLongFunction aggr, final LongFunction f) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long a = 0L;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(DenseLongMatrix3D.this.elements[zero + firstSlice * DenseLongMatrix3D.this.sliceStride]);
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseLongMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseLongMatrix3D.this.columns) {
                                    a = aggr.apply(a, f.apply(DenseLongMatrix3D.this.elements[zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride + c * DenseLongMatrix3D.this.columnStride]));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero]);
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        a = aggr.apply(a, f.apply(this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride]));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    @Override
    public long aggregate(final LongLongFunction aggr, final LongFunction f, final LongProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long a = 0L;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long elem = DenseLongMatrix3D.this.elements[zero + firstSlice * DenseLongMatrix3D.this.sliceStride];
                        long a = 0L;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseLongMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseLongMatrix3D.this.columns) {
                                    elem = DenseLongMatrix3D.this.elements[zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride + c * DenseLongMatrix3D.this.columnStride];
                                    if (cond.apply(elem)) {
                                        a = aggr.apply(a, f.apply(elem));
                                    }
                                    d = 0;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            long elem = this.elements[zero];
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        d = 0;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    @Override
    public long aggregate(final LongLongFunction aggr, final LongFunction f, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        if (sliceList.size() == 0 || rowList.size() == 0 || columnList.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final int zero = (int)this.index(0, 0, 0);
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(DenseLongMatrix3D.this.elements[zero + sliceElements[firstIdx] * DenseLongMatrix3D.this.sliceStride + rowElements[firstIdx] * DenseLongMatrix3D.this.rowStride + columnElements[firstIdx] * DenseLongMatrix3D.this.columnStride]);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            long elem = DenseLongMatrix3D.this.elements[zero + sliceElements[i] * DenseLongMatrix3D.this.sliceStride + rowElements[i] * DenseLongMatrix3D.this.rowStride + columnElements[i] * DenseLongMatrix3D.this.columnStride];
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + sliceElements[0] * this.sliceStride + rowElements[0] * this.rowStride + columnElements[0] * this.columnStride]);
            int i = 1;
            while (i < size) {
                long elem = this.elements[zero + sliceElements[i] * this.sliceStride + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride];
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    @Override
    public long aggregate(LongMatrix3D other, final LongLongFunction aggr, final LongLongFunction f) {
        if (!(other instanceof DenseLongMatrix3D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long a = 0L;
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other.index(0, 0, 0);
        final int sliceStrideOther = other.sliceStride();
        final int rowStrideOther = other.rowStride();
        final int colStrideOther = other.columnStride();
        final long[] elemsOther = (long[])other.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int idx = zero + firstSlice * DenseLongMatrix3D.this.sliceStride;
                        int idxOther = zeroOther + firstSlice * sliceStrideOther;
                        long a = f.apply(DenseLongMatrix3D.this.elements[idx], elemsOther[idxOther]);
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseLongMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseLongMatrix3D.this.columns) {
                                    idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride + c * DenseLongMatrix3D.this.columnStride;
                                    idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * colStrideOther;
                                    a = aggr.apply(a, f.apply(DenseLongMatrix3D.this.elements[idx], elemsOther[idxOther]));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0), other.getQuick(0, 0, 0));
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * colStrideOther;
                        a = aggr.apply(a, f.apply(this.elements[idx], elemsOther[idxOther]));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    @Override
    public LongMatrix3D assign(final LongFunction function) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseLongMatrix3D.this.rows) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseLongMatrix3D.this.columns) {
                                    DenseLongMatrix3D.this.elements[idx] = function.apply(DenseLongMatrix3D.this.elements[idx]);
                                    idx += DenseLongMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = function.apply(this.elements[idx]);
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(final long value) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseLongMatrix3D.this.rows) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseLongMatrix3D.this.columns) {
                                    DenseLongMatrix3D.this.elements[idx] = value;
                                    idx += DenseLongMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = value;
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(final long[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idxOther = firstSlice * DenseLongMatrix3D.this.rows * DenseLongMatrix3D.this.columns;
                            int s = firstSlice;
                            while (s < lastSlice) {
                                int r = 0;
                                while (r < DenseLongMatrix3D.this.rows) {
                                    int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                    int c = 0;
                                    while (c < DenseLongMatrix3D.this.columns) {
                                        DenseLongMatrix3D.this.elements[idx] = values[idxOther++];
                                        idx += DenseLongMatrix3D.this.columnStride;
                                        ++c;
                                    }
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idxOther = 0;
                int s = 0;
                while (s < this.slices) {
                    int r = 0;
                    while (r < this.rows) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        int c = 0;
                        while (c < this.columns) {
                            this.elements[idx] = values[idxOther++];
                            idx += this.columnStride;
                            ++c;
                        }
                        ++r;
                    }
                    ++s;
                }
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(final int[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idxOther = firstSlice * DenseLongMatrix3D.this.rows * DenseLongMatrix3D.this.columns;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseLongMatrix3D.this.rows) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseLongMatrix3D.this.columns) {
                                    DenseLongMatrix3D.this.elements[idx] = values[idxOther++];
                                    idx += DenseLongMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idxOther = 0;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = values[idxOther++];
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(final long[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int i = firstSlice * DenseLongMatrix3D.this.sliceStride;
                            int s = firstSlice;
                            while (s < lastSlice) {
                                long[][] currentSlice = values[s];
                                if (currentSlice.length != DenseLongMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseLongMatrix3D.this.rows());
                                }
                                int r = 0;
                                while (r < DenseLongMatrix3D.this.rows) {
                                    long[] currentRow = currentSlice[r];
                                    if (currentRow.length != DenseLongMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseLongMatrix3D.this.columns());
                                    }
                                    System.arraycopy(currentRow, 0, DenseLongMatrix3D.this.elements, i, DenseLongMatrix3D.this.columns);
                                    i += DenseLongMatrix3D.this.columns;
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                int s = 0;
                while (s < this.slices) {
                    long[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    int r = 0;
                    while (r < this.rows) {
                        long[] currentRow = currentSlice[r];
                        if (currentRow.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                        }
                        System.arraycopy(currentRow, 0, this.elements, i, this.columns);
                        i += this.columns;
                        ++r;
                    }
                    ++s;
                }
            }
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int s = firstSlice;
                            while (s < lastSlice) {
                                long[][] currentSlice = values[s];
                                if (currentSlice.length != DenseLongMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseLongMatrix3D.this.rows());
                                }
                                int r = 0;
                                while (r < DenseLongMatrix3D.this.rows) {
                                    int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                    long[] currentRow = currentSlice[r];
                                    if (currentRow.length != DenseLongMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseLongMatrix3D.this.columns());
                                    }
                                    int c = 0;
                                    while (c < DenseLongMatrix3D.this.columns) {
                                        DenseLongMatrix3D.this.elements[idx] = currentRow[c];
                                        idx += DenseLongMatrix3D.this.columnStride;
                                        ++c;
                                    }
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int s = 0;
                while (s < this.slices) {
                    long[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    int r = 0;
                    while (r < this.rows) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        long[] currentRow = currentSlice[r];
                        if (currentRow.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                        }
                        int c = 0;
                        while (c < this.columns) {
                            this.elements[idx] = currentRow[c];
                            idx += this.columnStride;
                            ++c;
                        }
                        ++r;
                    }
                    ++s;
                }
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(final LongProcedure cond, final LongFunction f) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseLongMatrix3D.this.rows) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseLongMatrix3D.this.columns) {
                                    long elem = DenseLongMatrix3D.this.elements[idx];
                                    if (cond.apply(elem)) {
                                        DenseLongMatrix3D.this.elements[idx] = f.apply(elem);
                                    }
                                    idx += DenseLongMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        long elem = this.elements[idx];
                        if (cond.apply(elem)) {
                            this.elements[idx] = f.apply(elem);
                        }
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(final LongProcedure cond, final long value) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseLongMatrix3D.this.rows) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseLongMatrix3D.this.columns) {
                                    long elem = DenseLongMatrix3D.this.elements[idx];
                                    if (cond.apply(elem)) {
                                        DenseLongMatrix3D.this.elements[idx] = value;
                                    }
                                    idx += DenseLongMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        long elem = this.elements[idx];
                        if (cond.apply(elem)) {
                            this.elements[idx] = value;
                        }
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(LongMatrix3D source) {
        if (!(source instanceof DenseLongMatrix3D)) {
            super.assign(source);
            return this;
        }
        DenseLongMatrix3D other = (DenseLongMatrix3D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.haveSharedCells(other)) {
            LongMatrix3D c = other.copy();
            if (!(c instanceof DenseLongMatrix3D)) {
                super.assign(source);
                return this;
            }
            other = (DenseLongMatrix3D)c;
        }
        DenseLongMatrix3D other_final = other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other_final.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other_final.index(0, 0, 0);
        final int sliceStrideOther = other_final.sliceStride;
        final int rowStrideOther = other_final.rowStride;
        final int columnStrideOther = other_final.columnStride;
        final long[] elemsOther = other_final.elements;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseLongMatrix3D.this.rows) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                int c = 0;
                                while (c < DenseLongMatrix3D.this.columns) {
                                    DenseLongMatrix3D.this.elements[idx] = elemsOther[idxOther];
                                    idx += DenseLongMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = elemsOther[idxOther];
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(LongMatrix3D y, final LongLongFunction function) {
        if (!(y instanceof DenseLongMatrix3D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)y.index(0, 0, 0);
        final int sliceStrideOther = y.sliceStride();
        final int rowStrideOther = y.rowStride();
        final int columnStrideOther = y.columnStride();
        final long[] elemsOther = (long[])y.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseLongMatrix3D.this.rows) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                int c = 0;
                                while (c < DenseLongMatrix3D.this.columns) {
                                    DenseLongMatrix3D.this.elements[idx] = function.apply(DenseLongMatrix3D.this.elements[idx], elemsOther[idxOther]);
                                    idx += DenseLongMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = function.apply(this.elements[idx], elemsOther[idxOther]);
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(LongMatrix3D y, final LongLongFunction function, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (!(y instanceof DenseLongMatrix3D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)y.index(0, 0, 0);
        final int sliceStrideOther = y.sliceStride();
        final int rowStrideOther = y.rowStride();
        final int columnStrideOther = y.columnStride();
        final long[] elemsOther = (long[])y.elements();
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            int idx = zero + sliceElements[i] * DenseLongMatrix3D.this.sliceStride + rowElements[i] * DenseLongMatrix3D.this.rowStride + columnElements[i] * DenseLongMatrix3D.this.columnStride;
                            int idxOther = zeroOther + sliceElements[i] * sliceStrideOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseLongMatrix3D.this.elements[idx] = function.apply(DenseLongMatrix3D.this.elements[idx], elemsOther[idxOther]);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                int idx = zero + sliceElements[i] * this.sliceStride + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + sliceElements[i] * sliceStrideOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], elemsOther[idxOther]);
                ++i;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseLongMatrix3D.this.rows) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseLongMatrix3D.this.columns) {
                                    if (DenseLongMatrix3D.this.elements[idx] != 0L) {
                                        ++cardinality;
                                    }
                                    idx += DenseLongMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        if (this.elements[idx] != 0L) {
                            ++cardinality;
                        }
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return cardinality;
    }

    public long[] elements() {
        return this.elements;
    }

    @Override
    public void getNegativeValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, LongArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                int c = 0;
                while (c < this.columns) {
                    long value = this.elements[idx];
                    if (value < 0L) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    idx += this.columnStride;
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    @Override
    public void getNonZeros(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, LongArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                int c = 0;
                while (c < this.columns) {
                    long value = this.elements[idx];
                    if (value != 0L) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    idx += this.columnStride;
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    @Override
    public void getPositiveValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, LongArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                int c = 0;
                while (c < this.columns) {
                    long value = this.elements[idx];
                    if (value > 0L) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    idx += this.columnStride;
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    @Override
    public long getQuick(int slice, int row, int column) {
        return this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    @Override
    public long index(int slice, int row, int column) {
        return this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public LongMatrix3D like(int slices, int rows, int columns) {
        return new DenseLongMatrix3D(slices, rows, columns);
    }

    @Override
    public LongMatrix2D like2D(int rows, int columns) {
        return new DenseLongMatrix2D(rows, columns);
    }

    @Override
    public long[] getMaxLocation() {
        final int zero = (int)this.index(0, 0, 0);
        int slice_loc = 0;
        int row_loc = 0;
        int col_loc = 0;
        long maxValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][2];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int slice_loc = firstSlice;
                        int row_loc = 0;
                        int col_loc = 0;
                        long maxValue = DenseLongMatrix3D.this.elements[zero + firstSlice * DenseLongMatrix3D.this.sliceStride];
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseLongMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseLongMatrix3D.this.columns) {
                                    long elem = DenseLongMatrix3D.this.elements[zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride + c * DenseLongMatrix3D.this.columnStride];
                                    if (maxValue < elem) {
                                        maxValue = elem;
                                        slice_loc = s;
                                        row_loc = r;
                                        col_loc = c;
                                    }
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return new long[]{maxValue, slice_loc, row_loc, col_loc};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (long[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                slice_loc = (int)results[0][1];
                row_loc = (int)results[0][2];
                col_loc = (int)results[0][3];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        slice_loc = (int)results[j][1];
                        row_loc = (int)results[j][2];
                        col_loc = (int)results[j][3];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[zero];
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        long elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (maxValue < elem) {
                            maxValue = elem;
                            slice_loc = s;
                            row_loc = r;
                            col_loc = c;
                        }
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return new long[]{maxValue, slice_loc, row_loc, col_loc};
    }

    @Override
    public long[] getMinLocation() {
        final int zero = (int)this.index(0, 0, 0);
        int slice_loc = 0;
        int row_loc = 0;
        int col_loc = 0;
        long minValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][2];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int slice_loc = firstSlice;
                        int row_loc = 0;
                        int col_loc = 0;
                        long minValue = DenseLongMatrix3D.this.elements[zero + slice_loc * DenseLongMatrix3D.this.sliceStride];
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseLongMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseLongMatrix3D.this.columns) {
                                    long elem = DenseLongMatrix3D.this.elements[zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride + c * DenseLongMatrix3D.this.columnStride];
                                    if (minValue > elem) {
                                        minValue = elem;
                                        slice_loc = s;
                                        row_loc = r;
                                        col_loc = c;
                                    }
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return new long[]{minValue, slice_loc, row_loc, col_loc};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (long[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                slice_loc = (int)results[0][1];
                row_loc = (int)results[0][2];
                col_loc = (int)results[0][3];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        slice_loc = (int)results[j][1];
                        row_loc = (int)results[j][2];
                        col_loc = (int)results[j][3];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[zero];
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        long elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (minValue > elem) {
                            minValue = elem;
                            slice_loc = s;
                            row_loc = r;
                            col_loc = c;
                        }
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return new long[]{minValue, slice_loc, row_loc, col_loc};
    }

    @Override
    public void setQuick(int slice, int row, int column, long value) {
        this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    @Override
    public long[][][] toArray() {
        final long[][][] values = new long[this.slices][this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            long[][] currentSlice = values[s];
                            int r = 0;
                            while (r < DenseLongMatrix3D.this.rows) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                long[] currentRow = currentSlice[r];
                                int c = 0;
                                while (c < DenseLongMatrix3D.this.columns) {
                                    currentRow[c] = DenseLongMatrix3D.this.elements[idx];
                                    idx += DenseLongMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                long[][] currentSlice = values[s];
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    long[] currentRow = currentSlice[r];
                    int c = 0;
                    while (c < this.columns) {
                        currentRow[c] = this.elements[idx];
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return values;
    }

    @Override
    public LongMatrix1D vectorize() {
        DenseLongMatrix1D v = new DenseLongMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        int s = 0;
        while (s < this.slices) {
            v.viewPart(s * length, length).assign(this.viewSlice(s).vectorize());
            ++s;
        }
        return v;
    }

    @Override
    public long zSum() {
        long sum = 0L;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long sum = 0L;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseLongMatrix3D.this.rows) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseLongMatrix3D.this.columns) {
                                    sum += DenseLongMatrix3D.this.elements[idx];
                                    idx += DenseLongMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    sum += ((Long)futures[j].get()).longValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        sum += this.elements[idx];
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return sum;
    }

    @Override
    protected boolean haveSharedCellsRaw(LongMatrix3D other) {
        if (other instanceof SelectedDenseLongMatrix3D) {
            SelectedDenseLongMatrix3D otherMatrix = (SelectedDenseLongMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseLongMatrix3D) {
            DenseLongMatrix3D otherMatrix = (DenseLongMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected LongMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new DenseLongMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride, true);
    }

    @Override
    protected LongMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseLongMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }
}

