/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.algo;

import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.Former;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;

public class ObjectFormatter
extends AbstractFormatter {
    private static final long serialVersionUID = 1L;

    public ObjectFormatter() {
        this("left");
    }

    public ObjectFormatter(String alignment) {
        this.setAlignment(alignment);
    }

    @Override
    protected String form(AbstractMatrix1D matrix, int index, Former formatter) {
        return this.form((ObjectMatrix1D)matrix, index, formatter);
    }

    protected String form(ObjectMatrix1D matrix, int index, Former formatter) {
        Object value = matrix.get(index);
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }

    @Override
    protected String[][] format(AbstractMatrix2D matrix) {
        return this.format((ObjectMatrix2D)matrix);
    }

    protected String[][] format(ObjectMatrix2D matrix) {
        String[][] strings = new String[matrix.rows()][matrix.columns()];
        int row = matrix.rows();
        while (--row >= 0) {
            strings[row] = this.formatRow(matrix.viewRow(row));
        }
        return strings;
    }

    public String toSourceCode(ObjectMatrix1D matrix) {
        ObjectFormatter copy = (ObjectFormatter)this.clone();
        copy.setPrintShape(false);
        copy.setColumnSeparator(", ");
        String lead = "{";
        String trail = "};";
        return String.valueOf(lead) + copy.toString(matrix) + trail;
    }

    public String toSourceCode(ObjectMatrix2D matrix) {
        ObjectFormatter copy = (ObjectFormatter)this.clone();
        String b3 = this.blanks(3);
        copy.setPrintShape(false);
        copy.setColumnSeparator(", ");
        copy.setRowSeparator("},\n" + b3 + "{");
        String lead = "{\n" + b3 + "{";
        String trail = "}\n};";
        return String.valueOf(lead) + copy.toString(matrix) + trail;
    }

    public String toSourceCode(ObjectMatrix3D matrix) {
        ObjectFormatter copy = (ObjectFormatter)this.clone();
        String b3 = this.blanks(3);
        String b6 = this.blanks(6);
        copy.setPrintShape(false);
        copy.setColumnSeparator(", ");
        copy.setRowSeparator("},\n" + b6 + "{");
        copy.setSliceSeparator("}\n" + b3 + "},\n" + b3 + "{\n" + b6 + "{");
        String lead = "{\n" + b3 + "{\n" + b6 + "{";
        String trail = "}\n" + b3 + "}\n}";
        return String.valueOf(lead) + copy.toString(matrix) + trail;
    }

    @Override
    protected String toString(AbstractMatrix2D matrix) {
        return this.toString((ObjectMatrix2D)matrix);
    }

    public String toString(ObjectMatrix1D matrix) {
        ObjectMatrix2D easy = matrix.like2D(1, (int)matrix.size());
        easy.viewRow(0).assign(matrix);
        return this.toString(easy);
    }

    public String toString(ObjectMatrix2D matrix) {
        return super.toString(matrix);
    }

    public String toString(ObjectMatrix3D matrix) {
        StringBuffer buf = new StringBuffer();
        boolean oldPrintShape = this.printShape;
        this.printShape = false;
        int slice = 0;
        while (slice < matrix.slices()) {
            if (slice != 0) {
                buf.append(this.sliceSeparator);
            }
            buf.append(this.toString(matrix.viewSlice(slice)));
            ++slice;
        }
        this.printShape = oldPrintShape;
        if (this.printShape) {
            buf.insert(0, String.valueOf(ObjectFormatter.shape(matrix)) + "\n");
        }
        return buf.toString();
    }

    public String toTitleString(ObjectMatrix2D matrix, String[] rowNames, String[] columnNames, String rowAxisName, String columnAxisName, String title) {
        int i;
        if (matrix.size() == 0L) {
            return "Empty matrix";
        }
        String oldFormat = this.format;
        this.format = "left";
        int rows = matrix.rows();
        int columns = matrix.columns();
        int r = 0;
        int c = 0;
        c += rowNames == null ? 0 : 1;
        c += rowAxisName == null ? 0 : 1;
        int height = (r += columnNames == null ? 0 : 1) + Math.max(rows, rowAxisName == null ? 0 : rowAxisName.length());
        int width = (c += rowNames != null || rowAxisName != null ? 1 : 0) + columns;
        ObjectMatrix2D titleMatrix = matrix.like(height, width);
        titleMatrix.viewPart(r, c, rows, columns).assign(matrix);
        if (r > 0) {
            titleMatrix.viewRow(0).viewPart(c, columns).assign(columnNames);
        }
        if (rowAxisName != null) {
            Object[] rowAxisStrings = new String[rowAxisName.length()];
            int i2 = rowAxisName.length();
            while (--i2 >= 0) {
                rowAxisStrings[i2] = rowAxisName.substring(i2, i2 + 1);
            }
            titleMatrix.viewColumn(0).viewPart(r, rowAxisName.length()).assign(rowAxisStrings);
        }
        if (rowNames != null) {
            titleMatrix.viewColumn(c - 2).viewPart(r, rows).assign(rowNames);
        }
        if (c > 0) {
            titleMatrix.viewColumn(c - 2 + 1).viewPart(0, rows + r).assign("|");
        }
        boolean oldPrintShape = this.printShape;
        this.printShape = false;
        String str = this.toString(titleMatrix);
        this.printShape = oldPrintShape;
        StringBuffer total = new StringBuffer(str);
        if (columnNames != null) {
            i = str.indexOf(this.rowSeparator);
            total.insert(i + 1, String.valueOf(this.repeat('-', i)) + this.rowSeparator);
        } else if (columnAxisName != null) {
            i = str.indexOf(this.rowSeparator);
            total.insert(0, String.valueOf(this.repeat('-', i)) + this.rowSeparator);
        }
        if (columnAxisName != null) {
            int j = 0;
            if (c > 0) {
                j = str.indexOf(124);
            }
            String s = this.blanks(j);
            if (c > 0) {
                s = String.valueOf(s) + "| ";
            }
            s = String.valueOf(s) + columnAxisName + "\n";
            total.insert(0, s);
        }
        if (title != null) {
            total.insert(0, String.valueOf(title) + "\n");
        }
        this.format = oldFormat;
        return total.toString();
    }

    public String toTitleString(ObjectMatrix3D matrix, String[] sliceNames, String[] rowNames, String[] columnNames, String sliceAxisName, String rowAxisName, String columnAxisName, String title) {
        if (matrix.size() == 0L) {
            return "Empty matrix";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < matrix.slices()) {
            if (i != 0) {
                buf.append(this.sliceSeparator);
            }
            buf.append(this.toTitleString(matrix.viewSlice(i), rowNames, columnNames, rowAxisName, columnAxisName, String.valueOf(title) + "\n" + sliceAxisName + "=" + sliceNames[i]));
            ++i;
        }
        return buf.toString();
    }
}

