/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;

public class WrapperObjectMatrix1D
extends ObjectMatrix1D {
    private static final long serialVersionUID = 1L;
    protected ObjectMatrix1D content;

    public WrapperObjectMatrix1D(ObjectMatrix1D newContent) {
        if (newContent != null) {
            this.setUp((int)newContent.size());
        }
        this.content = newContent;
    }

    @Override
    protected ObjectMatrix1D getContent() {
        return this.content;
    }

    @Override
    public synchronized Object getQuick(int index) {
        return this.content.getQuick(index);
    }

    @Override
    public Object elements() {
        return this.content.elements();
    }

    @Override
    public ObjectMatrix1D like(int size) {
        return this.content.like(size);
    }

    @Override
    public ObjectMatrix2D like2D(int rows, int columns) {
        return this.content.like2D(rows, columns);
    }

    @Override
    public ObjectMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public ObjectMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public synchronized void setQuick(int index, Object value) {
        this.content.setQuick(index, value);
    }

    @Override
    public ObjectMatrix1D viewFlip() {
        WrapperObjectMatrix1D view = new WrapperObjectMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Object getQuick(int index) {
                return this.content.getQuick(this.size - 1 - index);
            }

            @Override
            public synchronized void setQuick(int index, Object value) {
                this.content.setQuick(this.size - 1 - index, value);
            }

            @Override
            public synchronized Object get(int index) {
                return this.content.get(this.size - 1 - index);
            }

            @Override
            public synchronized void set(int index, Object value) {
                this.content.set(this.size - 1 - index, value);
            }
        };
        return view;
    }

    @Override
    public ObjectMatrix1D viewPart(final int index, int width) {
        this.checkRange(index, width);
        WrapperObjectMatrix1D view = new WrapperObjectMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Object getQuick(int i) {
                return this.content.getQuick(index + i);
            }

            @Override
            public synchronized void setQuick(int i, Object value) {
                this.content.setQuick(index + i, value);
            }

            @Override
            public synchronized Object get(int i) {
                return this.content.get(index + i);
            }

            @Override
            public synchronized void set(int i, Object value) {
                this.content.set(index + i, value);
            }
        };
        view.setSize(width);
        return view;
    }

    @Override
    public ObjectMatrix1D viewSelection(int[] indexes) {
        if (indexes == null) {
            indexes = new int[this.size];
            int i = this.size;
            while (--i >= 0) {
                indexes[i] = i;
            }
        }
        this.checkIndexes(indexes);
        final int[] idx = indexes;
        WrapperObjectMatrix1D view = new WrapperObjectMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Object getQuick(int i) {
                return this.content.getQuick(idx[i]);
            }

            @Override
            public synchronized void setQuick(int i, Object value) {
                this.content.setQuick(idx[i], value);
            }

            @Override
            public synchronized Object get(int i) {
                return this.content.get(idx[i]);
            }

            @Override
            public synchronized void set(int i, Object value) {
                this.content.set(idx[i], value);
            }
        };
        view.setSize(indexes.length);
        return view;
    }

    @Override
    protected ObjectMatrix1D viewSelectionLike(int[] offsets) {
        throw new InternalError();
    }

    @Override
    public ObjectMatrix1D viewStrides(final int _stride) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperObjectMatrix1D view = new WrapperObjectMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Object getQuick(int index) {
                return this.content.getQuick(index * _stride);
            }

            @Override
            public synchronized void setQuick(int index, Object value) {
                this.content.setQuick(index * _stride, value);
            }

            @Override
            public synchronized Object get(int index) {
                return this.content.get(index * _stride);
            }

            @Override
            public synchronized void set(int index, Object value) {
                this.content.set(index * _stride, value);
            }
        };
        view.setSize(this.size);
        if (this.size != 0) {
            view.setSize((this.size - 1) / _stride + 1);
        }
        return view;
    }
}

