/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tfcomplex;

import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.jet.math.tfcomplex.FComplex;

public final class FComplexMult
implements FComplexFComplexFunction {
    public float[] multiplicator;

    protected FComplexMult(float[] multiplicator) {
        this.multiplicator = multiplicator;
    }

    @Override
    public final float[] apply(float[] a) {
        float[] z = new float[]{a[0] * this.multiplicator[0] - a[1] * this.multiplicator[1], a[1] * this.multiplicator[0] + a[0] * this.multiplicator[1]};
        return z;
    }

    @Override
    public final float[] apply(float re, float im) {
        float[] z = new float[]{re * this.multiplicator[0] - im * this.multiplicator[1], im * this.multiplicator[0] + re * this.multiplicator[1]};
        return z;
    }

    public static FComplexMult div(float[] constant) {
        return FComplexMult.mult(FComplex.inv(constant));
    }

    public static FComplexMult mult(float[] constant) {
        return new FComplexMult(constant);
    }
}

